/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.service_alt;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.os.Bundle;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import com.android.mms.service_alt.MmsConfigXmlProcessor;
import com.android.mms.service_alt.PhoneUtils;
import com.android.mms.service_alt.SystemPropertiesProxy;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.R;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xmlpull.v1.XmlPullParser;

public class MmsConfig {
    private static final String TAG = "MmsConfig";
    private static final String DEFAULT_HTTP_KEY_X_WAP_PROFILE = "x-wap-profile";
    private static final int MAX_IMAGE_HEIGHT = 480;
    private static final int MAX_IMAGE_WIDTH = 640;
    private static final int MAX_TEXT_LENGTH = 2000;
    public static final String CONFIG_ENABLED_MMS = "enabledMMS";
    public static final String CONFIG_ENABLED_TRANS_ID = "enabledTransID";
    public static final String CONFIG_ENABLED_NOTIFY_WAP_MMSC = "enabledNotifyWapMMSC";
    public static final String CONFIG_ALIAS_ENABLED = "aliasEnabled";
    public static final String CONFIG_ALLOW_ATTACH_AUDIO = "allowAttachAudio";
    public static final String CONFIG_ENABLE_MULTIPART_SMS = "enableMultipartSMS";
    public static final String CONFIG_ENABLE_SMS_DELIVERY_REPORTS = "enableSMSDeliveryReports";
    public static final String CONFIG_ENABLE_GROUP_MMS = "enableGroupMms";
    public static final String CONFIG_SUPPORT_MMS_CONTENT_DISPOSITION = "supportMmsContentDisposition";
    public static final String CONFIG_CELL_BROADCAST_APP_LINKS = "config_cellBroadcastAppLinks";
    public static final String CONFIG_SEND_MULTIPART_SMS_AS_SEPARATE_MESSAGES = "sendMultipartSmsAsSeparateMessages";
    public static final String CONFIG_ENABLE_MMS_READ_REPORTS = "enableMMSReadReports";
    public static final String CONFIG_ENABLE_MMS_DELIVERY_REPORTS = "enableMMSDeliveryReports";
    public static final String CONFIG_SUPPORT_HTTP_CHARSET_HEADER = "supportHttpCharsetHeader";
    public static final String CONFIG_MAX_MESSAGE_SIZE = "maxMessageSize";
    public static final String CONFIG_MAX_IMAGE_HEIGHT = "maxImageHeight";
    public static final String CONFIG_MAX_IMAGE_WIDTH = "maxImageWidth";
    public static final String CONFIG_RECIPIENT_LIMIT = "recipientLimit";
    public static final String CONFIG_HTTP_SOCKET_TIMEOUT = "httpSocketTimeout";
    public static final String CONFIG_ALIAS_MIN_CHARS = "aliasMinChars";
    public static final String CONFIG_ALIAS_MAX_CHARS = "aliasMaxChars";
    public static final String CONFIG_SMS_TO_MMS_TEXT_THRESHOLD = "smsToMmsTextThreshold";
    public static final String CONFIG_SMS_TO_MMS_TEXT_LENGTH_THRESHOLD = "smsToMmsTextLengthThreshold";
    public static final String CONFIG_MAX_MESSAGE_TEXT_SIZE = "maxMessageTextSize";
    public static final String CONFIG_MAX_SUBJECT_LENGTH = "maxSubjectLength";
    public static final String CONFIG_UA_PROF_TAG_NAME = "uaProfTagName";
    public static final String CONFIG_USER_AGENT = "userAgent";
    public static final String CONFIG_UA_PROF_URL = "uaProfUrl";
    public static final String CONFIG_HTTP_PARAMS = "httpParams";
    public static final String CONFIG_EMAIL_GATEWAY_NUMBER = "emailGatewayNumber";
    public static final String CONFIG_NAI_SUFFIX = "naiSuffix";
    public static final String KEY_TYPE_INT = "int";
    public static final String KEY_TYPE_BOOL = "bool";
    public static final String KEY_TYPE_STRING = "string";
    public static final String MACRO_LINE1 = "LINE1";
    public static final String MACRO_LINE1NOCOUNTRYCODE = "LINE1NOCOUNTRYCODE";
    public static final String MACRO_NAI = "NAI";
    private static final Map<String, Object> DEFAULTS = new ConcurrentHashMap<String, Object>();
    private final int mSubId;
    private String mUserAgent = null;
    private String mUaProfUrl = null;
    private final Map<String, Object> mKeyValues = new ConcurrentHashMap<String, Object>();

    public MmsConfig(Context context, int subId) {
        this.mSubId = subId;
        this.mKeyValues.clear();
        this.mKeyValues.putAll(DEFAULTS);
        this.loadDeviceUaSettings(context);
        Log.v((String)TAG, (String)("MmsConfig: mUserAgent=" + this.mUserAgent + ", mUaProfUrl=" + this.mUaProfUrl));
        this.loadFromResources(context);
        Log.v((String)TAG, (String)("MmsConfig: all settings -- " + this.mKeyValues));
    }

    public MmsConfig(Context context) {
        this.mSubId = -1;
        this.mKeyValues.clear();
        this.mKeyValues.putAll(DEFAULTS);
        this.loadDeviceUaSettings(context);
        Log.v((String)TAG, (String)("MmsConfig: mUserAgent=" + this.mUserAgent + ", mUaProfUrl=" + this.mUaProfUrl));
        this.loadFromResources(context);
        Log.v((String)TAG, (String)("MmsConfig: all settings -- " + this.mKeyValues));
    }

    public int getSubId() {
        return this.mSubId;
    }

    public static boolean isValidKey(String key, String type) {
        if (!TextUtils.isEmpty((CharSequence)key) && DEFAULTS.containsKey(key)) {
            Class valueType;
            Object defVal = DEFAULTS.get(key);
            Class clazz = valueType = defVal != null ? defVal.getClass() : String.class;
            if (KEY_TYPE_INT.equals(type)) {
                return valueType == Integer.class;
            }
            if (KEY_TYPE_BOOL.equals(type)) {
                return valueType == Boolean.class;
            }
            if (KEY_TYPE_STRING.equals(type)) {
                return valueType == String.class;
            }
        }
        return false;
    }

    public static boolean isValidValue(String key, Object value) {
        if (!TextUtils.isEmpty((CharSequence)key) && DEFAULTS.containsKey(key)) {
            Object defVal = DEFAULTS.get(key);
            Class valueType = defVal != null ? defVal.getClass() : String.class;
            return value.getClass().equals(valueType);
        }
        return false;
    }

    public Object getValueAsType(String key, String type) {
        if (MmsConfig.isValidKey(key, type)) {
            return this.mKeyValues.get(key);
        }
        return null;
    }

    public Bundle getCarrierConfigValues() {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, Object> entry : this.mKeyValues.entrySet()) {
            Class valueType;
            String key = entry.getKey();
            Object val = entry.getValue();
            Class clazz = valueType = val != null ? val.getClass() : String.class;
            if (valueType == Integer.class) {
                bundle.putInt(key, ((Integer)val).intValue());
                continue;
            }
            if (valueType == Boolean.class) {
                bundle.putBoolean(key, ((Boolean)val).booleanValue());
                continue;
            }
            if (valueType != String.class) continue;
            bundle.putString(key, (String)val);
        }
        return bundle;
    }

    private String getNullableStringValue(String key) {
        Object value = this.mKeyValues.get(key);
        if (value != null) {
            return (String)value;
        }
        return null;
    }

    private void update(String key, String value, String type) {
        try {
            if (KEY_TYPE_INT.equals(type)) {
                this.mKeyValues.put(key, Integer.parseInt(value));
            } else if (KEY_TYPE_BOOL.equals(type)) {
                this.mKeyValues.put(key, Boolean.parseBoolean(value));
            } else if (KEY_TYPE_STRING.equals(type)) {
                this.mKeyValues.put(key, value);
            }
        }
        catch (NumberFormatException e) {
            Log.e((String)TAG, (String)("MmsConfig.update: invalid " + key + "," + value + "," + type));
        }
    }

    private void loadDeviceUaSettings(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (Build.VERSION.SDK_INT >= 19) {
            this.mUserAgent = telephonyManager.getMmsUserAgent();
            this.mUaProfUrl = telephonyManager.getMmsUAProfUrl();
        } else {
            this.mUserAgent = "Android Messaging";
            this.mUaProfUrl = "http://www.gstatic.com/android/hangouts/hangouts_mms_ua_profile.xml";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromResources(Context context) {
        Log.d((String)TAG, (String)"MmsConfig.loadFromResources");
        XmlResourceParser parser = context.getResources().getXml(R.xml.mms_config);
        MmsConfigXmlProcessor processor = MmsConfigXmlProcessor.get((XmlPullParser)parser);
        processor.setMmsConfigHandler(new MmsConfigXmlProcessor.MmsConfigHandler(){

            @Override
            public void process(String key, String value, String type) {
                MmsConfig.this.update(key, value, type);
            }
        });
        try {
            processor.process();
        }
        finally {
            parser.close();
        }
    }

    static {
        DEFAULTS.put(CONFIG_ENABLED_MMS, true);
        DEFAULTS.put(CONFIG_ENABLED_TRANS_ID, false);
        DEFAULTS.put(CONFIG_ENABLED_NOTIFY_WAP_MMSC, false);
        DEFAULTS.put(CONFIG_ALIAS_ENABLED, false);
        DEFAULTS.put(CONFIG_ALLOW_ATTACH_AUDIO, true);
        DEFAULTS.put(CONFIG_ENABLE_MULTIPART_SMS, true);
        DEFAULTS.put(CONFIG_ENABLE_SMS_DELIVERY_REPORTS, true);
        DEFAULTS.put(CONFIG_ENABLE_GROUP_MMS, true);
        DEFAULTS.put(CONFIG_SUPPORT_MMS_CONTENT_DISPOSITION, true);
        DEFAULTS.put(CONFIG_CELL_BROADCAST_APP_LINKS, true);
        DEFAULTS.put(CONFIG_SEND_MULTIPART_SMS_AS_SEPARATE_MESSAGES, false);
        DEFAULTS.put(CONFIG_ENABLE_MMS_READ_REPORTS, false);
        DEFAULTS.put(CONFIG_ENABLE_MMS_DELIVERY_REPORTS, false);
        DEFAULTS.put(CONFIG_SUPPORT_HTTP_CHARSET_HEADER, false);
        DEFAULTS.put(CONFIG_MAX_MESSAGE_SIZE, 307200);
        DEFAULTS.put(CONFIG_MAX_IMAGE_HEIGHT, 480);
        DEFAULTS.put(CONFIG_MAX_IMAGE_WIDTH, 640);
        DEFAULTS.put(CONFIG_RECIPIENT_LIMIT, Integer.MAX_VALUE);
        DEFAULTS.put(CONFIG_HTTP_SOCKET_TIMEOUT, 60000);
        DEFAULTS.put(CONFIG_ALIAS_MIN_CHARS, 2);
        DEFAULTS.put(CONFIG_ALIAS_MAX_CHARS, 48);
        DEFAULTS.put(CONFIG_SMS_TO_MMS_TEXT_THRESHOLD, -1);
        DEFAULTS.put(CONFIG_SMS_TO_MMS_TEXT_LENGTH_THRESHOLD, -1);
        DEFAULTS.put(CONFIG_MAX_MESSAGE_TEXT_SIZE, -1);
        DEFAULTS.put(CONFIG_MAX_SUBJECT_LENGTH, 40);
        DEFAULTS.put(CONFIG_UA_PROF_TAG_NAME, DEFAULT_HTTP_KEY_X_WAP_PROFILE);
        DEFAULTS.put(CONFIG_USER_AGENT, "");
        DEFAULTS.put(CONFIG_UA_PROF_URL, "");
        DEFAULTS.put(CONFIG_HTTP_PARAMS, "");
        DEFAULTS.put(CONFIG_EMAIL_GATEWAY_NUMBER, "");
        DEFAULTS.put(CONFIG_NAI_SUFFIX, "");
    }

    public static class Overridden {
        private final MmsConfig mBase;
        private final Bundle mOverrides;

        public Overridden(MmsConfig base, Bundle overrides) {
            this.mBase = base;
            this.mOverrides = overrides;
        }

        private int getInt(String key) {
            Integer def = (Integer)this.mBase.mKeyValues.get(key);
            return this.mOverrides != null ? this.mOverrides.getInt(key, def.intValue()) : def.intValue();
        }

        private boolean getBoolean(String key) {
            Boolean def = (Boolean)this.mBase.mKeyValues.get(key);
            return this.mOverrides != null ? this.mOverrides.getBoolean(key, def.booleanValue()) : def.booleanValue();
        }

        private String getString(String key) {
            if (this.mOverrides != null && this.mOverrides.containsKey(key)) {
                return this.mOverrides.getString(key);
            }
            return this.mBase.getNullableStringValue(key);
        }

        public int getSmsToMmsTextThreshold() {
            return this.getInt(MmsConfig.CONFIG_SMS_TO_MMS_TEXT_THRESHOLD);
        }

        public int getSmsToMmsTextLengthThreshold() {
            return this.getInt(MmsConfig.CONFIG_SMS_TO_MMS_TEXT_LENGTH_THRESHOLD);
        }

        public boolean getMmsEnabled() {
            return this.getBoolean(MmsConfig.CONFIG_ENABLED_MMS);
        }

        public int getMaxMessageSize() {
            return this.getInt(MmsConfig.CONFIG_MAX_MESSAGE_SIZE);
        }

        public boolean getTransIdEnabled() {
            return this.getBoolean(MmsConfig.CONFIG_ENABLED_TRANS_ID);
        }

        public String getUserAgent() {
            if (this.mOverrides != null && this.mOverrides.containsKey(MmsConfig.CONFIG_USER_AGENT)) {
                return this.mOverrides.getString(MmsConfig.CONFIG_USER_AGENT);
            }
            return !TextUtils.isEmpty((CharSequence)this.mBase.mUserAgent) ? this.mBase.mUserAgent : this.mBase.getNullableStringValue(MmsConfig.CONFIG_USER_AGENT);
        }

        public String getUaProfTagName() {
            return this.getString(MmsConfig.CONFIG_UA_PROF_TAG_NAME);
        }

        public String getUaProfUrl() {
            if (this.mOverrides != null && this.mOverrides.containsKey(MmsConfig.CONFIG_UA_PROF_URL)) {
                return this.mOverrides.getString(MmsConfig.CONFIG_UA_PROF_URL);
            }
            return !TextUtils.isEmpty((CharSequence)this.mBase.mUaProfUrl) ? this.mBase.mUaProfUrl : this.mBase.getNullableStringValue(MmsConfig.CONFIG_UA_PROF_URL);
        }

        public String getHttpParams() {
            return this.getString(MmsConfig.CONFIG_HTTP_PARAMS);
        }

        public String getEmailGateway() {
            return this.getString(MmsConfig.CONFIG_EMAIL_GATEWAY_NUMBER);
        }

        public int getMaxImageHeight() {
            return this.getInt(MmsConfig.CONFIG_MAX_IMAGE_HEIGHT);
        }

        public int getMaxImageWidth() {
            return this.getInt(MmsConfig.CONFIG_MAX_IMAGE_WIDTH);
        }

        public int getRecipientLimit() {
            int limit = this.getInt(MmsConfig.CONFIG_RECIPIENT_LIMIT);
            return limit < 0 ? Integer.MAX_VALUE : limit;
        }

        public int getMaxTextLimit() {
            int max = this.getInt(MmsConfig.CONFIG_MAX_MESSAGE_TEXT_SIZE);
            return max > -1 ? max : 2000;
        }

        public int getHttpSocketTimeout() {
            return this.getInt(MmsConfig.CONFIG_HTTP_SOCKET_TIMEOUT);
        }

        public boolean getMultipartSmsEnabled() {
            return this.getBoolean(MmsConfig.CONFIG_ENABLE_MULTIPART_SMS);
        }

        public boolean getSendMultipartSmsAsSeparateMessages() {
            return this.getBoolean(MmsConfig.CONFIG_SEND_MULTIPART_SMS_AS_SEPARATE_MESSAGES);
        }

        public boolean getSMSDeliveryReportsEnabled() {
            return this.getBoolean(MmsConfig.CONFIG_ENABLE_SMS_DELIVERY_REPORTS);
        }

        public boolean getNotifyWapMMSC() {
            return this.getBoolean(MmsConfig.CONFIG_ENABLED_NOTIFY_WAP_MMSC);
        }

        public boolean isAliasEnabled() {
            return this.getBoolean(MmsConfig.CONFIG_ALIAS_ENABLED);
        }

        public int getAliasMinChars() {
            return this.getInt(MmsConfig.CONFIG_ALIAS_MIN_CHARS);
        }

        public int getAliasMaxChars() {
            return this.getInt(MmsConfig.CONFIG_ALIAS_MAX_CHARS);
        }

        public boolean getAllowAttachAudio() {
            return this.getBoolean(MmsConfig.CONFIG_ALLOW_ATTACH_AUDIO);
        }

        public int getMaxSubjectLength() {
            return this.getInt(MmsConfig.CONFIG_MAX_SUBJECT_LENGTH);
        }

        public boolean getGroupMmsEnabled() {
            return this.getBoolean(MmsConfig.CONFIG_ENABLE_GROUP_MMS);
        }

        public boolean getSupportMmsContentDisposition() {
            return this.getBoolean(MmsConfig.CONFIG_SUPPORT_MMS_CONTENT_DISPOSITION);
        }

        public boolean getShowCellBroadcast() {
            return this.getBoolean(MmsConfig.CONFIG_CELL_BROADCAST_APP_LINKS);
        }

        public String getNaiSuffix() {
            return this.getString(MmsConfig.CONFIG_NAI_SUFFIX);
        }

        public boolean isMmsReadReportsEnabled() {
            return this.getBoolean(MmsConfig.CONFIG_ENABLE_MMS_READ_REPORTS);
        }

        public boolean isMmsDeliveryReportsEnabled() {
            return this.getBoolean(MmsConfig.CONFIG_ENABLE_MMS_DELIVERY_REPORTS);
        }

        public boolean getSupportHttpCharsetHeader() {
            return this.getBoolean(MmsConfig.CONFIG_SUPPORT_HTTP_CHARSET_HEADER);
        }

        public String getHttpParamMacro(Context context, String macro) {
            if (MmsConfig.MACRO_LINE1.equals(macro)) {
                return Overridden.getLine1(context, this.mBase.getSubId());
            }
            if (MmsConfig.MACRO_LINE1NOCOUNTRYCODE.equals(macro)) {
                return Overridden.getLine1NoCountryCode(context, this.mBase.getSubId());
            }
            if (MmsConfig.MACRO_NAI.equals(macro)) {
                return this.getNai(context, this.mBase.getSubId());
            }
            return null;
        }

        private static String getLine1(Context context, int subId) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (Build.VERSION.SDK_INT < 22) {
                return telephonyManager.getLine1Number();
            }
            try {
                Method method = telephonyManager.getClass().getMethod("getLine1NumberForSubscriber", Integer.TYPE);
                return (String)method.invoke((Object)telephonyManager, subId);
            }
            catch (Exception e) {
                return telephonyManager.getLine1Number();
            }
        }

        private static String getLine1NoCountryCode(Context context, int subId) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            return PhoneUtils.getNationalNumber(telephonyManager, subId, Overridden.getLine1(context, subId));
        }

        private String getNai(Context context, int subId) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            String nai = "";
            if (Build.VERSION.SDK_INT < 22) {
                nai = SystemPropertiesProxy.get(context, "persist.radio.cdma.nai");
            } else {
                try {
                    Method method = telephonyManager.getClass().getMethod("getNai", Integer.TYPE);
                    Method getSlotId = SubscriptionManager.class.getMethod("getSlotId", Integer.TYPE);
                    nai = (String)method.invoke((Object)telephonyManager, getSlotId.invoke(null, subId));
                }
                catch (Exception e) {
                    nai = SystemPropertiesProxy.get(context, "persist.radio.cdma.nai");
                }
            }
            if (Log.isLoggable((String)MmsConfig.TAG, (int)2)) {
                Log.v((String)MmsConfig.TAG, (String)("MmsConfig.getNai: nai=" + nai));
            }
            if (!TextUtils.isEmpty((CharSequence)nai)) {
                String naiSuffix = this.getNaiSuffix();
                if (!TextUtils.isEmpty((CharSequence)naiSuffix)) {
                    nai = nai + naiSuffix;
                }
                byte[] encoded = null;
                try {
                    encoded = Base64.encode((byte[])nai.getBytes("UTF-8"), (int)2);
                }
                catch (UnsupportedEncodingException e) {
                    encoded = Base64.encode((byte[])nai.getBytes(), (int)2);
                }
                try {
                    nai = new String(encoded, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    nai = new String(encoded);
                }
            }
            return nai;
        }
    }
}

