/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import com.android.mms.transaction.TransactionService;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.Utils;

public class MmsSystemEventReceiver
extends BroadcastReceiver {
    private static final String TAG = "Mms";
    private static ConnectivityManager mConnMgr = null;

    public static void wakeUpService(Context context) {
        if (Build.VERSION.SDK_INT < 21) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"wakeUpService: start transaction service ...");
            }
            context.startService(new Intent(context, TransactionService.class));
        }
    }

    public void onReceive(Context context, Intent intent) {
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Intent received: " + intent));
        }
        if (!Utils.isDefaultSmsApp(context)) {
            Log.v((String)TAG, (String)"not default sms app, cancelling");
            return;
        }
        String action = intent.getAction();
        if (action.equals("android.intent.action.CONTENT_CHANGED")) {
            Uri uri = (Uri)intent.getParcelableExtra("deleted_contents");
        } else if (action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
            if (mConnMgr == null) {
                mConnMgr = (ConnectivityManager)context.getSystemService("connectivity");
            }
            if (Utils.isMmsOverWifiEnabled(context)) {
                NetworkInfo niWF = mConnMgr.getNetworkInfo(1);
                if (niWF != null && niWF.isConnected()) {
                    Log.v((String)TAG, (String)"TYPE_WIFI connected");
                    MmsSystemEventReceiver.wakeUpService(context);
                }
            } else {
                boolean mobileDataEnabled = Utils.isMobileDataEnabled(context);
                if (!mobileDataEnabled) {
                    Log.v((String)TAG, (String)"mobile data turned off, bailing");
                    return;
                }
                NetworkInfo mmsNetworkInfo = mConnMgr.getNetworkInfo(2);
                if (mmsNetworkInfo == null) {
                    return;
                }
                boolean available = mmsNetworkInfo.isAvailable();
                boolean isConnected = mmsNetworkInfo.isConnected();
                if (Log.isLoggable((String)TAG, (int)2)) {
                    Log.v((String)TAG, (String)("TYPE_MOBILE_MMS available = " + available + ", isConnected = " + isConnected));
                }
                if (available && !isConnected) {
                    MmsSystemEventReceiver.wakeUpService(context);
                }
            }
        } else if (action.equals("android.intent.action.BOOT_COMPLETED")) {
            MmsSystemEventReceiver.wakeUpService(context);
        }
    }
}

