/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.provider.Telephony;
import android.text.TextUtils;
import com.android.mms.transaction.RetryScheduler;
import com.android.mms.transaction.Transaction;
import com.android.mms.transaction.TransactionSettings;
import com.android.mms.util.RateController;
import com.android.mms.util.SendingProgressTokenManager;
import com.google.android.mms.pdu_alt.EncodedStringValue;
import com.google.android.mms.pdu_alt.PduComposer;
import com.google.android.mms.pdu_alt.PduParser;
import com.google.android.mms.pdu_alt.PduPersister;
import com.google.android.mms.pdu_alt.SendConf;
import com.google.android.mms.pdu_alt.SendReq;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.BroadcastUtils;
import com.klinker.android.send_message.Utils;
import java.util.Arrays;

public class SendTransaction
extends Transaction
implements Runnable {
    private static final String TAG = "Mms";
    private Thread mThread;
    public final Uri mSendReqURI;

    public SendTransaction(Context context, int transId, TransactionSettings connectionSettings, String uri) {
        super(context, transId, connectionSettings);
        this.mSendReqURI = Uri.parse((String)uri);
        this.mId = uri;
        this.attach(RetryScheduler.getInstance(context));
    }

    @Override
    public void process() {
        this.mThread = new Thread((Runnable)this, "SendTransaction");
        this.mThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StringBuilder builder = new StringBuilder();
        try {
            byte[] confId;
            byte[] reqId;
            SendConf conf;
            RateController.init(this.mContext);
            RateController rateCtlr = RateController.getInstance();
            if (rateCtlr.isLimitSurpassed() && !rateCtlr.isAllowedByUser()) {
                Log.e((String)TAG, (String)"Sending rate limit surpassed.");
                return;
            }
            PduPersister persister = PduPersister.getPduPersister(this.mContext);
            SendReq sendReq = (SendReq)persister.load(this.mSendReqURI);
            long date = System.currentTimeMillis() / 1000L;
            sendReq.setDate(date);
            ContentValues values = new ContentValues(1);
            values.put("date", Long.valueOf(date));
            SqliteWrapper.update(this.mContext, this.mContext.getContentResolver(), this.mSendReqURI, values, null, null);
            String lineNumber = Utils.getMyPhoneNumber(this.mContext);
            if (!TextUtils.isEmpty((CharSequence)lineNumber)) {
                sendReq.setFrom(new EncodedStringValue(lineNumber));
            }
            long tokenKey = ContentUris.parseId((Uri)this.mSendReqURI);
            byte[] response = this.sendPdu(SendingProgressTokenManager.get(tokenKey), new PduComposer(this.mContext, sendReq).make());
            SendingProgressTokenManager.remove(tokenKey);
            if (Log.isLoggable((String)TAG, (int)2)) {
                String respStr = new String(response);
                builder.append("[SendTransaction] run: send mms msg (" + this.mId + "), resp=" + respStr);
                Log.d((String)TAG, (String)("[SendTransaction] run: send mms msg (" + this.mId + "), resp=" + respStr));
            }
            if ((conf = (SendConf)new PduParser(response).parse()) == null) {
                Log.e((String)TAG, (String)"No M-Send.conf received.");
                builder.append("No M-Send.conf received.\n");
            }
            if (!Arrays.equals(reqId = sendReq.getTransactionId(), confId = conf.getTransactionId())) {
                Log.e((String)TAG, (String)("Inconsistent Transaction-ID: req=" + new String(reqId) + ", conf=" + new String(confId)));
                builder.append("Inconsistent Transaction-ID: req=" + new String(reqId) + ", conf=" + new String(confId) + "\n");
                return;
            }
            values = new ContentValues(2);
            int respStatus = conf.getResponseStatus();
            values.put("resp_st", Integer.valueOf(respStatus));
            if (respStatus != 128) {
                SqliteWrapper.update(this.mContext, this.mContext.getContentResolver(), this.mSendReqURI, values, null, null);
                Log.e((String)TAG, (String)("Server returned an error code: " + respStatus));
                builder.append("Server returned an error code: " + respStatus + "\n");
                return;
            }
            String messageId = PduPersister.toIsoString(conf.getMessageId());
            values.put("m_id", messageId);
            SqliteWrapper.update(this.mContext, this.mContext.getContentResolver(), this.mSendReqURI, values, null, null);
            Uri uri = persister.move(this.mSendReqURI, Telephony.Mms.Sent.CONTENT_URI);
            this.mTransactionState.setState(1);
            this.mTransactionState.setContentUri(uri);
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)"error", (Throwable)t);
        }
        finally {
            if (this.mTransactionState.getState() != 1) {
                this.mTransactionState.setState(2);
                this.mTransactionState.setContentUri(this.mSendReqURI);
                Log.e((String)TAG, (String)"Delivery failed.");
                builder.append("Delivery failed\n");
                Intent intent = new Intent("com.klinker.android.send_message.MMS_ERROR");
                intent.putExtra("stack", builder.toString());
                BroadcastUtils.sendExplicitBroadcast(this.mContext, intent, "com.klinker.android.send_message.MMS_ERROR");
            }
            this.notifyObservers();
        }
    }

    @Override
    public int getType() {
        return 2;
    }
}

