/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.service_alt;

import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import com.android.mms.service_alt.MmsRequest;
import com.android.mms.transaction.NotificationTransaction;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu_alt.PduParser;
import com.google.android.mms.pdu_alt.PduPersister;
import com.google.android.mms.pdu_alt.RetrieveConf;
import com.google.android.mms.util_alt.SqliteWrapper;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.Transaction;

public class MmsRequestManager
implements MmsRequest.RequestManager {
    private static final String TAG = "MmsRequestManager";
    private Context context;
    private byte[] pduData;

    public MmsRequestManager(Context context) {
        this(context, null);
    }

    public MmsRequestManager(Context context, byte[] pduData) {
        this.context = context;
        this.pduData = pduData;
    }

    @Override
    public void addSimRequest(MmsRequest request) {
    }

    @Override
    public boolean getAutoPersistingPref() {
        return NotificationTransaction.allowAutoDownload(this.context);
    }

    @Override
    public byte[] readPduFromContentUri(Uri contentUri, int maxSize) {
        return this.pduData;
    }

    @Override
    public boolean writePduToContentUri(Uri contentUri, byte[] response) {
        if (response == null || response.length < 1) {
            android.util.Log.e((String)TAG, (String)"empty response");
            return false;
        }
        try {
            boolean group;
            RetrieveConf retrieveConf = (RetrieveConf)new PduParser(response).parse();
            if (null == retrieveConf) {
                throw new MmsException("Invalid M-Retrieve.conf PDU.");
            }
            try {
                group = Transaction.settings.getGroup();
            }
            catch (Exception e) {
                group = PreferenceManager.getDefaultSharedPreferences((Context)this.context).getBoolean("group_message", true);
            }
            PduPersister persister = PduPersister.getPduPersister(this.context);
            Uri msgUri = persister.persist(retrieveConf, Telephony.Mms.Inbox.CONTENT_URI, true, group, null);
            ContentValues values = new ContentValues(3);
            values.put("date", Long.valueOf(System.currentTimeMillis() / 1000L));
            values.put("date_sent", Long.valueOf(retrieveConf.getDate()));
            values.put("m_size", Integer.valueOf(response.length));
            SqliteWrapper.update(this.context, this.context.getContentResolver(), msgUri, values, null, null);
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)"error", (Throwable)t);
        }
        return false;
    }
}

