/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.service_alt;

import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.NetworkUtilsHelper;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.text.TextUtils;
import com.android.mms.service_alt.exception.ApnException;
import com.klinker.android.logger.Log;
import java.net.URI;
import java.net.URISyntaxException;

public class ApnSettings {
    private static final String TAG = "ApnSettings";
    private final String mServiceCenter;
    private final String mProxyAddress;
    private final int mProxyPort;
    private final String mDebugText;
    private static final String[] APN_PROJECTION = new String[]{"type", "mmsc", "mmsproxy", "mmsport", "name", "apn", "bearer", "protocol", "roaming_protocol", "authtype", "mvno_type", "mvno_match_data", "proxy", "port", "server", "user", "password"};
    private static final int COLUMN_TYPE = 0;
    private static final int COLUMN_MMSC = 1;
    private static final int COLUMN_MMSPROXY = 2;
    private static final int COLUMN_MMSPORT = 3;
    private static final int COLUMN_NAME = 4;
    private static final int COLUMN_APN = 5;
    private static final int COLUMN_BEARER = 6;
    private static final int COLUMN_PROTOCOL = 7;
    private static final int COLUMN_ROAMING_PROTOCOL = 8;
    private static final int COLUMN_AUTH_TYPE = 9;
    private static final int COLUMN_MVNO_TYPE = 10;
    private static final int COLUMN_MVNO_MATCH_DATA = 11;
    private static final int COLUMN_PROXY = 12;
    private static final int COLUMN_PORT = 13;
    private static final int COLUMN_SERVER = 14;
    private static final int COLUMN_USER = 15;
    private static final int COLUMN_PASSWORD = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApnSettings load(Context context, String apnName, int subId) throws ApnException {
        block13: {
            SharedPreferences sharedPrefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
            String mmsc = sharedPrefs.getString("mmsc_url", "");
            if (!TextUtils.isEmpty((CharSequence)mmsc)) {
                String mmsProxy = sharedPrefs.getString("mms_proxy", "");
                String mmsPort = sharedPrefs.getString("mms_port", "");
                return new ApnSettings(mmsc, mmsProxy, ApnSettings.parsePort(mmsPort), "Default from settings");
            }
            Log.v((String)TAG, (String)("ApnSettings: apnName " + apnName));
            String selection = null;
            String[] selectionArgs = null;
            String string = apnName = apnName != null ? apnName.trim() : null;
            if (!TextUtils.isEmpty((CharSequence)apnName)) {
                selection = "apn=?";
                selectionArgs = new String[]{apnName};
            }
            try (Cursor cursor = null;){
                cursor = SqliteWrapper.query(context, context.getContentResolver(), Uri.withAppendedPath((Uri)Telephony.Carriers.CONTENT_URI, (String)("/subId/" + subId)), APN_PROJECTION, selection, selectionArgs, null);
                if (cursor == null) break block13;
                String mmscUrl = null;
                String proxyAddress = null;
                int proxyPort = -1;
                while (cursor.moveToNext()) {
                    if (!ApnSettings.isValidApnType(cursor.getString(0), "mms") || TextUtils.isEmpty((CharSequence)(mmscUrl = ApnSettings.trimWithNullCheck(cursor.getString(1))))) continue;
                    mmscUrl = NetworkUtilsHelper.trimV4AddrZeros(mmscUrl);
                    try {
                        new URI(mmscUrl);
                    }
                    catch (URISyntaxException e) {
                        throw new ApnException("Invalid MMSC url " + mmscUrl);
                    }
                    proxyAddress = ApnSettings.trimWithNullCheck(cursor.getString(2));
                    if (!TextUtils.isEmpty((CharSequence)proxyAddress)) {
                        proxyAddress = NetworkUtilsHelper.trimV4AddrZeros(proxyAddress);
                        String portString = ApnSettings.trimWithNullCheck(cursor.getString(3));
                        if (portString != null) {
                            try {
                                proxyPort = Integer.parseInt(portString);
                            }
                            catch (NumberFormatException e) {
                                Log.e((String)TAG, (String)("Invalid port " + portString));
                                throw new ApnException("Invalid port " + portString);
                            }
                        }
                    }
                    ApnSettings apnSettings = new ApnSettings(mmscUrl, proxyAddress, proxyPort, ApnSettings.getDebugText(cursor));
                    return apnSettings;
                }
            }
        }
        return new ApnSettings("", "", 80, "Failed to find APNs :(");
    }

    private static String getDebugText(Cursor cursor) {
        StringBuilder sb = new StringBuilder();
        sb.append("APN [");
        for (int i = 0; i < cursor.getColumnCount(); ++i) {
            String name = cursor.getColumnName(i);
            String value = cursor.getString(i);
            if (TextUtils.isEmpty((CharSequence)value)) continue;
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(name).append('=').append(value);
        }
        sb.append("]");
        return sb.toString();
    }

    private static String trimWithNullCheck(String value) {
        return value != null ? value.trim() : null;
    }

    public ApnSettings(String mmscUrl, String proxyAddr, int proxyPort, String debugText) {
        this.mServiceCenter = mmscUrl;
        this.mProxyAddress = proxyAddr;
        this.mProxyPort = proxyPort;
        this.mDebugText = debugText;
    }

    public String getMmscUrl() {
        return this.mServiceCenter;
    }

    public String getProxyAddress() {
        return this.mProxyAddress;
    }

    public int getProxyPort() {
        return this.mProxyPort;
    }

    public boolean isProxySet() {
        return !TextUtils.isEmpty((CharSequence)this.mProxyAddress);
    }

    private static boolean isValidApnType(String types, String requestType) {
        if (TextUtils.isEmpty((CharSequence)types)) {
            return true;
        }
        for (String type : types.split(",")) {
            if (!(type = type.trim()).equals(requestType) && !type.equals("*")) continue;
            return true;
        }
        return false;
    }

    private static int parsePort(String port) {
        if (TextUtils.isEmpty((CharSequence)port)) {
            return 80;
        }
        return Integer.parseInt(port);
    }

    public String toString() {
        return this.mDebugText;
    }
}

