/*
 * Decompiled with CFR 0.152.
 */
package com.klinker.android.send_message;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.preference.PreferenceManager;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.widget.Toast;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.R;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ApnUtils {
    private static final String TAG = "ApnUtils";

    public static void initDefaultApns(final Context context, final OnApnFinishedListener listener) {
        ApnUtils.loadMmsSettings(context);
        final ArrayList<APN> apns = ApnUtils.loadApns(context);
        if (apns == null || apns.size() == 0) {
            Log.v((String)TAG, (String)"Found no APNs :( Damn CDMA network probably.");
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.auto_select_failed), (int)0).show();
            if (listener != null) {
                listener.onFinished();
            }
        } else if (apns.size() == 1) {
            ApnUtils.setApns(context, apns.get(0));
            if (listener != null) {
                listener.onFinished();
            }
        } else if (!PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("has_seen_select_apns_warning", false)) {
            new AlertDialog.Builder(context).setTitle(R.string.auto_select_apn).setMessage(R.string.auto_select_multiple_apns).setPositiveButton(R.string.ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int num) {
                    ApnUtils.showApnChooser(context, apns, listener);
                }
            }).show();
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean("has_seen_select_apns_warning", true).commit();
        } else {
            ApnUtils.showApnChooser(context, apns, listener);
        }
    }

    private static void showApnChooser(final Context context, final ArrayList<APN> apns, final OnApnFinishedListener listener) {
        CharSequence[] items = new CharSequence[apns.size()];
        SharedPreferences sharedPrefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String curMmsc = sharedPrefs.getString("mmsc_url", "");
        String curProxy = sharedPrefs.getString("mms_proxy", "");
        String curPort = sharedPrefs.getString("mms_port", "");
        int defaultApn = -1;
        for (int i = 0; i < items.length; ++i) {
            APN apn = apns.get(i);
            items[i] = i + 1 + ". " + apn.name;
            if (!apn.mmsc.equals(curMmsc) || !apn.proxy.equals(curProxy) || !apn.port.equals(curPort)) continue;
            defaultApn = i;
        }
        new AlertDialog.Builder(context).setSingleChoiceItems(items, defaultApn, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                ApnUtils.setApns(context, (APN)apns.get(i));
                if (listener != null) {
                    listener.onFinished();
                }
                dialogInterface.dismiss();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                if (listener != null) {
                    listener.onFinished();
                }
            }
        }).show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMmsSettings(Context context) {
        XmlResourceParser parser = context.getResources().getXml(R.xml.mms_config);
        String maxMessageSize = "1000000";
        int maxImageHeight = 800;
        int maxImageWidth = 800;
        String userAgent = "Android Messaging";
        String uaProfUrl = "http://www.gstatic.com/android/hangouts/hangouts_mms_ua_profile.xml";
        try {
            ApnUtils.beginDocument((XmlPullParser)parser, "mms_config");
            while (true) {
                ApnUtils.nextElement((XmlPullParser)parser);
                String tag = parser.getName();
                if (tag == null) {
                    break;
                }
                String name = parser.getAttributeName(0);
                String value = parser.getAttributeValue(0);
                String text = null;
                if (parser.next() == 4) {
                    text = parser.getText();
                }
                Log.v((String)TAG, (String)("tag: " + tag + " value: " + value + " - " + text));
                if (!"name".equalsIgnoreCase(name)) continue;
                if ("int".equals(tag)) {
                    if ("maxMessageSize".equalsIgnoreCase(value)) {
                        maxMessageSize = text;
                        continue;
                    }
                    if ("maxImageHeight".equalsIgnoreCase(value)) {
                        maxImageHeight = Integer.parseInt(text);
                        continue;
                    }
                    if (!"maxImageWidth".equalsIgnoreCase(value)) continue;
                    maxImageWidth = Integer.parseInt(text);
                    continue;
                }
                if (!"string".equals(tag)) continue;
                if ("userAgent".equalsIgnoreCase(value)) {
                    userAgent = text;
                    continue;
                }
                if (!"uaProfUrl".equalsIgnoreCase(value)) continue;
                uaProfUrl = text;
            }
        }
        catch (XmlPullParserException e) {
            Log.e((String)TAG, (String)"loadMmsSettings caught ", (Throwable)e);
        }
        catch (NumberFormatException e) {
            Log.e((String)TAG, (String)"loadMmsSettings caught ", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"loadMmsSettings caught ", (Throwable)e);
        }
        finally {
            parser.close();
        }
        Object errorStr = null;
        if (errorStr != null) {
            String err = String.format("MmsConfig.loadMmsSettings mms_config.xml missing %s setting", errorStr);
            Log.e((String)TAG, (String)err);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            userAgent = telephonyManager.getMmsUserAgent();
            uaProfUrl = telephonyManager.getMmsUAProfUrl();
        }
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putInt("mms_max_width", maxImageWidth).putInt("mms_max_height", maxImageHeight).putString("mms_max_size", maxMessageSize).putString("mms_agent", userAgent).putString("mms_user_agent_profile_url", uaProfUrl).commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<APN> loadApns(Context context) {
        XmlResourceParser parser = context.getResources().getXml(R.xml.apns);
        ArrayList<APN> apns = new ArrayList<APN>();
        String mmsc = "";
        String proxy = "";
        String port = "";
        String carrier = "";
        int mcc = -1;
        int mnc = -1;
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        String networkOperator = manager.getNetworkOperator();
        if (ApnUtils.isValidNetworkOperator(networkOperator)) {
            mcc = Integer.parseInt(networkOperator.substring(0, 3));
            String s = networkOperator.substring(3);
            try {
                mnc = Integer.parseInt(s.replaceFirst("^0{1,2}", ""));
            }
            catch (Exception e) {
                mnc = -1;
            }
        } else {
            mcc = context.getResources().getConfiguration().mcc;
            mnc = context.getResources().getConfiguration().mnc;
        }
        try {
            if (mcc == -1) {
                mcc = Integer.parseInt(new ServiceState().getOperatorNumeric().substring(0, 3));
            }
            if (mnc == -1) {
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                mnc = ((CdmaCellLocation)tm.getCellLocation()).getSystemId();
            }
        }
        catch (Exception tm) {
            // empty catch block
        }
        if (mcc == -1 || mnc == -1) {
            Log.v((String)TAG, (String)("couldn't find both mcc and mnc. mcc = " + mcc + ", mnc = " + mnc));
            return null;
        }
        Log.v((String)TAG, (String)("mcc: " + mcc + " mnc: " + mnc));
        try {
            ApnUtils.beginDocument((XmlPullParser)parser, "apns");
            while (true) {
                String name2;
                int i;
                ApnUtils.nextElement((XmlPullParser)parser);
                String tag = parser.getName();
                if (tag == null) {
                    break;
                }
                boolean mccCorrect = false;
                boolean mncCorrect = false;
                for (i = 0; i < parser.getAttributeCount(); ++i) {
                    try {
                        name2 = parser.getAttributeName(i);
                        int value = Integer.parseInt(parser.getAttributeValue(i));
                        if ("mcc".equals(name2) && mcc == value) {
                            mccCorrect = true;
                            continue;
                        }
                        if (!"mnc".equals(name2) || mnc != value) continue;
                        mncCorrect = true;
                        continue;
                    }
                    catch (Exception name2) {
                        // empty catch block
                    }
                }
                if (!mccCorrect || !mncCorrect) continue;
                for (i = 0; i < parser.getAttributeCount(); ++i) {
                    name2 = parser.getAttributeName(i);
                    String value = parser.getAttributeValue(i);
                    if ("type".equals(name2)) {
                        if (value.contains("mms")) continue;
                        mmsc = "";
                        proxy = "";
                        port = "";
                        break;
                    }
                    if ("mmsc".equals(name2)) {
                        mmsc = value;
                        continue;
                    }
                    if ("mmsproxy".equals(name2)) {
                        proxy = value;
                        continue;
                    }
                    if ("mmsport".equals(name2)) {
                        port = value;
                        continue;
                    }
                    if ("carrier".equals(name2)) {
                        carrier = value;
                        continue;
                    }
                    if (!"port".equals(name2) || !port.equals("")) continue;
                    port = value;
                }
                if (mmsc.equals("")) continue;
                APN apn = new APN();
                apn.name = carrier;
                apn.mmsc = mmsc;
                apn.proxy = proxy;
                apn.port = port;
                boolean contains = false;
                for (int i2 = 0; i2 < apns.size(); ++i2) {
                    APN current = apns.get(i2);
                    if (!current.mmsc.equals(apn.mmsc) || !current.port.equals(apn.port) || !current.proxy.equals(apn.proxy)) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                apns.add(apn);
            }
        }
        catch (XmlPullParserException e) {
            Log.e((String)TAG, (String)"loadApns caught ", (Throwable)e);
        }
        catch (NumberFormatException e) {
            Log.e((String)TAG, (String)"loadApns caught ", (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"loadApns caught ", (Throwable)e);
        }
        finally {
            parser.close();
        }
        Log.v((String)TAG, (String)("MMSC: " + mmsc + ", MMS Proxy: " + proxy + ", MMS Port: " + port));
        Object errorStr = null;
        if (errorStr != null) {
            String err = String.format("MmsConfig.loadMmsSettings mms_config.xml missing %s setting", errorStr);
            Log.e((String)TAG, (String)err);
        }
        return apns;
    }

    private static boolean isValidNetworkOperator(String networkOperator) {
        return networkOperator != null && !networkOperator.isEmpty() && !networkOperator.contains("null");
    }

    private static void setApns(Context context, APN apn) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putString("mmsc_url", apn.mmsc).putString("mms_proxy", apn.proxy).putString("mms_port", apn.port).commit();
    }

    private static void beginDocument(XmlPullParser parser, String firstElementName) throws XmlPullParserException, IOException {
        int type;
        do {
            type = parser.next();
            if (type == 2) break;
        } while (type != 1);
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        if (!parser.getName().equals(firstElementName)) {
            throw new XmlPullParserException("Unexpected start tag: found " + parser.getName() + ", expected " + firstElementName);
        }
    }

    private static void nextElement(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        do {
            type = parser.next();
            if (type == 2) break;
        } while (type != 1);
    }

    private static class APN {
        public String name;
        public String mmsc;
        public String proxy;
        public String port;

        private APN() {
        }
    }

    public static interface OnApnFinishedListener {
        public void onFinished();
    }
}

