/*
 * Decompiled with CFR 0.152.
 */
package com.klinker.android.send_message;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.Uri;
import android.os.Build;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.mms.service_alt.MmsNetworkManager;
import com.android.mms.service_alt.exception.MmsNetworkException;
import com.google.android.mms.util_alt.SqliteWrapper;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.Settings;
import com.klinker.android.send_message.StripAccents;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static final String GSM_CHARACTERS_REGEX = "^[A-Za-z0-9 \\r\\n@\u0141$\u013d\u010d\u00e9\u016f\u011b\u0148\u00c7\u0158\u0159\u0139\u013a\u0394_\u03a6\u0393\u039b\u03a9\u03a0\u03a8\u03a3\u0398\u039e\u0106\u0107\u00df\u00c9!\"#$%&'()*+,\\-./:;<=>?\u0104\u00c4\u00d6\u0143\u00dc\u00a7\u017c\u00e4\u00f6\u0144\u00fc\u0155^{}\\\\\\[~\\]|\u20ac]*$";
    private static final String TAG = "Utils";
    public static final int DEFAULT_SUBSCRIPTION_ID = 1;
    private static final Pattern EMAIL_ADDRESS_PATTERN = Pattern.compile("[a-zA-Z0-9\\+\\.\\_\\%\\-]{1,256}\\@[a-zA-Z0-9][a-zA-Z0-9\\-]{0,64}(\\.[a-zA-Z0-9][a-zA-Z0-9\\-]{0,25})+");
    private static final Pattern NAME_ADDR_EMAIL_PATTERN = Pattern.compile("\\s*(\"[^\"]*\"|[^<>\"]+)\\s*<([^<>]+)>\\s*");

    public static String getMyPhoneNumber(Context context) {
        TelephonyManager mTelephonyMgr = (TelephonyManager)context.getSystemService("phone");
        return mTelephonyMgr.getLine1Number();
    }

    public static <T> T ensureRouteToMmsNetwork(Context context, String url, String proxy, Task<T> task) throws IOException {
        if (Build.VERSION.SDK_INT >= 23) {
            return Utils.ensureRouteToMmsNetworkMarshmallow(context, task);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return Utils.ensureRouteToMmsNetworkLollipop(context, task);
        }
        Utils.ensureRouteToHost(context, url, proxy);
        return task.run();
    }

    @TargetApi(value=23)
    private static <T> T ensureRouteToMmsNetworkMarshmallow(Context context, Task<T> task) throws IOException {
        MmsNetworkManager networkManager = new MmsNetworkManager(context.getApplicationContext(), Utils.getDefaultSubscriptionId());
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        Network network = null;
        try {
            network = networkManager.acquireNetwork();
            connectivityManager.bindProcessToNetwork(network);
            T t = task.run();
            return t;
        }
        catch (MmsNetworkException e) {
            throw new IOException(e);
        }
        finally {
            if (network != null) {
                connectivityManager.bindProcessToNetwork(null);
            }
            networkManager.releaseNetwork();
        }
    }

    @TargetApi(value=21)
    private static <T> T ensureRouteToMmsNetworkLollipop(Context context, Task<T> task) throws IOException {
        MmsNetworkManager networkManager = new MmsNetworkManager(context.getApplicationContext(), Utils.getDefaultSubscriptionId());
        Network network = null;
        try {
            network = networkManager.acquireNetwork();
            ConnectivityManager.setProcessDefaultNetwork((Network)network);
            T t = task.run();
            return t;
        }
        catch (MmsNetworkException e) {
            throw new IOException(e);
        }
        finally {
            if (network != null) {
                ConnectivityManager.setProcessDefaultNetwork(null);
            }
            networkManager.releaseNetwork();
        }
    }

    public static void ensureRouteToHost(Context context, String url, String proxy) throws IOException {
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        if (proxy != null && proxy.trim().length() != 0) {
            InetAddress inetAddr;
            try {
                inetAddr = InetAddress.getByName(proxy);
            }
            catch (UnknownHostException e) {
                throw new IOException("Cannot establish route for " + url + ": Unknown proxy " + proxy);
            }
            try {
                Method requestRoute = ConnectivityManager.class.getMethod("requestRouteToHostAddress", Integer.TYPE, InetAddress.class);
                if (!((Boolean)requestRoute.invoke((Object)connMgr, 2, inetAddr)).booleanValue()) {
                    throw new IOException("Cannot establish route to proxy " + inetAddr);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Cannot establishh route to proxy " + inetAddr), (Throwable)e);
            }
        } else {
            InetAddress inetAddr;
            Uri uri = Uri.parse((String)url);
            try {
                inetAddr = InetAddress.getByName(uri.getHost());
            }
            catch (UnknownHostException e) {
                throw new IOException("Cannot establish route for " + url + ": Unknown host");
            }
            try {
                Method requestRoute = ConnectivityManager.class.getMethod("requestRouteToHostAddress", Integer.TYPE, InetAddress.class);
                if (!((Boolean)requestRoute.invoke((Object)connMgr, 2, inetAddr)).booleanValue()) {
                    throw new IOException("Cannot establish route to proxy " + inetAddr);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Cannot establishh route to proxy " + inetAddr + " for " + url), (Throwable)e);
            }
        }
    }

    public static Boolean isMobileDataEnabled(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        try {
            Class<?> c = Class.forName(cm.getClass().getName());
            Method m = c.getDeclaredMethod("getMobileDataEnabled", new Class[0]);
            m.setAccessible(true);
            return (Boolean)m.invoke((Object)cm, new Object[0]);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
            return null;
        }
    }

    public static boolean isDataEnabled(TelephonyManager telephonyManager) {
        try {
            Class<?> c = telephonyManager.getClass();
            Method m = c.getMethod("getDataEnabled", new Class[0]);
            return (Boolean)m.invoke((Object)telephonyManager, new Object[0]);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
            return true;
        }
    }

    public static boolean isDataEnabled(TelephonyManager telephonyManager, int subId) {
        try {
            Class<?> c = telephonyManager.getClass();
            Method m = c.getMethod("getDataEnabled", Integer.TYPE);
            return (Boolean)m.invoke((Object)telephonyManager, subId);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
            return Utils.isDataEnabled(telephonyManager);
        }
    }

    public static void setMobileDataEnabled(Context context, boolean enabled) {
        if (Build.VERSION.SDK_INT < 21) {
            try {
                ConnectivityManager conman = (ConnectivityManager)context.getSystemService("connectivity");
                Class<?> conmanClass = Class.forName(conman.getClass().getName());
                Field iConnectivityManagerField = conmanClass.getDeclaredField("mService");
                iConnectivityManagerField.setAccessible(true);
                Object iConnectivityManager = iConnectivityManagerField.get(conman);
                Class<?> iConnectivityManagerClass = Class.forName(iConnectivityManager.getClass().getName());
                Method setMobileDataEnabledMethod = iConnectivityManagerClass.getDeclaredMethod("setMobileDataEnabled", Boolean.TYPE);
                setMobileDataEnabledMethod.setAccessible(true);
                setMobileDataEnabledMethod.invoke(iConnectivityManager, enabled);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"exception thrown", (Throwable)e);
            }
        } else {
            try {
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                Class<?> c = Class.forName(tm.getClass().getName());
                Method m = c.getDeclaredMethod("getITelephony", new Class[0]);
                m.setAccessible(true);
                Object telephonyService = m.invoke((Object)tm, new Object[0]);
                c = Class.forName(telephonyService.getClass().getName());
                m = c.getDeclaredMethod("setDataEnabled", Boolean.TYPE);
                m.setAccessible(true);
                m.invoke(telephonyService, enabled);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"error enabling data on lollipop", (Throwable)e);
            }
        }
    }

    public static int getNumPages(Settings settings, String text) {
        if (settings.getStripUnicode()) {
            text = StripAccents.stripAccents(text);
        }
        int[] data = SmsMessage.calculateLength((String)text, (boolean)false);
        return data[0];
    }

    public static long getOrCreateThreadId(Context context, String recipient) {
        HashSet<String> recipients = new HashSet<String>();
        recipients.add(recipient);
        return Utils.getOrCreateThreadId(context, recipients);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getOrCreateThreadId(Context context, Set<String> recipients) {
        Uri.Builder uriBuilder = Uri.parse((String)"content://mms-sms/threadID").buildUpon();
        for (String recipient : recipients) {
            if (Utils.isEmailAddress(recipient)) {
                recipient = Utils.extractAddrSpec(recipient);
            }
            uriBuilder.appendQueryParameter("recipient", recipient);
        }
        Uri uri = uriBuilder.build();
        Cursor cursor = SqliteWrapper.query(context, context.getContentResolver(), uri, new String[]{"_id"}, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    long id2 = cursor.getLong(0);
                    cursor.close();
                    long l = id2;
                    return l;
                }
            }
            finally {
                cursor.close();
            }
        }
        Random random = new Random();
        return random.nextLong();
    }

    public static boolean doesThreadIdExist(Context context, long threadId) {
        Uri uri = Uri.parse((String)("content://mms-sms/conversations/" + threadId + "/"));
        Cursor cursor = context.getContentResolver().query(uri, new String[]{"_id"}, null, null, null);
        if (cursor != null && cursor.moveToFirst()) {
            cursor.close();
            return true;
        }
        return false;
    }

    private static boolean isEmailAddress(String address) {
        if (TextUtils.isEmpty((CharSequence)address)) {
            return false;
        }
        String s = Utils.extractAddrSpec(address);
        Matcher match = EMAIL_ADDRESS_PATTERN.matcher(s);
        return match.matches();
    }

    private static String extractAddrSpec(String address) {
        Matcher match = NAME_ADDR_EMAIL_PATTERN.matcher(address);
        if (match.matches()) {
            return match.group(2);
        }
        return address;
    }

    public static Settings getDefaultSendSettings(Context context) {
        SharedPreferences sharedPrefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        Settings sendSettings = new Settings();
        sendSettings.setMmsc(sharedPrefs.getString("mmsc_url", ""));
        sendSettings.setProxy(sharedPrefs.getString("mms_proxy", ""));
        sendSettings.setPort(sharedPrefs.getString("mms_port", ""));
        sendSettings.setAgent(sharedPrefs.getString("mms_agent", ""));
        sendSettings.setUserProfileUrl(sharedPrefs.getString("mms_user_agent_profile_url", ""));
        sendSettings.setUaProfTagName(sharedPrefs.getString("mms_user_agent_tag_name", ""));
        sendSettings.setGroup(sharedPrefs.getBoolean("group_message", true));
        sendSettings.setDeliveryReports(sharedPrefs.getBoolean("delivery_reports", false));
        sendSettings.setSplit(sharedPrefs.getBoolean("split_sms", false));
        sendSettings.setSplitCounter(sharedPrefs.getBoolean("split_counter", false));
        sendSettings.setStripUnicode(sharedPrefs.getBoolean("strip_unicode", false));
        sendSettings.setSignature(sharedPrefs.getString("signature", ""));
        sendSettings.setSendLongAsMms(true);
        sendSettings.setSendLongAsMmsAfter(3);
        return sendSettings;
    }

    public static boolean hasKitKat() {
        return Build.VERSION.SDK_INT >= 19;
    }

    public static boolean isDefaultSmsApp(Context context) {
        if (Utils.hasKitKat()) {
            return context.getPackageName().equals(Telephony.Sms.getDefaultSmsPackage((Context)context));
        }
        return true;
    }

    public static boolean isMmsOverWifiEnabled(Context context) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("mms_over_wifi", false);
    }

    public static int getDefaultSubscriptionId() {
        if (Build.VERSION.SDK_INT >= 22) {
            return SmsManager.getDefaultSmsSubscriptionId();
        }
        return 1;
    }

    public static interface Task<T> {
        public T run() throws IOException;
    }
}

