/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.service_alt;

import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.i18n.phonenumbers.NumberParseException;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import com.android.i18n.phonenumbers.Phonenumber;
import java.lang.reflect.Method;
import java.util.Locale;

public class PhoneUtils {
    private static final String TAG = "PhoneUtils";

    public static String getNationalNumber(TelephonyManager telephonyManager, int subId, String phoneText) {
        String country = PhoneUtils.getSimOrDefaultLocaleCountry(telephonyManager, subId);
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        Phonenumber.PhoneNumber parsed = PhoneUtils.getParsedNumber(phoneNumberUtil, phoneText, country);
        if (parsed == null) {
            return phoneText;
        }
        return phoneNumberUtil.format(parsed, PhoneNumberUtil.PhoneNumberFormat.NATIONAL).replaceAll("\\D", "");
    }

    private static Phonenumber.PhoneNumber getParsedNumber(PhoneNumberUtil phoneNumberUtil, String phoneText, String country) {
        try {
            Phonenumber.PhoneNumber phoneNumber = phoneNumberUtil.parse(phoneText, country);
            if (phoneNumberUtil.isValidNumber(phoneNumber)) {
                return phoneNumber;
            }
            Log.e((String)TAG, (String)("getParsedNumber: not a valid phone number for country " + country));
            return null;
        }
        catch (NumberParseException e) {
            Log.e((String)TAG, (String)"getParsedNumber: Not able to parse phone number");
            return null;
        }
    }

    private static String getSimOrDefaultLocaleCountry(TelephonyManager telephonyManager, int subId) {
        String country = PhoneUtils.getSimCountry(telephonyManager, subId);
        if (TextUtils.isEmpty((CharSequence)country)) {
            country = Locale.getDefault().getCountry();
        }
        return country;
    }

    private static String getSimCountry(TelephonyManager telephonyManager, int subId) {
        String country = "";
        try {
            Method method = telephonyManager.getClass().getMethod("getSimCountryIso", Integer.TYPE);
            country = (String)method.invoke((Object)telephonyManager, subId);
        }
        catch (Exception e) {
            country = telephonyManager.getSimCountryIso();
        }
        if (TextUtils.isEmpty((CharSequence)country)) {
            return null;
        }
        return country.toUpperCase();
    }
}

