/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.service_alt;

import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.android.mms.service_alt.ApnSettings;
import com.android.mms.service_alt.MmsConfig;
import com.android.mms.service_alt.MmsConfigManager;
import com.android.mms.service_alt.MmsNetworkManager;
import com.android.mms.service_alt.exception.ApnException;
import com.android.mms.service_alt.exception.MmsHttpException;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.Utils;

public abstract class MmsRequest {
    private static final String TAG = "MmsRequest";
    private static final int RETRY_TIMES = 3;
    protected RequestManager mRequestManager;
    protected int mSubId;
    protected String mCreator;
    protected MmsConfig.Overridden mMmsConfig;
    protected Bundle mMmsConfigOverrides;
    private boolean mobileDataEnabled;

    public MmsRequest(RequestManager requestManager, int subId, String creator, Bundle configOverrides) {
        this.mRequestManager = requestManager;
        this.mSubId = subId;
        this.mCreator = creator;
        this.mMmsConfigOverrides = configOverrides;
        this.mMmsConfig = null;
    }

    public int getSubId() {
        return this.mSubId;
    }

    private boolean ensureMmsConfigLoaded() {
        MmsConfig config;
        if (this.mMmsConfig == null && (config = Build.VERSION.SDK_INT >= 22 ? MmsConfigManager.getInstance().getMmsConfigBySubId(this.mSubId) : MmsConfigManager.getInstance().getMmsConfig()) != null) {
            this.mMmsConfig = new MmsConfig.Overridden(config, this.mMmsConfigOverrides);
        }
        return this.mMmsConfig != null;
    }

    private static boolean inAirplaneMode(Context context) {
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
    }

    private static boolean isMobileDataEnabled(Context context, int subId) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return Utils.isDataEnabled(telephonyManager, subId);
    }

    private static boolean isDataNetworkAvailable(Context context, int subId) {
        return !MmsRequest.inAirplaneMode(context) && MmsRequest.isMobileDataEnabled(context, subId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Context context, MmsNetworkManager networkManager) {
        int result = 1;
        int httpStatusCode = 0;
        byte[] response = null;
        WifiManager wifi = (WifiManager)context.getSystemService("wifi");
        boolean isWifiEnabled = wifi.isWifiEnabled();
        if (!MmsRequest.useWifi(context)) {
            wifi.setWifiEnabled(false);
        }
        this.mobileDataEnabled = Utils.isMobileDataEnabled(context);
        Log.v((String)TAG, (String)("mobile data enabled: " + this.mobileDataEnabled));
        if (!this.mobileDataEnabled && !MmsRequest.useWifi(context)) {
            Log.v((String)TAG, (String)"mobile data not enabled, so forcing it to enable");
            Utils.setMobileDataEnabled(context, true);
        }
        if (!this.ensureMmsConfigLoaded()) {
            Log.e((String)TAG, (String)"MmsRequest: mms config is not loaded yet");
            result = 7;
        } else if (!this.prepareForHttpRequest()) {
            Log.e((String)TAG, (String)"MmsRequest: failed to prepare for request");
            result = 5;
        } else if (!MmsRequest.isDataNetworkAvailable(context, this.mSubId)) {
            Log.e((String)TAG, (String)"MmsRequest: in airplane mode or mobile data disabled");
            result = Build.VERSION.SDK_INT >= 22 ? 8 : 8;
        } else {
            long retryDelaySecs = 2L;
            for (int i = 0; i < 3; ++i) {
                try {
                    try {
                        networkManager.acquireNetwork();
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"error acquiring network", (Throwable)e);
                    }
                    String apnName = networkManager.getApnName();
                    try {
                        ApnSettings apn = null;
                        try {
                            apn = ApnSettings.load(context, apnName, this.mSubId);
                        }
                        catch (ApnException e) {
                            if (apnName == null) {
                                throw e;
                            }
                            Log.i((String)TAG, (String)("MmsRequest: No match with APN name:" + apnName + ", try with no name"));
                            apn = ApnSettings.load(context, null, this.mSubId);
                        }
                        Log.i((String)TAG, (String)("MmsRequest: using " + apn.toString()));
                        response = this.doHttp(context, networkManager, apn);
                        result = -1;
                        break;
                    }
                    finally {
                        networkManager.releaseNetwork();
                    }
                }
                catch (ApnException e) {
                    Log.e((String)TAG, (String)"MmsRequest: APN failure", (Throwable)e);
                    result = 2;
                    break;
                }
                catch (MmsHttpException e) {
                    Log.e((String)TAG, (String)"MmsRequest: HTTP or network I/O failure", (Throwable)e);
                    result = 4;
                    httpStatusCode = e.getStatusCode();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"MmsRequest: unexpected failure", (Throwable)e);
                    result = 1;
                    break;
                }
                try {
                    Thread.sleep(retryDelaySecs * 1000L, 0);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                retryDelaySecs <<= 1;
            }
        }
        if (!this.mobileDataEnabled) {
            Log.v((String)TAG, (String)"setting mobile data back to disabled");
            Utils.setMobileDataEnabled(context, false);
        }
        if (!MmsRequest.useWifi(context)) {
            wifi.setWifiEnabled(isWifiEnabled);
        }
        this.processResult(context, result, response, httpStatusCode);
    }

    public void processResult(Context context, int result, byte[] response, int httpStatusCode) {
        Uri messageUri = this.persistIfRequired(context, result, response);
        PendingIntent pendingIntent = this.getPendingIntent();
        if (pendingIntent != null) {
            boolean succeeded = true;
            Intent fillIn = new Intent();
            if (response != null) {
                succeeded = this.transferResponse(fillIn, response);
            }
            if (messageUri != null) {
                fillIn.putExtra("uri", messageUri.toString());
            }
            if (result == 4 && httpStatusCode != 0) {
                if (Build.VERSION.SDK_INT >= 22) {
                    fillIn.putExtra("android.telephony.extra.MMS_HTTP_STATUS", httpStatusCode);
                } else {
                    fillIn.putExtra("android.telephony.extra.MMS_HTTP_STATUS", httpStatusCode);
                }
            }
            try {
                if (!succeeded) {
                    result = 5;
                }
                pendingIntent.send(context, result, fillIn);
            }
            catch (PendingIntent.CanceledException e) {
                Log.e((String)TAG, (String)"MmsRequest: sending pending intent canceled", (Throwable)e);
            }
        }
        this.revokeUriPermission(context);
    }

    public static boolean useWifi(Context context) {
        NetworkInfo niWF;
        ConnectivityManager mConnMgr;
        return Utils.isMmsOverWifiEnabled(context) && (mConnMgr = (ConnectivityManager)context.getSystemService("connectivity")) != null && (niWF = mConnMgr.getNetworkInfo(1)) != null && niWF.isConnected();
    }

    protected boolean maybeFallbackToRegularDelivery(int carrierMessagingAppResult) {
        if (carrierMessagingAppResult == 1 || carrierMessagingAppResult == 1) {
            Log.d((String)TAG, (String)"Sending/downloading MMS by IP failed.");
            this.mRequestManager.addSimRequest(this);
            return true;
        }
        return false;
    }

    protected static int toSmsManagerResult(int carrierMessagingAppResult) {
        switch (carrierMessagingAppResult) {
            case 0: {
                return -1;
            }
            case 1: {
                return 6;
            }
        }
        return 1;
    }

    protected abstract byte[] doHttp(Context var1, MmsNetworkManager var2, ApnSettings var3) throws MmsHttpException;

    protected abstract PendingIntent getPendingIntent();

    protected abstract int getQueueType();

    protected abstract Uri persistIfRequired(Context var1, int var2, byte[] var3);

    protected abstract boolean prepareForHttpRequest();

    protected abstract boolean transferResponse(Intent var1, byte[] var2);

    protected abstract void revokeUriPermission(Context var1);

    public static interface RequestManager {
        public void addSimRequest(MmsRequest var1);

        public boolean getAutoPersistingPref();

        public byte[] readPduFromContentUri(Uri var1, int var2);

        public boolean writePduToContentUri(Uri var1, byte[] var2);
    }
}

