/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.telephony.TelephonyManager;
import com.android.mms.MmsConfig;
import com.android.mms.transaction.RetryScheduler;
import com.android.mms.transaction.Transaction;
import com.android.mms.transaction.TransactionSettings;
import com.android.mms.util.DownloadManager;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu_alt.GenericPdu;
import com.google.android.mms.pdu_alt.NotificationInd;
import com.google.android.mms.pdu_alt.NotifyRespInd;
import com.google.android.mms.pdu_alt.PduComposer;
import com.google.android.mms.pdu_alt.PduParser;
import com.google.android.mms.pdu_alt.PduPersister;
import com.google.android.mms.pdu_alt.RetrieveConf;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.BroadcastUtils;
import java.io.IOException;

public class NotificationTransaction
extends Transaction
implements Runnable {
    private static final String TAG = "Mms";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private Uri mUri;
    private NotificationInd mNotificationInd;
    private String mContentLocation;

    public NotificationTransaction(Context context, int serviceId, TransactionSettings connectionSettings, String uriString) {
        super(context, serviceId, connectionSettings);
        this.mUri = Uri.parse((String)uriString);
        try {
            this.mNotificationInd = (NotificationInd)PduPersister.getPduPersister(context).load(this.mUri);
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)("Failed to load NotificationInd from: " + uriString), (Throwable)e);
            throw new IllegalArgumentException();
        }
        this.mId = this.mContentLocation = new String(this.mNotificationInd.getContentLocation());
        this.attach(RetryScheduler.getInstance(context));
    }

    public NotificationTransaction(Context context, int serviceId, TransactionSettings connectionSettings, NotificationInd ind) {
        super(context, serviceId, connectionSettings);
        try {
            boolean group;
            int subId = -1;
            try {
                group = com.klinker.android.send_message.Transaction.settings.getGroup();
                subId = com.klinker.android.send_message.Transaction.settings.getSubscriptionId();
            }
            catch (Exception e) {
                group = PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("group_message", true);
            }
            this.mUri = PduPersister.getPduPersister(context).persist(ind, Telephony.Mms.Inbox.CONTENT_URI, !NotificationTransaction.allowAutoDownload(this.mContext), group, null, subId);
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)"Failed to save NotificationInd in constructor.", (Throwable)e);
            throw new IllegalArgumentException();
        }
        this.mNotificationInd = ind;
        this.mId = new String(this.mNotificationInd.getContentLocation());
    }

    @Override
    public void process() {
        new Thread((Runnable)this, "NotificationTransaction").start();
    }

    public static boolean allowAutoDownload(Context context) {
        try {
            Looper.prepare();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean autoDownload = PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("auto_download_mms", true);
        boolean dataSuspended = ((TelephonyManager)context.getSystemService("phone")).getDataState() == 3;
        return autoDownload && !dataSuspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Looper.prepare();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DownloadManager.init(this.mContext);
        DownloadManager downloadManager = DownloadManager.getInstance();
        boolean autoDownload = NotificationTransaction.allowAutoDownload(this.mContext);
        try {
            int status = 131;
            if (!autoDownload) {
                downloadManager.markState(this.mUri, 128);
                this.sendNotifyRespInd(status);
                return;
            }
            downloadManager.markState(this.mUri, 129);
            byte[] retrieveConfData = null;
            try {
                retrieveConfData = this.getPdu(this.mContentLocation);
            }
            catch (IOException e) {
                this.mTransactionState.setState(2);
            }
            if (retrieveConfData != null) {
                GenericPdu pdu = new PduParser(retrieveConfData).parse();
                if (pdu == null || pdu.getMessageType() != 132) {
                    Log.e((String)TAG, (String)("Invalid M-RETRIEVE.CONF PDU. " + (pdu != null ? "message type: " + pdu.getMessageType() : "null pdu")));
                    this.mTransactionState.setState(2);
                    status = 132;
                } else {
                    PduPersister p = PduPersister.getPduPersister(this.mContext);
                    Uri uri = p.persist(pdu, Telephony.Mms.Inbox.CONTENT_URI, true, com.klinker.android.send_message.Transaction.settings.getGroup(), null, com.klinker.android.send_message.Transaction.settings.getSubscriptionId());
                    ContentValues values = new ContentValues(2);
                    values.put("date", Long.valueOf(System.currentTimeMillis() / 1000L));
                    try {
                        RetrieveConf retrieveConf = (RetrieveConf)pdu;
                        values.put("date_sent", Long.valueOf(retrieveConf.getDate()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SqliteWrapper.update(this.mContext, this.mContext.getContentResolver(), uri, values, null, null);
                    SqliteWrapper.delete(this.mContext, this.mContext.getContentResolver(), this.mUri, null, null);
                    Log.v((String)TAG, (String)("NotificationTransaction received new mms message: " + uri));
                    SqliteWrapper.delete(this.mContext, this.mContext.getContentResolver(), Telephony.Threads.OBSOLETE_THREADS_URI, null, null);
                    this.mUri = uri;
                    status = 129;
                    BroadcastUtils.sendExplicitBroadcast(this.mContext, new Intent(), "com.klinker.android.messaging.NEW_MMS_DOWNLOADED");
                }
            }
            switch (status) {
                case 129: {
                    this.mTransactionState.setState(1);
                    break;
                }
                case 131: {
                    if (this.mTransactionState.getState() != 0) break;
                    this.mTransactionState.setState(1);
                }
            }
            this.sendNotifyRespInd(status);
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)"error", (Throwable)t);
        }
        finally {
            this.mTransactionState.setContentUri(this.mUri);
            if (!autoDownload) {
                this.mTransactionState.setState(1);
            }
            if (this.mTransactionState.getState() != 1) {
                this.mTransactionState.setState(2);
                Log.e((String)TAG, (String)"NotificationTransaction failed.");
            }
            this.notifyObservers();
        }
    }

    private void sendNotifyRespInd(int status) throws MmsException, IOException {
        NotifyRespInd notifyRespInd = new NotifyRespInd(18, this.mNotificationInd.getTransactionId(), status);
        if (MmsConfig.getNotifyWapMMSC()) {
            this.sendPdu(new PduComposer(this.mContext, notifyRespInd).make(), this.mContentLocation);
        } else {
            this.sendPdu(new PduComposer(this.mContext, notifyRespInd).make());
        }
    }

    @Override
    public int getType() {
        return 0;
    }
}

