/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.PowerManager;
import android.telephony.SmsManager;
import android.text.TextUtils;
import com.android.mms.MmsConfig;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.BroadcastUtils;
import com.klinker.android.send_message.SmsManagerFactory;
import java.io.File;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class DownloadManager {
    private static final String TAG = "DownloadManager";
    private static DownloadManager ourInstance = new DownloadManager();
    private static final ConcurrentHashMap<String, MmsDownloadReceiver> mMap = new ConcurrentHashMap();

    public static DownloadManager getInstance() {
        return ourInstance;
    }

    private DownloadManager() {
    }

    @TargetApi(value=21)
    public void downloadMultimediaMessage(Context context, String location, Uri uri, boolean byPush, int subscriptionId) {
        if (location == null || mMap.get(location) != null) {
            return;
        }
        MmsDownloadReceiver receiver = new MmsDownloadReceiver();
        mMap.put(location, receiver);
        context.getApplicationContext().registerReceiver((BroadcastReceiver)receiver, new IntentFilter(receiver.mAction));
        Log.v((String)TAG, (String)"receiving with system method");
        String fileName = "download." + Math.abs(new Random().nextLong()) + ".dat";
        File mDownloadFile = new File(context.getCacheDir(), fileName);
        Uri contentUri = new Uri.Builder().authority(context.getPackageName() + ".MmsFileProvider").path(fileName).scheme("content").build();
        Intent download = new Intent(receiver.mAction);
        download.putExtra("file_path", mDownloadFile.getPath());
        download.putExtra("location_url", location);
        download.putExtra("trigger_push", byPush);
        download.putExtra("notification_ind_uri", (Parcelable)uri);
        download.putExtra("subscription_id", subscriptionId);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)download, (int)0x10000000);
        SmsManager smsManager = SmsManagerFactory.createSmsManager(subscriptionId);
        Bundle configOverrides = new Bundle();
        String httpParams = MmsConfig.getHttpParams();
        if (!TextUtils.isEmpty((CharSequence)httpParams)) {
            configOverrides.putString("httpParams", httpParams);
        }
        this.grantUriPermission(context, contentUri);
        smsManager.downloadMultimediaMessage(context, location, contentUri, configOverrides, pendingIntent);
    }

    private void grantUriPermission(Context context, Uri contentUri) {
        context.grantUriPermission(context.getPackageName() + ".MmsFileProvider", contentUri, 2);
    }

    public static void finishDownload(String location) {
        if (location != null) {
            mMap.remove(location);
        }
    }

    private static class MmsDownloadReceiver
    extends BroadcastReceiver {
        private static final String ACTION_PREFIX = "com.android.mms.transaction.DownloadManager$MmsDownloadReceiver.";
        private final String mAction = "com.android.mms.transaction.DownloadManager$MmsDownloadReceiver." + UUID.randomUUID().toString();

        MmsDownloadReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            context.unregisterReceiver((BroadcastReceiver)this);
            PowerManager pm = (PowerManager)context.getSystemService("power");
            PowerManager.WakeLock wakeLock = pm.newWakeLock(1, "smsmms:download-mms-lock");
            wakeLock.acquire(60000L);
            Intent newIntent = (Intent)intent.clone();
            newIntent.setAction("com.klinker.android.messaging.MMS_RECEIVED");
            BroadcastUtils.sendExplicitBroadcast(context, newIntent, "com.klinker.android.messaging.MMS_RECEIVED");
        }
    }
}

