/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import com.android.mms.logs.LogTag;
import com.android.mms.transaction.MessageSender;
import com.android.mms.transaction.TransactionService;
import com.android.mms.util.SendingProgressTokenManager;
import com.google.android.mms.InvalidHeaderValueException;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu_alt.EncodedStringValue;
import com.google.android.mms.pdu_alt.GenericPdu;
import com.google.android.mms.pdu_alt.PduPersister;
import com.google.android.mms.pdu_alt.ReadRecInd;
import com.google.android.mms.pdu_alt.SendReq;
import com.google.android.mms.util_alt.SqliteWrapper;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.Transaction;

public class MmsMessageSender
implements MessageSender {
    private static final String TAG = "Mms";
    private final Context mContext;
    private final Uri mMessageUri;
    private final long mMessageSize;
    private static final boolean DEFAULT_DELIVERY_REPORT_MODE = false;
    private static final boolean DEFAULT_READ_REPORT_MODE = false;
    private static final long DEFAULT_EXPIRY_TIME = 604800L;
    private static final int DEFAULT_PRIORITY = 129;
    private static final String DEFAULT_MESSAGE_CLASS = "personal";
    private static final String DELIVERY_REPORT_PREFERENCE = "delivery_reports";
    private static final String READ_REPORT_PREFERENCE = "read_reports";

    public MmsMessageSender(Context context, Uri location, long messageSize) {
        this.mContext = context;
        this.mMessageUri = location;
        this.mMessageSize = messageSize;
        if (this.mMessageUri == null) {
            throw new IllegalArgumentException("Null message URI.");
        }
    }

    @Override
    public boolean sendMessage(long token) throws MmsException {
        PduPersister p;
        GenericPdu pdu;
        if (Log.isLoggable((String)TAG, (int)2)) {
            LogTag.debug("sendMessage uri: " + this.mMessageUri, new Object[0]);
        }
        if ((pdu = (p = PduPersister.getPduPersister(this.mContext)).load(this.mMessageUri)).getMessageType() != 128) {
            throw new MmsException("Invalid message: " + pdu.getMessageType());
        }
        SendReq sendReq = (SendReq)pdu;
        this.updatePreferencesHeaders(sendReq);
        sendReq.setMessageClass(DEFAULT_MESSAGE_CLASS.getBytes());
        sendReq.setDate(System.currentTimeMillis() / 1000L);
        sendReq.setMessageSize(this.mMessageSize);
        p.updateHeaders(this.mMessageUri, sendReq);
        long messageId = ContentUris.parseId((Uri)this.mMessageUri);
        if (!this.mMessageUri.toString().startsWith(Telephony.Mms.Draft.CONTENT_URI.toString())) {
            ContentValues values = new ContentValues(7);
            values.put("proto_type", Integer.valueOf(1));
            values.put("msg_id", Long.valueOf(messageId));
            values.put("msg_type", Integer.valueOf(pdu.getMessageType()));
            values.put("err_type", Integer.valueOf(0));
            values.put("err_code", Integer.valueOf(0));
            values.put("retry_index", Integer.valueOf(0));
            values.put("due_time", Integer.valueOf(0));
            SqliteWrapper.insert(this.mContext, this.mContext.getContentResolver(), Telephony.MmsSms.PendingMessages.CONTENT_URI, values);
        } else {
            p.move(this.mMessageUri, Telephony.Mms.Outbox.CONTENT_URI);
        }
        try {
            SendingProgressTokenManager.put(messageId, token);
            this.mContext.startService(new Intent(this.mContext, TransactionService.class));
        }
        catch (Exception e) {
            throw new MmsException("transaction service not registered in manifest");
        }
        return true;
    }

    private void updatePreferencesHeaders(SendReq sendReq) throws MmsException {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext);
        sendReq.setExpiry(604800L);
        sendReq.setPriority(129);
        boolean dr = prefs.getBoolean(DELIVERY_REPORT_PREFERENCE, false);
        sendReq.setDeliveryReport(dr ? 128 : 129);
        boolean rr = prefs.getBoolean(READ_REPORT_PREFERENCE, prefs.getBoolean(DELIVERY_REPORT_PREFERENCE, false));
        sendReq.setReadReport(rr ? 128 : 129);
    }

    public static void sendReadRec(Context context, String to, String messageId, int status) {
        EncodedStringValue[] sender = new EncodedStringValue[]{new EncodedStringValue(to)};
        try {
            boolean group;
            ReadRecInd readRec = new ReadRecInd(new EncodedStringValue("insert-address-token".getBytes()), messageId.getBytes(), 18, status, sender);
            readRec.setDate(System.currentTimeMillis() / 1000L);
            int subId = -1;
            try {
                group = Transaction.settings.getGroup();
                subId = Transaction.settings.getSubscriptionId();
            }
            catch (Exception e) {
                group = PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("group_message", true);
            }
            PduPersister.getPduPersister(context).persist(readRec, Telephony.Mms.Outbox.CONTENT_URI, true, group, null, subId);
            context.startService(new Intent(context, TransactionService.class));
        }
        catch (InvalidHeaderValueException e) {
            Log.e((String)TAG, (String)"Invalide header value", (Throwable)e);
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)"Persist message failed", (Throwable)e);
        }
    }
}

