/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.text.TextUtils;
import com.android.mms.MmsConfig;
import com.android.mms.service_alt.DownloadRequest;
import com.android.mms.service_alt.MmsNetworkManager;
import com.android.mms.service_alt.MmsRequestManager;
import com.android.mms.transaction.DownloadManager;
import com.android.mms.transaction.NotificationTransaction;
import com.android.mms.transaction.TransactionService;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu_alt.DeliveryInd;
import com.google.android.mms.pdu_alt.GenericPdu;
import com.google.android.mms.pdu_alt.NotificationInd;
import com.google.android.mms.pdu_alt.PduParser;
import com.google.android.mms.pdu_alt.PduPersister;
import com.google.android.mms.pdu_alt.ReadOrigInd;
import com.klinker.android.logger.Log;
import com.klinker.android.send_message.BroadcastUtils;
import com.klinker.android.send_message.SmsManagerFactory;
import com.klinker.android.send_message.Transaction;
import com.klinker.android.send_message.Utils;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PushReceiver
extends BroadcastReceiver {
    private static final String TAG = "Mms";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = true;
    static final String[] PROJECTION = new String[]{"ct_l", "locked"};
    static final int COLUMN_CONTENT_LOCATION = 0;
    private static Set<String> downloadedUrls = new HashSet<String>();
    private static final ExecutorService PUSH_RECEIVER_EXECUTOR = Executors.newSingleThreadExecutor();

    public void onReceive(Context context, Intent intent) {
        Log.v((String)TAG, (String)(intent.getAction() + " " + intent.getType()));
        if ((intent.getAction().equals("android.provider.Telephony.WAP_PUSH_DELIVER") || intent.getAction().equals("android.provider.Telephony.WAP_PUSH_RECEIVED")) && "application/vnd.wap.mms-message".equals(intent.getType())) {
            Log.v((String)TAG, (String)("Received PUSH Intent: " + intent));
            SharedPreferences sharedPrefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
            if (!sharedPrefs.getBoolean("receive_with_stock", false) && Build.VERSION.SDK_INT < 19 && sharedPrefs.getBoolean("override", true) || Build.VERSION.SDK_INT >= 19) {
                MmsConfig.init(context);
                new ReceivePushTask(context, null).executeOnExecutor(PUSH_RECEIVER_EXECUTOR, new Intent[]{intent});
                Log.v((String)"mms_receiver", (String)(context.getPackageName() + " received and aborted"));
            } else {
                this.clearAbortBroadcast();
                Intent notificationBroadcast = new Intent("com.klinker.android.messaging.NEW_MMS_DOWNLOADED");
                notificationBroadcast.putExtra("receive_through_stock", true);
                BroadcastUtils.sendExplicitBroadcast(context, notificationBroadcast, "com.klinker.android.messaging.NEW_MMS_DOWNLOADED");
                Log.v((String)"mms_receiver", (String)(context.getPackageName() + " received and not aborted"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentLocation(Context context, Uri uri) throws MmsException {
        Cursor cursor = SqliteWrapper.query(context, context.getContentResolver(), uri, PROJECTION, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.getCount() == 1 && cursor.moveToFirst()) {
                    String location = cursor.getString(0);
                    cursor.close();
                    String string2 = location;
                    return string2;
                }
            }
            finally {
                cursor.close();
            }
        }
        throw new MmsException("Cannot get X-Mms-Content-Location from: " + uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long findThreadId(Context context, GenericPdu pdu, int type) {
        String messageId = type == 134 ? new String(((DeliveryInd)pdu).getMessageId()) : new String(((ReadOrigInd)pdu).getMessageId());
        StringBuilder sb = new StringBuilder(40);
        sb.append("m_id");
        sb.append('=');
        sb.append(DatabaseUtils.sqlEscapeString((String)messageId));
        sb.append(" AND ");
        sb.append("m_type");
        sb.append('=');
        sb.append(128);
        Cursor cursor = SqliteWrapper.query(context, context.getContentResolver(), Telephony.Mms.CONTENT_URI, new String[]{"thread_id"}, sb.toString(), null, null);
        if (cursor != null) {
            try {
                if (cursor.getCount() == 1 && cursor.moveToFirst()) {
                    long id2 = cursor.getLong(0);
                    cursor.close();
                    long l = id2;
                    return l;
                }
            }
            finally {
                cursor.close();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDuplicateNotification(Context context, NotificationInd nInd) {
        byte[] rawLocation = nInd.getContentLocation();
        if (rawLocation != null) {
            String location = new String(rawLocation);
            String selection = "ct_l = ?";
            String[] selectionArgs = new String[]{location};
            Cursor cursor = SqliteWrapper.query(context, context.getContentResolver(), Telephony.Mms.CONTENT_URI, new String[]{"_id"}, selection, selectionArgs, null);
            if (cursor != null) {
                try {
                    if (cursor.getCount() > 0) {
                        cursor.close();
                    }
                }
                finally {
                    cursor.close();
                }
            }
        }
        return false;
    }

    static /* synthetic */ long access$000(Context x0, GenericPdu x1, int x2) {
        return PushReceiver.findThreadId(x0, x1, x2);
    }

    static /* synthetic */ boolean access$100(Context x0, NotificationInd x1) {
        return PushReceiver.isDuplicateNotification(x0, x1);
    }

    static /* synthetic */ Set access$200() {
        return downloadedUrls;
    }

    private class ReceivePushTask
    extends AsyncTask<Intent, Void, Void> {
        private Context mContext;
        private BroadcastReceiver.PendingResult pendingResult;

        ReceivePushTask(Context context, BroadcastReceiver.PendingResult pendingResult) {
            this.mContext = context;
            this.pendingResult = pendingResult;
        }

        /*
         * Unable to fully structure code
         */
        protected Void doInBackground(Intent ... intents) {
            Log.v((String)"Mms", (String)"receiving a new mms message");
            intent = intents[0];
            pushData = intent.getByteArrayExtra("data");
            parser = new PduParser(pushData);
            pdu = parser.parse();
            if (null == pdu) {
                Log.e((String)"Mms", (String)"Invalid PUSH data");
                return null;
            }
            p = PduPersister.getPduPersister(this.mContext);
            cr = this.mContext.getContentResolver();
            type = pdu.getMessageType();
            threadId = -1L;
            subId = intent.getIntExtra("subscription", -1);
            try {
                switch (type) {
                    case 134: 
                    case 136: {
                        threadId = PushReceiver.access$000(this.mContext, pdu, type);
                        if (threadId == -1L) break;
                        try {
                            group = Transaction.settings.getGroup();
                        }
                        catch (Exception e) {
                            group = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext).getBoolean("group_message", true);
                        }
                        uri = p.persist(pdu, Uri.parse((String)"content://mms/inbox"), true, group, null, subId);
                        values = new ContentValues(1);
                        values.put("thread_id", Long.valueOf(threadId));
                        SqliteWrapper.update(this.mContext, cr, uri, values, null, null);
                        break;
                    }
                    case 130: {
                        nInd = (NotificationInd)pdu;
                        appendTransactionId = false;
                        if (Build.VERSION.SDK_INT >= 21 && (appendTransactionId = (configOverrides = SmsManagerFactory.createSmsManager(subId).getCarrierConfigValues()).getBoolean("enabledTransID"))) {
                            Log.v((String)"Mms", (String)"appending the transaction ID, based on the SMS manager overrides");
                        }
                        if ((MmsConfig.getTransIdEnabled() || appendTransactionId) && 61 == (contentLocation = nInd.getContentLocation())[contentLocation.length - 1]) {
                            transactionId = nInd.getTransactionId();
                            contentLocationWithId = new byte[contentLocation.length + transactionId.length];
                            System.arraycopy(contentLocation, 0, contentLocationWithId, 0, contentLocation.length);
                            System.arraycopy(transactionId, 0, contentLocationWithId, contentLocation.length, transactionId.length);
                            nInd.setContentLocation(contentLocationWithId);
                        }
                        if (PushReceiver.access$100(this.mContext, nInd)) ** GOTO lbl89
                        try {
                            group = Transaction.settings.getGroup();
                        }
                        catch (Exception e) {
                            group = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext).getBoolean("group_message", true);
                        }
                        uri = p.persist(pdu, Telephony.Mms.Inbox.CONTENT_URI, NotificationTransaction.allowAutoDownload(this.mContext) == false, group, null, subId);
                        try {
                            location = PushReceiver.getContentLocation(this.mContext, uri);
                        }
                        catch (MmsException ex) {
                            location = p.getContentLocationFromPduHeader(pdu);
                            if (!TextUtils.isEmpty((CharSequence)location)) ** GOTO lbl55
                            throw ex;
                        }
lbl55:
                        // 2 sources

                        if (PushReceiver.access$200().contains(location)) {
                            Log.v((String)"Mms", (String)"already added this download, don't download again");
                            return null;
                        }
                        PushReceiver.access$200().add(location);
                        if (Build.VERSION.SDK_INT >= 21) {
                            Log.v((String)"Mms", (String)"receiving on a lollipop+ device");
                            useSystem = true;
                            useSystem = Transaction.settings != null ? Transaction.settings.getUseSystemSending() : PreferenceManager.getDefaultSharedPreferences((Context)this.mContext).getBoolean("system_mms_sending", useSystem);
                            if (useSystem) {
                                DownloadManager.getInstance().downloadMultimediaMessage(this.mContext, location, uri, true, subId);
                                break;
                            }
                            Log.v((String)"Mms", (String)"receiving with lollipop method");
                            requestManager = new MmsRequestManager(this.mContext);
                            request = new DownloadRequest(requestManager, Utils.getDefaultSubscriptionId(), location, uri, null, null, null, this.mContext);
                            manager = new MmsNetworkManager(this.mContext, Utils.getDefaultSubscriptionId());
                            request.execute(this.mContext, manager);
                            break;
                        }
                        if (NotificationTransaction.allowAutoDownload(this.mContext)) {
                            svc = new Intent(this.mContext, TransactionService.class);
                            svc.putExtra("uri", uri.toString());
                            svc.putExtra("type", 0);
                            svc.putExtra("receive_with_new_method", Build.VERSION.SDK_INT >= 21);
                            this.mContext.startService(svc);
                            break;
                        }
                        notificationBroadcast = new Intent("com.klinker.android.messaging.NEW_MMS_DOWNLOADED");
                        notificationBroadcast.putExtra("receive_through_stock", true);
                        BroadcastUtils.sendExplicitBroadcast(this.mContext, notificationBroadcast, "com.klinker.android.messaging.NEW_MMS_DOWNLOADED");
                        break;
lbl89:
                        // 1 sources

                        Log.v((String)"Mms", (String)("Skip downloading duplicate message: " + new String(nInd.getContentLocation())));
                        break;
                    }
                    default: {
                        Log.e((String)"Mms", (String)"Received unrecognized PDU.");
                    }
                }
            }
            catch (MmsException e) {
                Log.e((String)"Mms", (String)("Failed to save the data from PUSH: type=" + type), (Throwable)e);
            }
            catch (RuntimeException e) {
                Log.e((String)"Mms", (String)"Unexpected RuntimeException.", (Throwable)e);
            }
            Log.v((String)"Mms", (String)"PUSH Intent processed.");
            return null;
        }

        public void onPostExecute(Void result) {
            if (this.pendingResult != null) {
                this.pendingResult.finish();
            }
        }
    }
}

