/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint;

import com.fasterxml.jackson.databind.JsonNode;
import com.kloudtek.anypoint.Environment;
import com.kloudtek.anypoint.HttpException;
import com.kloudtek.anypoint.NotFoundException;
import com.kloudtek.anypoint.Organization;
import com.kloudtek.anypoint.Service;
import com.kloudtek.anypoint.User;
import com.kloudtek.anypoint.deploy.DeploymentService;
import com.kloudtek.anypoint.util.HttpHelper;
import com.kloudtek.anypoint.util.JsonHelper;
import com.kloudtek.util.StringUtils;
import com.kloudtek.util.UnexpectedException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

public class AnypointClient
implements Closeable,
Serializable {
    public static final String LOGIN_PATH = "/accounts/login";
    protected JsonHelper jsonHelper;
    protected HttpHelper httpHelper;
    private int maxParallelDeployments = 5;
    private transient ExecutorService deploymentThreadPool;
    private String username;
    private String password;
    private DeploymentService deploymentService;

    public AnypointClient() {
        this.init();
    }

    public AnypointClient(String username, String password) {
        this(username, password, 3);
    }

    public AnypointClient(String username, String password, int maxParallelDeployments) {
        this.username = username;
        this.password = password;
        this.maxParallelDeployments = maxParallelDeployments;
        this.httpHelper = new HttpHelper(this, username, password);
        this.init();
    }

    private void init() {
        this.jsonHelper = new JsonHelper(this);
        this.deploymentService = this.loadService(DeploymentService.class);
        this.deploymentThreadPool = Executors.newFixedThreadPool(this.maxParallelDeployments);
    }

    private <X> X loadService(Class<X> serviceClass) {
        X service;
        ServiceLoader<X> serviceLoader = ServiceLoader.load(serviceClass);
        Iterator<X> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            service = iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalStateException("Found multiple implementations of ProvisioningService");
            }
        } else {
            try {
                service = serviceClass.isInterface() ? Class.forName(serviceClass.getName() + "Impl").asSubclass(serviceClass).newInstance() : serviceClass.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new UnexpectedException((Throwable)e);
            }
        }
        if (service instanceof Service) {
            ((Service)service).setClient(this);
        }
        return service;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.deploymentThreadPool = Executors.newFixedThreadPool(this.maxParallelDeployments);
    }

    public int getMaxParallelDeployments() {
        return this.maxParallelDeployments;
    }

    public synchronized void setMaxParallelDeployments(int maxParallelDeployments) {
        if (maxParallelDeployments <= 0) {
            throw new IllegalArgumentException("maxParallelDeployments " + maxParallelDeployments + " is invalid (must be greater than 0)");
        }
        this.maxParallelDeployments = maxParallelDeployments;
        if (this.deploymentThreadPool != null) {
            this.deploymentThreadPool.shutdown();
        }
        this.deploymentThreadPool = Executors.newFixedThreadPool(maxParallelDeployments);
    }

    @Override
    public void close() throws IOException {
        this.httpHelper.close();
        if (this.deploymentThreadPool != null) {
            this.deploymentThreadPool.shutdown();
        }
    }

    public List<Organization> findOrganizations() throws HttpException {
        String json = this.httpHelper.httpGet("/accounts/api/me");
        ArrayList<Organization> list = new ArrayList<Organization>();
        for (JsonNode node : this.jsonHelper.readJsonTree(json).at("/user/memberOfOrganizations")) {
            list.add(this.jsonHelper.readJson(this.createOrganizationObject(), node));
        }
        return list;
    }

    @NotNull
    public Organization findOrganization(String name) throws NotFoundException, HttpException {
        for (Organization organization : this.findOrganizations()) {
            if (!organization.getName().equals(name)) continue;
            return organization;
        }
        throw new NotFoundException("Organization not found: " + name);
    }

    public Organization findOrganizationById(String id) throws HttpException, NotFoundException {
        Organization organization = this.createOrganizationObject();
        organization.setId(id);
        try {
            String json = this.httpHelper.httpGet(organization.getUriPath());
            this.jsonHelper.readJson(organization, json);
            return organization;
        }
        catch (HttpException e) {
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Enable to find organization " + id, e);
            }
            throw e;
        }
    }

    public User getUser() throws HttpException {
        String json = this.httpHelper.httpGet("/accounts/api/me");
        return this.jsonHelper.readJson(new User(), json, "/user");
    }

    public Organization createOrganization(String name) throws HttpException {
        User user = this.getUser();
        return user.getOrganization().createSubOrganization(name, user.getId(), true, true);
    }

    public Organization createOrganization(String name, String ownerId, boolean createSubOrgs, boolean createEnvironments) throws HttpException {
        return this.getUser().getOrganization().createSubOrganization(name, ownerId, createSubOrgs, createEnvironments);
    }

    public Organization createOrganization(String name, String ownerId, boolean createSubOrgs, boolean createEnvironments, boolean globalDeployment, int vCoresProduction, int vCoresSandbox, int vCoresDesign, int staticIps, int vpcs, int loadBalancer) throws HttpException {
        return this.getUser().getOrganization().createSubOrganization(name, ownerId, createSubOrgs, createEnvironments, globalDeployment, vCoresProduction, vCoresSandbox, vCoresDesign, staticIps, vpcs, loadBalancer);
    }

    public JsonHelper getJsonHelper() {
        return this.jsonHelper;
    }

    public HttpHelper getHttpHelper() {
        return this.httpHelper;
    }

    public void setHttpHelper(HttpHelper httpHelper) {
        this.httpHelper = httpHelper;
        httpHelper.setClient(this);
    }

    public String authenticate(String username, String password) throws HttpException {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("Username missing");
        }
        if (StringUtils.isBlank((String)password)) {
            throw new IllegalArgumentException("Username missing");
        }
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("username", username);
        request.put("password", password);
        Map<String, Object> data = this.jsonHelper.toJsonMap(this.httpHelper.httpPost(LOGIN_PATH, request));
        return data.get("token_type") + " " + data.get("access_token");
    }

    public Environment findEnvironment(String organizationName, String environmentName, boolean createOrganization, boolean createEnvironment, Environment.Type createEnvironmentType) throws NotFoundException, HttpException {
        Organization organization;
        try {
            organization = this.findOrganization(organizationName);
        }
        catch (NotFoundException e) {
            if (createOrganization) {
                organization = this.createOrganization(organizationName);
            }
            throw e;
        }
        try {
            return organization.findEnvironmentByName(environmentName);
        }
        catch (NotFoundException e) {
            if (createEnvironment) {
                return organization.createEnvironment(environmentName, createEnvironmentType);
            }
            throw e;
        }
    }

    public String getUserId() throws HttpException {
        return this.getUser().getId();
    }

    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public void applyAlerts(File alertsJsonFile) throws IOException, HttpException {
        throw new RuntimeException("Not implemented");
    }

    @NotNull
    protected Organization createOrganizationObject() {
        return new Organization(this);
    }

    public void setProxy(String scheme, String host, int port, String username, String password) {
        this.httpHelper.setProxy(scheme, host, port, username, password);
    }

    public void unsetProxy() {
        this.httpHelper.unsetProxy();
    }
}

