/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.kloudtek.anypoint.AnypointClient;
import com.kloudtek.anypoint.AnypointObject;
import com.kloudtek.anypoint.HttpException;
import com.kloudtek.anypoint.NotFoundException;
import com.kloudtek.anypoint.Organization;
import com.kloudtek.anypoint.api.API;
import com.kloudtek.anypoint.api.APIAsset;
import com.kloudtek.anypoint.api.APIList;
import com.kloudtek.anypoint.api.APISpec;
import com.kloudtek.anypoint.cloudhub.CHMuleVersion;
import com.kloudtek.anypoint.cloudhub.CHRegion;
import com.kloudtek.anypoint.cloudhub.CHWorkerType;
import com.kloudtek.anypoint.runtime.CHApplication;
import com.kloudtek.anypoint.runtime.Server;
import com.kloudtek.anypoint.runtime.ServerGroup;
import com.kloudtek.util.StringUtils;
import com.kloudtek.util.UnexpectedException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.HttpRequestBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment
extends AnypointObject<Organization> {
    private static final Logger logger = LoggerFactory.getLogger(Environment.class);
    private String id;
    private String name;
    private boolean production;
    private String type;
    private String clientId;

    public Environment() {
    }

    public Environment(Organization organization) {
        super(organization);
    }

    public Environment(Organization organization, String id) {
        super(organization);
        this.id = id;
    }

    @JsonIgnore
    public Organization getOrganization() {
        return (Organization)this.parent;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="isProduction")
    public boolean isProduction() {
        return this.production;
    }

    public void setProduction(boolean production) {
        this.production = production;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() throws HttpException {
        String json = this.httpHelper.httpGet("/accounts/api/organizations/" + ((Organization)this.parent).getId() + "/clients/" + this.clientId);
        try {
            return this.jsonHelper.getJsonMapper().readTree(json).at("/client_secret").textValue();
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    @NotNull
    public String getServerRegistrationKey() throws HttpException {
        String json = this.httpHelper.httpGet("/hybrid/api/v1/servers/registrationToken", this);
        return (String)this.jsonHelper.toJsonMap(json).get("data");
    }

    public List<Server> findAllServers() throws HttpException {
        String json = this.client.getHttpHelper().httpGet("/armui/api/v1/servers", this);
        ArrayList<Server> list = new ArrayList<Server>();
        for (JsonNode node : this.jsonHelper.readJsonTree(json).at("/data")) {
            JsonNode type = node.get("type");
            Server s = type.asText().equals("SERVER_GROUP") ? (Server)this.jsonHelper.readJson(new ServerGroup(this), node) : this.jsonHelper.readJson(new Server(this), node);
            list.add(s);
        }
        return list;
    }

    public ServerGroup createServerGroup(String name, String ... serverIds) throws HttpException {
        if (serverIds == null) {
            serverIds = new String[]{};
        }
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("name", name);
        request.put("serverIds", serverIds);
        String json = this.httpHelper.httpPost("/hybrid/api/v1/serverGroups", request, this);
        return this.jsonHelper.readJson(new ServerGroup(this), json, "/data");
    }

    @NotNull
    public Server findServerByName(@NotNull String name) throws NotFoundException, HttpException {
        for (Server server : this.findAllServers()) {
            if (!name.equals(server.getName())) continue;
            return server;
        }
        throw new NotFoundException("Cannot find server : " + name);
    }

    public void addHeaders(HttpRequestBase method) {
        method.setHeader("X-ANYPNT-ORG-ID", ((Organization)this.parent).getId());
        method.setHeader("X-ANYPNT-ENV-ID", this.id);
    }

    public void delete() throws HttpException {
        for (Server server : this.findAllServers()) {
            server.delete();
        }
        this.httpHelper.httpDelete("/accounts/api/organizations/" + ((Organization)this.parent).getId() + "/environments/" + this.id);
        logger.info("Deleted environment " + this.id + " : " + this.name);
    }

    public Environment rename(String newName) throws HttpException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("id", this.id);
        req.put("name", newName);
        req.put("organizationId", ((Organization)this.parent).getId());
        String json = this.httpHelper.httpPut("/accounts/api/organizations/" + ((Organization)this.parent).getId() + "/environments/" + this.id, req);
        return this.jsonHelper.readJson(new Environment((Organization)this.parent), json);
    }

    public String toString() {
        return "Environment{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", production=" + this.production + ", type='" + this.type + '\'' + ", clientId='" + this.clientId + '\'' + "} " + super.toString();
    }

    public APIList findAllAPIs() throws HttpException {
        return this.findAPIs(null);
    }

    public APIList findAPIs(String filter) throws HttpException {
        return new APIList(this, filter);
    }

    public API findAPIByExchangeAssetNameAndVersion(@NotNull String name, @NotNull String version) throws HttpException, NotFoundException {
        return this.findAPIByExchangeAssetNameAndVersion(name, version, null);
    }

    public API findAPIByExchangeAssetNameAndVersion(@NotNull String name, @NotNull String version, @Nullable String label) throws HttpException, NotFoundException {
        for (APIAsset asset : this.findAPIs(name)) {
            if (!asset.getExchangeAssetName().equalsIgnoreCase(name)) continue;
            for (API api : asset.getApis()) {
                if (!api.getAssetVersion().equalsIgnoreCase(version) || label != null && !label.equalsIgnoreCase(api.getInstanceLabel())) continue;
                return api;
            }
        }
        throw new NotFoundException("API " + name + " " + version + " not found");
    }

    public API findAPIByExchangeAsset(@NotNull String groupId, @NotNull String assetId, @NotNull String assetVersion) throws HttpException, NotFoundException {
        return this.findAPIByExchangeAsset(groupId, assetId, assetVersion, null);
    }

    public API findAPIByExchangeAsset(@NotNull String groupId, @NotNull String assetId, @NotNull String assetVersion, @Nullable String label) throws HttpException, NotFoundException {
        if (StringUtils.isBlank((String)groupId)) {
            throw new IllegalArgumentException("groupId missing (null or blank)");
        }
        if (StringUtils.isBlank((String)assetId)) {
            throw new IllegalArgumentException("assetId missing (null or blank)");
        }
        if (StringUtils.isBlank((String)assetVersion)) {
            throw new IllegalArgumentException("assetVersion missing (null or blank)");
        }
        for (APIAsset asset : this.findAllAPIs()) {
            if (!asset.getGroupId().equalsIgnoreCase(groupId) || !asset.getAssetId().equalsIgnoreCase(assetId)) continue;
            for (API api : asset.getApis()) {
                if (!api.getAssetVersion().equalsIgnoreCase(assetVersion) || label != null && !label.equalsIgnoreCase(api.getInstanceLabel())) continue;
                return api;
            }
        }
        throw new NotFoundException("API based on exchange asset not found: groupId=" + groupId + ", assetId=" + assetId + ", assetVersion=" + assetVersion + ", label=" + label);
    }

    public CHApplication findCHApplicationByDomain(String domain) throws HttpException, NotFoundException {
        return CHApplication.find(this, domain);
    }

    public Environment refresh() throws NotFoundException, HttpException {
        return Environment.findEnvironmentById(this.id, this.client, (Organization)this.parent);
    }

    public API createAPI(@NotNull APISpec apiSpec, boolean mule4, @Nullable String endpointUrl, @Nullable String label) throws HttpException {
        return API.create(this, apiSpec, mule4, endpointUrl, label);
    }

    public static List<Environment> findEnvironmentsByOrg(@NotNull AnypointClient client, @NotNull Organization organization) throws HttpException {
        String json = client.getHttpHelper().httpGet("/accounts/api/organizations/" + organization.getId() + "/environments");
        return client.getJsonHelper().readJsonList(organization.getEnvironmentClass(), json, organization, "/data");
    }

    @NotNull
    public static Environment findEnvironmentByName(@NotNull String name, @NotNull AnypointClient client, @NotNull Organization organization) throws HttpException, NotFoundException {
        for (Environment environment : Environment.findEnvironmentsByOrg(client, organization)) {
            if (!name.equals(environment.getName())) continue;
            return environment;
        }
        throw new NotFoundException("Environment not found: " + name);
    }

    @NotNull
    public static Environment findEnvironmentById(@NotNull String id, @NotNull AnypointClient client, @NotNull Organization organization) throws HttpException, NotFoundException {
        String json = null;
        try {
            json = client.getHttpHelper().httpGet("/accounts/api/organizations/" + organization.getId() + "/environments/" + id);
            return client.getJsonHelper().readJson(organization.createEnvironmentObject(), json, organization);
        }
        catch (HttpException e) {
            if (e.getStatusCode() == 404) {
                throw new NotFoundException("Environment with id " + id + " not found within org " + organization.getId());
            }
            throw e;
        }
    }

    public String getNameOrId() {
        return this.name != null ? "(name) " + this.name : "(id) " + this.id;
    }

    public List<CHMuleVersion> findCHMuleVersions() throws HttpException {
        String json = this.client.getHttpHelper().httpGet("/cloudhub/api/mule-versions", this);
        return this.client.getJsonHelper().readJsonList(CHMuleVersion.class, json, this, "/data");
    }

    public CHMuleVersion findDefaultCHMuleVersion() throws HttpException {
        for (CHMuleVersion version : this.findCHMuleVersions()) {
            if (!version.isDefaultVersion()) continue;
            return version;
        }
        throw new UnexpectedException("No default mule version found");
    }

    public CHMuleVersion findCHMuleVersion(String muleVersion) throws NotFoundException, HttpException {
        for (CHMuleVersion version : this.findCHMuleVersions()) {
            if (!version.getVersion().equalsIgnoreCase(muleVersion)) continue;
            return version;
        }
        throw new NotFoundException("Unable to find mule version " + muleVersion);
    }

    public List<CHRegion> findAllCHRegions() throws HttpException {
        String json = this.client.getHttpHelper().httpGet("/cloudhub/api/regions", this);
        return this.client.getJsonHelper().readJsonList(CHRegion.class, json, this);
    }

    public CHRegion findDefaultCHRegion() throws HttpException {
        for (CHRegion region : this.findAllCHRegions()) {
            if (!region.isDefaultRegion()) continue;
            return region;
        }
        throw new UnexpectedException("No default mule version found");
    }

    public List<CHWorkerType> findAllWorkerTypes() throws HttpException {
        String json = this.client.getHttpHelper().httpGet("/cloudhub/api/organization", this);
        return this.client.getJsonHelper().readJsonList(CHWorkerType.class, json, this, "/plan/workerTypes");
    }

    public CHWorkerType findWorkerTypeByName(String name) throws HttpException, NotFoundException {
        for (CHWorkerType workerType : this.findAllWorkerTypes()) {
            if (!workerType.getName().equalsIgnoreCase(name)) continue;
            return workerType;
        }
        throw new NotFoundException("Unable to find worker type in plan: " + name);
    }

    public CHWorkerType findSmallestWorkerType() throws HttpException {
        CHWorkerType smallest = null;
        for (CHWorkerType workerType : this.findAllWorkerTypes()) {
            if (smallest != null && smallest.getWorkerVal().compareTo(workerType.getWorkerVal()) <= 0) continue;
            smallest = workerType;
        }
        return smallest;
    }

    public static Map<String, Environment> toMapIdxByName(Collection<Environment> envs) {
        HashMap<String, Environment> map = new HashMap<String, Environment>();
        for (Environment env : envs) {
            map.put(env.getName(), env);
        }
        return map;
    }

    public static Map<String, Environment> toMapIdxById(Collection<Environment> envs) {
        HashMap<String, Environment> map = new HashMap<String, Environment>();
        for (Environment env : envs) {
            map.put(env.getId(), env);
        }
        return map;
    }

    public static enum Type {
        DESIGN,
        SANDBOX,
        PRODUCTION;

    }
}

