/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.kloudtek.anypoint.AnypointClient;
import com.kloudtek.anypoint.AnypointObject;
import com.kloudtek.anypoint.Environment;
import com.kloudtek.anypoint.HttpException;
import com.kloudtek.anypoint.NotFoundException;
import com.kloudtek.anypoint.VPC;
import com.kloudtek.anypoint.VPCInternalDns;
import com.kloudtek.anypoint.api.APIAsset;
import com.kloudtek.anypoint.api.APISpec;
import com.kloudtek.anypoint.api.APISpecList;
import com.kloudtek.anypoint.api.ClientApplication;
import com.kloudtek.anypoint.api.ClientApplicationList;
import com.kloudtek.anypoint.api.DesignCenterProject;
import com.kloudtek.anypoint.exchange.AssetList;
import com.kloudtek.anypoint.exchange.AssetVersion;
import com.kloudtek.anypoint.exchange.ExchangeAsset;
import com.kloudtek.anypoint.exchange.ExchangeAssetOverview;
import com.kloudtek.anypoint.provisioning.VPCOrgProvisioningDescriptor;
import com.kloudtek.anypoint.provisioning.VPCProvisioningDescriptor;
import com.kloudtek.anypoint.runtime.manifest.ReleaseManifest;
import com.kloudtek.anypoint.util.JsonHelper;
import com.kloudtek.util.BackendAccessException;
import com.kloudtek.util.ThreadUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Organization
extends AnypointObject {
    public static final Pattern MAJORVERSION_REGEX = Pattern.compile("(\\d*)\\..*");
    private static final Logger logger = LoggerFactory.getLogger(Organization.class);
    @JsonProperty
    protected String id;
    @JsonProperty
    protected String name;
    @JsonProperty
    protected String parentId;
    @JsonProperty(value="isFederated")
    protected boolean federated;

    public Organization() {
    }

    public Organization(AnypointClient client) {
        super(client);
    }

    public Organization(AnypointClient client, String id) {
        super(client);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isFederated() {
        return this.federated;
    }

    public void setFederated(boolean federated) {
        this.federated = federated;
    }

    public List<Environment> findAllEnvironments() throws HttpException {
        return Environment.findEnvironmentsByOrg(this.client, this);
    }

    @NotNull
    public Environment findEnvironmentByName(@NotNull String name) throws NotFoundException, HttpException {
        return Environment.findEnvironmentByName(name, this.client, this);
    }

    @NotNull
    public Environment findEnvironmentById(@NotNull String id) throws NotFoundException, HttpException {
        return Environment.findEnvironmentById(id, this.client, this);
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Organization getParentOrganization() throws HttpException {
        if (this.parentId != null) {
            try {
                return this.client.findOrganizationById(this.parentId);
            }
            catch (NotFoundException e) {
                throw (HttpException)e.getCause();
            }
        }
        return null;
    }

    public Organization getRootOrganization() throws HttpException {
        if (this.parentId != null) {
            return this.getParentOrganization().getRootOrganization();
        }
        return this;
    }

    public Environment createEnvironment(@NotNull String name, @NotNull Environment.Type type) throws HttpException {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("name", name);
        request.put("type", type.name().toLowerCase());
        request.put("organizationId", this.id);
        String json = this.client.getHttpHelper().httpPost("https://anypoint.mulesoft.com/accounts/api/organizations/" + this.id + "/environments", request);
        return this.jsonHelper.readJson(this.createEnvironmentObject(), json);
    }

    public ClientApplication createClientApplication(String name, String url, String description) throws HttpException {
        return ClientApplication.create(this.getRootOrganization(), name, url, description, Collections.emptyList(), null);
    }

    public ClientApplication createClientApplication(String name, String url, String description, List<String> redirectUri, String apiEndpoints) throws HttpException {
        return ClientApplication.create(this.getRootOrganization(), name, url, description, redirectUri, apiEndpoints);
    }

    public Organization createSubOrganization(String name, String ownerId, boolean createSubOrgs, boolean createEnvironments) throws HttpException {
        return this.createSubOrganization(name, ownerId, createSubOrgs, createEnvironments, false, 0, 0, 0, 0, 0, 0);
    }

    public List<ClientApplication> findAllClientApplications() throws HttpException {
        return this.findAllClientApplications(null);
    }

    public List<ClientApplication> findAllClientApplications(@Nullable String filter) throws HttpException {
        return ClientApplication.find(this.getRootOrganization(), filter);
    }

    public ClientApplication findClientApplicationByName(@NotNull String name) throws HttpException, NotFoundException {
        return this.findClientApplicationByName(name, true);
    }

    public ClientApplication findClientApplicationByName(@NotNull String name, boolean fullData) throws HttpException, NotFoundException {
        ClientApplication app = this.findClientApplicationByName(new ClientApplicationList(this, name), name, fullData);
        if (app == null) {
            app = this.findClientApplicationByName(this.findAllClientApplications(name), name, fullData);
        }
        if (app == null) {
            throw new NotFoundException("Client application not found: " + name);
        }
        return app;
    }

    @Nullable
    private ClientApplication findClientApplicationByName(Iterable<ClientApplication> list, @NotNull String name, boolean fullData) throws HttpException {
        for (ClientApplication app : list) {
            if (!name.equals(app.getName())) continue;
            if (fullData) {
                return this.jsonHelper.readJson(app, this.httpHelper.httpGet(app.getUriPath()));
            }
            return app;
        }
        return null;
    }

    @NotNull
    public APISpecList findAPISpecsByFilter(@Nullable String filter) throws HttpException {
        return new APISpecList(this, filter);
    }

    public APISpec findAPISpecsByNameAndVersion(String name, String version) throws NotFoundException, HttpException {
        for (APISpec apiSpec : this.findAPISpecsByFilter(name)) {
            if (!apiSpec.getName().equalsIgnoreCase(name) || !apiSpec.getVersion().equalsIgnoreCase(version)) continue;
            return apiSpec;
        }
        throw new NotFoundException("Couldn't find api spec " + name + " " + version);
    }

    public Organization createSubOrganization(String name, String ownerId, boolean createSubOrgs, boolean createEnvironments, boolean globalDeployment, int vCoresProduction, int vCoresSandbox, int vCoresDesign, int staticIps, int vpcs, int loadBalancer) throws HttpException {
        JsonHelper.MapBuilder builder = this.client.getJsonHelper().buildJsonMap().set("name", name).set("parentOrganizationId", this.id).set("ownerId", ownerId);
        Map<String, Object> req = builder.addMap("entitlements").set("createSubOrgs", createSubOrgs).set("createEnvironments", createEnvironments).set("globalDeployment", globalDeployment).setNested("vCoresProduction", "assigned", vCoresProduction).setNested("vCoresSandbox", "assigned", vCoresSandbox).setNested("vCoresDesign", "assigned", vCoresDesign).setNested("staticIps", "assigned", staticIps).setNested("vpcs", "assigned", vpcs).setNested("loadBalancer", "assigned", loadBalancer).setNested("staticIps", "assigned", staticIps).toMap();
        String json = this.httpHelper.httpPost("/accounts/api/organizations", req);
        return this.jsonHelper.readJson(new Organization(this.client), json);
    }

    public void delete() throws HttpException {
        this.deleteSubElements();
        long timeout = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(60L);
        while (true) {
            try {
                this.httpHelper.httpDelete("/accounts/api/organizations/" + this.id);
            }
            catch (HttpException e) {
                if (System.currentTimeMillis() > timeout) {
                    throw e;
                }
                this.deleteSubElements();
                ThreadUtils.sleep((long)1500L);
                continue;
            }
            break;
        }
    }

    private void deleteSubElements() throws HttpException {
        for (Environment environment : this.findAllEnvironments()) {
            for (APIAsset api : environment.findAPIs(null)) {
                api.delete();
            }
        }
        this.findExchangeAssets().delete();
    }

    @JsonIgnore
    public String getUriPath() {
        return "/apiplatform/repository/v2/organizations/" + this.id;
    }

    public String toString() {
        return "Organization{id='" + this.id + '\'' + ", name='" + this.name + '\'' + "} " + super.toString();
    }

    public List<DesignCenterProject> findDesignCenterProjects() throws HttpException {
        String json = this.httpHelper.httpGet("/designcenter/api/v1/organizations/" + this.id + "/projects?pageSize=500&pageIndex=0");
        return this.jsonHelper.readJsonList(DesignCenterProject.class, json, this);
    }

    public DesignCenterProject findDesignCenterProject(String name) throws NotFoundException, HttpException {
        for (DesignCenterProject project : this.findDesignCenterProjects()) {
            if (!name.equalsIgnoreCase(project.getName())) continue;
            return project;
        }
        throw new NotFoundException();
    }

    public DesignCenterProject createDesignCenterProject(String name, String type, boolean visualDesignerMode, String ownerId) throws HttpException {
        return DesignCenterProject.create(this, name, type, visualDesignerMode, ownerId);
    }

    public AssetList findExchangeAssets() throws HttpException {
        return new AssetList(this, null, 50);
    }

    public AssetList findExchangeAssets(String filter, int limit) throws HttpException {
        return new AssetList(this, filter, limit);
    }

    public ExchangeAsset findExchangeAsset(@NotNull String groupId, @NotNull String assetId) throws HttpException, NotFoundException {
        for (ExchangeAssetOverview assetOverview : this.findExchangeAssets()) {
            if (!groupId.equals(assetOverview.getGroupId()) || !assetId.equals(assetOverview.getAssetId())) continue;
            return assetOverview.getAsset();
        }
        throw new NotFoundException("Asset not found: " + groupId + ":" + assetId);
    }

    public AssetVersion findExchangeAssetVersion(@NotNull String groupId, @NotNull String assetId, @NotNull String version) throws HttpException, NotFoundException {
        for (AssetVersion assetVersion : this.findExchangeAsset(groupId, assetId).getVersions()) {
            if (!version.equals(assetVersion.getVersion())) continue;
            return assetVersion;
        }
        throw new NotFoundException("Asset not found: " + groupId + ":" + assetId + ":" + version);
    }

    @NotNull
    protected Environment createEnvironmentObject() {
        return new Environment(this);
    }

    @NotNull
    protected Class<? extends Environment> getEnvironmentClass() {
        return Environment.class;
    }

    public VPC provisionVPC(VPCProvisioningDescriptor vd, boolean deleteExisting) throws NotFoundException, HttpException {
        if (deleteExisting) {
            try {
                VPC preExistingVPC = this.findVPCByName(vd.getName());
                preExistingVPC.delete();
            }
            catch (NotFoundException e) {
                logger.debug("No pre-existing VPC exists");
            }
        }
        VPC vpc = new VPC(vd.getName(), vd.getCidrBlock(), vd.isDefaultVpc(), vd.getRegion());
        ArrayList<String> envIds = new ArrayList<String>();
        ArrayList<String> orgIds = new ArrayList<String>();
        for (String envName : vd.getEnvironments()) {
            Environment env = this.findEnvironmentByName(envName);
            envIds.add(env.getId());
        }
        for (VPCOrgProvisioningDescriptor o : vd.getOrganizations()) {
            Organization subOrg = this.client.findOrganization(o.getName());
            orgIds.add(subOrg.getId());
        }
        vpc.setAssociatedEnvironments(envIds);
        vpc.setSharedWith(orgIds);
        vpc.setFirewallRules(vd.getFirewallRules());
        vpc.setInternalDns(new VPCInternalDns(vd.getDnsServers(), vd.getDnsDomains()));
        String json = this.client.getHttpHelper().httpPost("/cloudhub/api/organizations/" + this.id + "/vpcs", vpc);
        vpc = this.client.getJsonHelper().readJson(new VPC(), json);
        for (VPCOrgProvisioningDescriptor o : vd.getOrganizations()) {
            Organization subOrg = this.client.findOrganization(o.getName());
            ArrayList<String> eId = new ArrayList<String>();
            for (String e : o.getEnvironments()) {
                Environment env = subOrg.findEnvironmentByName(e);
                eId.add(env.getId());
                Map<String, Object> req = this.jsonHelper.buildJsonMap().set("id", vpc.getId()).set("isDefault", vpc.isDefaultVpc()).set("associatedEnvironments", eId).toMap();
                this.client.httpHelper.httpPut("/cloudhub/api/organizations/" + subOrg.getId() + "/vpcs/" + vpc.getId(), req, env);
            }
        }
        return this.client.getJsonHelper().readJson(new VPC(), this.client.httpHelper.httpGet("/cloudhub/api/organizations/" + this.id + "/vpcs/" + vpc.getId()));
    }

    public void provisionVPC(File file, boolean deleteExisting) throws NotFoundException, HttpException, IOException {
        VPCProvisioningDescriptor vpcProvisioningDescriptor = (VPCProvisioningDescriptor)this.jsonHelper.getJsonMapper().readValue(file, VPCProvisioningDescriptor.class);
        this.provisionVPC(vpcProvisioningDescriptor, deleteExisting);
    }

    public List<VPC> findVPCs() throws HttpException {
        String json = this.httpHelper.httpGet("/cloudhub/api/organizations/" + this.id + "/vpcs/");
        return this.jsonHelper.readJsonList(VPC.class, json, this, "/data");
    }

    public VPC findVPCByName(String name) throws NotFoundException, HttpException {
        for (VPC vpc : this.findVPCs()) {
            if (!vpc.getName().equals(name)) continue;
            return vpc;
        }
        throw new NotFoundException("VPC " + name + " not found");
    }

    public ReleaseManifest findExchangeReleaseManifest(String uri) {
        String name = "Release Manifest: " + this.id;
        String artifactId = "relmanifest-" + this.id;
        try {
            logger.debug("Searching exchange assets " + this.id + " : " + artifactId);
            ExchangeAsset asset = this.findExchangeAsset(this.id, artifactId);
            int oldestVersion = 0;
            for (AssetVersion assetVersion : asset.getVersions()) {
                String v = assetVersion.getVersion();
                Matcher m = MAJORVERSION_REGEX.matcher(v);
                logger.debug("Found version" + v);
                if (!m.find()) {
                    throw new IllegalStateException("Invalid manifest version in exchange: " + v);
                }
                try {
                    int vNb = Integer.parseInt(m.group(1));
                    if (vNb <= oldestVersion) continue;
                    oldestVersion = vNb;
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Invalid manifest version in exchange: " + v);
                }
            }
            String version = oldestVersion + ".0.0";
        }
        catch (HttpException e) {
            throw new BackendAccessException((Throwable)e);
        }
        catch (NotFoundException e) {
            String version = "1.0.0";
        }
        return null;
    }

    public static enum RequestAPIAccessResult {
        GRANTED,
        RESTORED,
        PENDING;

    }
}

