/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint.api;

import com.kloudtek.anypoint.AnypointObject;
import com.kloudtek.anypoint.Environment;
import com.kloudtek.anypoint.HttpException;
import com.kloudtek.anypoint.NotFoundException;
import com.kloudtek.anypoint.Organization;
import com.kloudtek.anypoint.api.APIContract;
import com.kloudtek.anypoint.api.APIContractList;
import com.kloudtek.anypoint.api.APIEndpoint;
import com.kloudtek.anypoint.api.APISpec;
import com.kloudtek.anypoint.api.ClientApplication;
import com.kloudtek.anypoint.api.SLATier;
import com.kloudtek.anypoint.api.SLATierLimits;
import com.kloudtek.anypoint.api.SLATierList;
import com.kloudtek.anypoint.api.policy.Policy;
import com.kloudtek.anypoint.api.provision.PolicyDescriptor;
import com.kloudtek.anypoint.api.provision.SLATierCreateRequest;
import com.kloudtek.anypoint.util.JsonHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class API
extends AnypointObject<Environment> {
    private static final Logger logger = LoggerFactory.getLogger(API.class);
    private int id;
    private String assetVersion;
    private String productVersion;
    private String environmentId;
    private String instanceLabel;
    private int order;
    private String masterOrganizationId;
    private String organizationId;
    private String groupId;
    private String assetId;
    private String autodiscoveryInstanceName;
    private APIEndpoint endpoint;

    public API() {
    }

    public API(Environment environment) {
        super(environment);
    }

    public String getUriPath() {
        if (this.parent != null) {
            return "/apimanager/api/v1/organizations/" + ((Organization)((Environment)this.parent).getParent()).getId() + "/environments/" + ((Environment)this.parent).getId() + "/apis/" + this.id;
        }
        if (this.organizationId != null && this.environmentId != null) {
            return "/apimanager/api/v1/organizations/" + this.organizationId + "/environments/" + this.environmentId + "/apis/" + this.id;
        }
        throw new IllegalStateException("Insufficient data available in api to build uri");
    }

    public void createPolicy(PolicyDescriptor policyDescriptor) throws HttpException {
        Map<String, Object> reqMap = this.jsonHelper.buildJsonMap().set("apiVersionId", this.id).set("configurationData", policyDescriptor.getData()).set("pointcutData", policyDescriptor.getPointcutData()).set("policyTemplateId", policyDescriptor.getPolicyTemplateId()).set("groupId", policyDescriptor.getGroupId()).set("assetId", policyDescriptor.getAssetId()).set("assetVersion", policyDescriptor.getAssetVersion()).toMap();
        this.httpHelper.httpPost("/apimanager/api/v1/organizations/" + ((Organization)((Environment)this.getParent()).getParent()).getId() + "/environments/" + ((Environment)this.getParent()).getId() + "/apis/" + this.id + "/policies", reqMap);
    }

    public APIContract requestAPIAccess(ClientApplication clientApplication) throws HttpException {
        return clientApplication.requestAPIAccess(this);
    }

    public APIContract requestAPIAccess(ClientApplication clientApplication, SLATier tier) throws HttpException {
        return clientApplication.requestAPIAccess(this, tier);
    }

    public APIContract findContract(ClientApplication clientApplication) throws HttpException, NotFoundException {
        for (APIContract contract : this.findContracts()) {
            if (!contract.getApplicationId().equals(clientApplication.getId())) continue;
            return contract;
        }
        throw new NotFoundException();
    }

    public SLATierList findSLATiers() throws HttpException {
        return new SLATierList(this);
    }

    public SLATier findSLATier(@NotNull String name) throws HttpException, NotFoundException {
        for (SLATier slaTier : this.findSLATiers()) {
            if (!slaTier.getName().equals(name)) continue;
            return slaTier;
        }
        throw new NotFoundException();
    }

    public SLATier createSLATier(String name, String description, boolean autoApprove, List<SLATierLimits> limits) throws HttpException {
        String json = this.client.getHttpHelper().httpPost("https://anypoint.mulesoft.com/apimanager/api/v1/organizations/" + ((Organization)((Environment)this.parent).getParent()).getId() + "/environments/" + ((Environment)this.parent).getId() + "/apis/" + this.id + "/tiers", new SLATierCreateRequest(this, name, description, autoApprove, limits));
        return this.jsonHelper.readJson(new SLATier(this), json);
    }

    public static API create(@NotNull Environment environment, @NotNull APISpec apiSpec, boolean mule4, @Nullable String endpointUrl, @Nullable String label) throws HttpException {
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("instanceLabel", label);
        HashMap<String, String> specMap = new HashMap<String, String>();
        specMap.put("assetId", apiSpec.getAssetId());
        specMap.put("version", apiSpec.getVersion());
        specMap.put("groupId", apiSpec.getGroupId());
        req.put("spec", specMap);
        HashMap<String, Object> endpMap = new HashMap<String, Object>();
        endpMap.put("type", "rest-api");
        endpMap.put("uri", endpointUrl);
        endpMap.put("proxyUri", null);
        endpMap.put("isCloudHub", null);
        endpMap.put("deploymentType", "CH");
        endpMap.put("referencesUserDomain", null);
        endpMap.put("responseTimeout", null);
        endpMap.put("muleVersion4OrAbove", mule4);
        req.put("endpoint", endpMap);
        String json = environment.getClient().getHttpHelper().httpPost("/apimanager/api/v1/organizations/" + ((Organization)environment.getParent()).getId() + "/environments/" + environment.getId() + "/apis", req);
        return environment.getClient().getJsonHelper().readJson(new API(environment), json);
    }

    public List<Policy> findPolicies() throws HttpException {
        String json = ((Environment)this.parent).getClient().getHttpHelper().httpGet("/apimanager/api/v1/organizations/" + ((Organization)((Environment)this.getParent()).getParent()).getId() + "/environments/" + ((Environment)this.getParent()).getId() + "/apis/" + this.id + "/policies?fullInfo=false");
        JsonHelper jsonHelper = ((Environment)this.parent).getClient().getJsonHelper();
        return jsonHelper.readJsonList(Policy.class, json, this);
    }

    public Policy findPolicyByAsset(String groupId, String assetId, String assetVersion) throws HttpException, NotFoundException {
        for (Policy policy : this.findPolicies()) {
            if (!policy.getGroupId().equalsIgnoreCase(groupId) || !policy.getAssetId().equalsIgnoreCase(assetId) || !policy.getAssetVersion().equalsIgnoreCase(assetVersion)) continue;
            return policy;
        }
        throw new NotFoundException("Policy not found");
    }

    public APIContractList findContracts() throws HttpException {
        return new APIContractList(this);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getAssetVersion() {
        return this.assetVersion;
    }

    public void setAssetVersion(String assetVersion) {
        this.assetVersion = assetVersion;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public String getInstanceLabel() {
        return this.instanceLabel;
    }

    public void setInstanceLabel(String instanceLabel) {
        this.instanceLabel = instanceLabel;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getMasterOrganizationId() {
        return this.masterOrganizationId;
    }

    public void setMasterOrganizationId(String masterOrganizationId) {
        this.masterOrganizationId = masterOrganizationId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public String getAutodiscoveryInstanceName() {
        return this.autodiscoveryInstanceName;
    }

    public void setAutodiscoveryInstanceName(String autodiscoveryInstanceName) {
        this.autodiscoveryInstanceName = autodiscoveryInstanceName;
    }

    public APIEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(APIEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public String toString() {
        return "API{id=" + this.id + ", assetVersion='" + this.assetVersion + '\'' + ", productVersion='" + this.productVersion + '\'' + ", environmentId='" + this.environmentId + '\'' + ", instanceLabel='" + this.instanceLabel + '\'' + ", order=" + this.order + ", masterOrganizationId='" + this.masterOrganizationId + '\'' + ", organizationId='" + this.organizationId + '\'' + ", groupId='" + this.groupId + '\'' + ", assetId='" + this.assetId + '\'' + ", autodiscoveryInstanceName='" + this.autodiscoveryInstanceName + '\'' + ", endpoint=" + this.endpoint + "} " + super.toString();
    }
}

