/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.kloudtek.anypoint.AnypointObject;
import com.kloudtek.anypoint.Environment;
import com.kloudtek.anypoint.HttpException;
import com.kloudtek.anypoint.Organization;
import com.kloudtek.anypoint.api.API;
import com.kloudtek.anypoint.api.SLATier;
import java.util.HashMap;

public class APIContract
extends AnypointObject<API> {
    @JsonProperty(value="requestedTierId")
    private String requestedTierId;
    @JsonProperty(value="rejectedDate")
    private String rejectedDate;
    @JsonProperty(value="masterOrganizationId")
    private String masterOrganizationId;
    @JsonProperty(value="organizationId")
    private String organizationId;
    @JsonProperty(value="approvedDate")
    private String approvedDate;
    @JsonProperty(value="tierId")
    private String tierId;
    @JsonProperty(value="terms")
    private String terms;
    @JsonProperty(value="revokedDate")
    private String revokedDate;
    @JsonProperty(value="partyName")
    private String partyName;
    @JsonProperty(value="id")
    private Integer id;
    @JsonProperty(value="applicationId")
    private Integer applicationId;
    @JsonProperty(value="partyId")
    private String partyId;
    @JsonProperty(value="requestedTier")
    private SLATier requestedTier;
    @JsonProperty(value="apiId")
    private Integer apiId;
    @JsonProperty(value="status")
    private String status;

    public APIContract(API api) {
        super(api);
    }

    public APIContract() {
    }

    @JsonIgnore
    public boolean isApproved() {
        return this.status != null && this.status.equalsIgnoreCase("approved");
    }

    @JsonIgnore
    public boolean isRevoked() {
        return this.status != null && this.status.equalsIgnoreCase("revoked");
    }

    @JsonIgnore
    public boolean isPending() {
        return this.status != null && this.status.equalsIgnoreCase("pending");
    }

    private String getOpsURLPath() {
        return "/apimanager/xapi/v1/organizations/" + ((Organization)((Environment)((API)this.parent).getParent()).getParent()).getId() + "/environments/" + ((Environment)((API)this.parent).getParent()).getId() + "/apis/" + ((API)this.parent).getId() + "/contracts/" + this.id;
    }

    public String getURLPath() {
        return "/apimanager/api/v1/organizations/" + ((Organization)((Environment)((API)this.parent).getParent()).getParent()).getId() + "/environments/" + ((Environment)((API)this.parent).getParent()).getId() + "/apis/" + ((API)this.parent).getId() + "/contracts/" + this.id;
    }

    public APIContract restoreAccess() throws HttpException {
        String json = this.httpHelper.httpPost(this.getOpsURLPath() + "/restore", new HashMap());
        return this.jsonHelper.readJson(new APIContract((API)this.parent), json);
    }

    public APIContract approveAccess() throws HttpException {
        String json = this.httpHelper.httpPost(this.getOpsURLPath() + "/approve", new HashMap());
        return this.jsonHelper.readJson(new APIContract((API)this.parent), json);
    }

    public APIContract revokeAccess() throws HttpException {
        String json = this.httpHelper.httpPost(this.getOpsURLPath() + "/revoke", new HashMap());
        return this.jsonHelper.readJson(new APIContract((API)this.parent), json);
    }

    public void delete() throws HttpException {
        this.httpHelper.httpDelete(this.getURLPath());
    }

    public String getRequestedTierId() {
        return this.requestedTierId;
    }

    public void setRequestedTierId(String requestedTierId) {
        this.requestedTierId = requestedTierId;
    }

    public String getRejectedDate() {
        return this.rejectedDate;
    }

    public void setRejectedDate(String rejectedDate) {
        this.rejectedDate = rejectedDate;
    }

    public String getMasterOrganizationId() {
        return this.masterOrganizationId;
    }

    public void setMasterOrganizationId(String masterOrganizationId) {
        this.masterOrganizationId = masterOrganizationId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getApprovedDate() {
        return this.approvedDate;
    }

    public void setApprovedDate(String approvedDate) {
        this.approvedDate = approvedDate;
    }

    public String getTierId() {
        return this.tierId;
    }

    public void setTierId(String tierId) {
        this.tierId = tierId;
    }

    public String getTerms() {
        return this.terms;
    }

    public void setTerms(String terms) {
        this.terms = terms;
    }

    public String getRevokedDate() {
        return this.revokedDate;
    }

    public void setRevokedDate(String revokedDate) {
        this.revokedDate = revokedDate;
    }

    public String getPartyName() {
        return this.partyName;
    }

    public void setPartyName(String partyName) {
        this.partyName = partyName;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(Integer applicationId) {
        this.applicationId = applicationId;
    }

    public String getPartyId() {
        return this.partyId;
    }

    public void setPartyId(String partyId) {
        this.partyId = partyId;
    }

    public SLATier getRequestedTier() {
        return this.requestedTier;
    }

    public void setRequestedTier(SLATier requestedTier) {
        this.requestedTier = requestedTier;
    }

    public Integer getApiId() {
        return this.apiId;
    }

    public void setApiId(Integer apiId) {
        this.apiId = apiId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}

