/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.kloudtek.anypoint.HttpException;
import com.kloudtek.anypoint.Organization;
import com.kloudtek.anypoint.api.APISpec;
import com.kloudtek.anypoint.util.PaginatedList;
import com.kloudtek.util.URLBuilder;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class APISpecList
extends PaginatedList<APISpec, Organization> {
    private final String filter;

    public APISpecList(Organization organization, String filter) throws HttpException {
        super(organization);
        this.filter = filter;
        this.limit = 50;
        this.download();
    }

    @Override
    @NotNull
    protected URLBuilder buildUrl() {
        URLBuilder url = new URLBuilder("/apimanager/xapi/v1/organizations/" + ((Organization)this.parent).getId() + "/apiSpecs").param("ascending", "true");
        if (this.filter != null) {
            url.param("searchTerm", this.filter);
        }
        return url;
    }

    @JsonProperty
    public List<APISpec> getApiDefinitions() {
        return this.list;
    }

    public void setApiDefinitions(List<APISpec> list) {
        this.list = list;
    }
}

