/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint.api.provision;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class APIProvisioningConfig {
    private static final String CONFIG_FILE = "config.properties";
    @JsonProperty(defaultValue="anypoint.json")
    private String descriptorLocation = "anypoint.json";
    @JsonProperty
    private Map<String, String> variables = new HashMap<String, String>();
    @JsonProperty
    private List<String> accessedBy = new ArrayList<String>();
    @JsonProperty
    private String apiLabel;
    @JsonProperty(defaultValue="true")
    private boolean autoApproveAPIAccessRequest = true;
    @JsonProperty(defaultValue="true")
    private boolean injectApiId = true;
    @JsonProperty(defaultValue="config.properties")
    private String configFile = "config.properties";
    @JsonProperty(defaultValue="anypoint.api.id")
    private String injectApiIdKey = "anypoint.api.id";
    @JsonProperty(defaultValue="true")
    private boolean injectClientIdSecret = true;
    @JsonProperty(defaultValue="anypoint.api.client")
    private String injectClientIdSecretKey = "anypoint.api.client";
    @JsonProperty(defaultValue="false")
    private boolean customLog4j;

    public APIProvisioningConfig() {
    }

    public APIProvisioningConfig(Map<String, String> variables, List<String> accessedBy) {
        this.variables.putAll(variables);
        if (accessedBy != null) {
            this.accessedBy.addAll(accessedBy);
        }
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public void setVariable(String key, String value) {
        if (this.variables == null) {
            this.variables = new HashMap<String, String>();
        }
        this.variables.put(key, value);
    }

    public List<String> getAccessedBy() {
        return this.accessedBy;
    }

    public void addAccessedBy(String clientAppName) {
        this.accessedBy.add(clientAppName);
    }

    public void setAccessedBy(List<String> accessedBy) {
        this.accessedBy = accessedBy;
    }

    public String getDescriptorLocation() {
        return this.descriptorLocation;
    }

    public void setDescriptorLocation(String descriptorLocation) {
        this.descriptorLocation = descriptorLocation;
    }

    public void addVariable(String key, String value) {
        this.variables.put(key, value);
    }

    public String getApiLabel() {
        return this.apiLabel;
    }

    public void setApiLabel(String apiLabel) {
        this.apiLabel = apiLabel;
    }

    public boolean isAutoApproveAPIAccessRequest() {
        return this.autoApproveAPIAccessRequest;
    }

    public void setAutoApproveAPIAccessRequest(boolean autoApproveAPIAccessRequest) {
        this.autoApproveAPIAccessRequest = autoApproveAPIAccessRequest;
    }

    public boolean isInjectApiId() {
        return this.injectApiId;
    }

    public void setInjectApiId(boolean injectApiId) {
        this.injectApiId = injectApiId;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getInjectApiIdKey() {
        return this.injectApiIdKey;
    }

    public void setInjectApiIdKey(String injectApiIdKey) {
        this.injectApiIdKey = injectApiIdKey;
    }

    public boolean isInjectClientIdSecret() {
        return this.injectClientIdSecret;
    }

    public void setInjectClientIdSecret(boolean injectClientIdSecret) {
        this.injectClientIdSecret = injectClientIdSecret;
    }

    public String getInjectClientIdSecretKey() {
        return this.injectClientIdSecretKey;
    }

    public void setInjectClientIdSecretKey(String injectClientIdSecretKey) {
        this.injectClientIdSecretKey = injectClientIdSecretKey;
    }

    public boolean isCustomLog4j() {
        return this.customLog4j;
    }

    public void setCustomLog4j(boolean customLog4j) {
        this.customLog4j = customLog4j;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof APIProvisioningConfig)) {
            return false;
        }
        APIProvisioningConfig that = (APIProvisioningConfig)o;
        return this.autoApproveAPIAccessRequest == that.autoApproveAPIAccessRequest && this.injectApiId == that.injectApiId && this.injectClientIdSecret == that.injectClientIdSecret && Objects.equals(this.descriptorLocation, that.descriptorLocation) && Objects.equals(this.variables, that.variables) && Objects.equals(this.accessedBy, that.accessedBy) && Objects.equals(this.apiLabel, that.apiLabel) && Objects.equals(this.configFile, that.configFile) && Objects.equals(this.injectApiIdKey, that.injectApiIdKey) && Objects.equals(this.customLog4j, that.customLog4j) && Objects.equals(this.injectClientIdSecretKey, that.injectClientIdSecretKey);
    }

    public int hashCode() {
        return Objects.hash(this.descriptorLocation, this.variables, this.accessedBy, this.apiLabel, this.autoApproveAPIAccessRequest, this.injectApiId, this.configFile, this.injectApiIdKey, this.injectClientIdSecret, this.injectClientIdSecretKey, this.customLog4j);
    }

    public String toString() {
        return new StringJoiner(", ", APIProvisioningConfig.class.getSimpleName() + "[", "]").add("descriptorLocation='" + this.descriptorLocation + "'").add("variables=" + this.variables).add("accessedBy=" + this.accessedBy).add("apiLabel='" + this.apiLabel + "'").add("autoApproveAPIAccessRequest=" + this.autoApproveAPIAccessRequest).add("injectApiId=" + this.injectApiId).add("configFile='" + this.configFile + "'").add("injectApiIdKey='" + this.injectApiIdKey + "'").add("injectClientIdSecret=" + this.injectClientIdSecret).add("injectClientIdSecretKey='" + this.injectClientIdSecretKey + "'").add("customLog4j='" + this.customLog4j + "'").toString();
    }
}

