/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint.api.provision;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.kloudtek.anypoint.Environment;
import com.kloudtek.anypoint.NotFoundException;
import com.kloudtek.anypoint.Organization;
import com.kloudtek.anypoint.api.API;
import com.kloudtek.anypoint.api.APIContract;
import com.kloudtek.anypoint.api.APISpec;
import com.kloudtek.anypoint.api.ClientApplication;
import com.kloudtek.anypoint.api.SLATier;
import com.kloudtek.anypoint.api.SLATierLimits;
import com.kloudtek.anypoint.api.policy.Policy;
import com.kloudtek.anypoint.api.provision.APIAccessDescriptor;
import com.kloudtek.anypoint.api.provision.APIProvisioningConfig;
import com.kloudtek.anypoint.api.provision.APIProvisioningResult;
import com.kloudtek.anypoint.api.provision.ClientApplicationDescriptor;
import com.kloudtek.anypoint.api.provision.PolicyDescriptor;
import com.kloudtek.anypoint.api.provision.ProvisioningException;
import com.kloudtek.anypoint.api.provision.SLATierDescriptor;
import com.kloudtek.util.InvalidStateException;
import com.kloudtek.util.StringUtils;
import com.kloudtek.util.validation.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIProvisioningDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(APIProvisioningDescriptor.class);
    private List<APIAccessDescriptor> access;
    private String name;
    private String version;
    private String endpoint;
    private List<PolicyDescriptor> policies;
    private List<String> accessedBy;
    private Boolean mule4;
    private boolean createClientApplication = true;
    private ClientApplicationDescriptor clientApp;
    private List<SLATierDescriptor> slaTiers;

    public APIProvisioningDescriptor() {
    }

    public APIProvisioningDescriptor(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public APIProvisioningResult provision(Environment environment, APIProvisioningConfig config) throws ProvisioningException {
        try {
            API api;
            APIProvisioningResult result = new APIProvisioningResult();
            config.setVariable("environment.id", environment.getId());
            config.setVariable("environment.name", environment.getName());
            config.setVariable("environment.lname", environment.getName().toLowerCase());
            config.setVariable("organization.name", environment.getOrganization().getName());
            config.setVariable("organization.lname", environment.getOrganization().getName().toLowerCase());
            ValidationUtils.notEmpty(IllegalStateException.class, (String)"API Descriptor missing value: name", (String[])new String[]{this.name});
            ValidationUtils.notEmpty(IllegalStateException.class, (String)"API Descriptor missing value: version", (String[])new String[]{this.version});
            logger.debug("Provisioning " + this + " within org " + ((Organization)environment.getParent()).getName() + " env " + environment.getName());
            logger.debug("Provisioning " + this.getName());
            String apiName = this.applyVars(this.getName(), config);
            config.setVariable("api.name", apiName);
            config.setVariable("api.lname", apiName.toLowerCase());
            String apiVersionName = this.applyVars(this.getVersion(), config);
            if (this.clientApp == null) {
                this.clientApp = new ClientApplicationDescriptor();
            }
            String clientAppName = this.applyVars(this.clientApp.getName(), config);
            String endpoint = this.applyVars(this.getEndpoint(), config);
            try {
                api = environment.findAPIByExchangeAssetNameAndVersion(apiName, apiVersionName);
                logger.debug("API " + apiName + " " + apiVersionName + " exists: " + api);
            }
            catch (NotFoundException e) {
                logger.debug("API " + apiName + " " + apiVersionName + " not found, creating");
                APISpec apiSpec = ((Organization)environment.getParent()).findAPISpecsByNameAndVersion(this.getName(), this.getVersion());
                Boolean mule4 = this.getMule4();
                if (mule4 == null) {
                    mule4 = true;
                }
                api = environment.createAPI(apiSpec, mule4, this.getEndpoint(), config.getApiLabel());
            }
            result.setApi(api);
            ArrayList<PolicyDescriptor> polList = new ArrayList<PolicyDescriptor>();
            if (this.policies != null) {
                polList.addAll(this.policies);
            }
            for (PolicyDescriptor policyDescriptor : polList) {
                try {
                    Policy policy = api.findPolicyByAsset(policyDescriptor.getGroupId(), policyDescriptor.getAssetId(), policyDescriptor.getAssetVersion());
                    if (Objects.deepEquals(policy.getConfigurationData(), policyDescriptor.getData()) && Objects.deepEquals(policy.getPointcutData(), policyDescriptor.getPointcutData())) {
                        logger.debug("Policy data is same as descriptor");
                        continue;
                    }
                    logger.debug("Policy data changed, updating");
                    policy.update(policyDescriptor);
                }
                catch (NotFoundException e) {
                    logger.debug("Policy not found, creating: " + policyDescriptor);
                    api.createPolicy(policyDescriptor);
                }
            }
            ClientApplication clientApplication = null;
            try {
                clientApplication = environment.getOrganization().findClientApplicationByName(clientAppName);
                logger.debug("Client application found: " + clientAppName);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if (clientApplication == null && this.isCreateClientApplication()) {
                logger.debug("Client application not found, creating: " + clientAppName);
                clientApplication = environment.getOrganization().createClientApplication(clientAppName, this.clientApp.getUrl(), this.clientApp.getDescription());
            }
            result.setClientApplication(clientApplication);
            if (this.slaTiers != null) {
                for (SLATierDescriptor slaTierDescriptor : this.slaTiers) {
                    try {
                        SLATier sLATier = api.findSLATier(slaTierDescriptor.getName());
                    }
                    catch (NotFoundException e) {
                        api.createSLATier(slaTierDescriptor.getName(), slaTierDescriptor.getDescription(), slaTierDescriptor.isAutoApprove(), slaTierDescriptor.getLimits());
                    }
                }
            }
            if (this.access != null) {
                if (clientApplication == null) {
                    throw new InvalidStateException("Client Application doesn't exist and automatic client application creation (createClientApplication) set to false");
                }
                for (APIAccessDescriptor accessDescriptor : this.access) {
                    APIContract contract;
                    API accessedAPI = environment.findAPIByExchangeAsset(accessDescriptor.getGroupId(), accessDescriptor.getAssetId(), accessDescriptor.getAssetVersion(), accessDescriptor.getLabel());
                    try {
                        contract = accessedAPI.findContract(clientApplication);
                    }
                    catch (NotFoundException e) {
                        SLATier slaTier = accessDescriptor.getSlaTier() != null ? accessedAPI.findSLATier(accessDescriptor.getSlaTier()) : null;
                        contract = clientApplication.requestAPIAccess(accessedAPI, slaTier);
                    }
                    if (contract.isApproved() || !config.isAutoApproveAPIAccessRequest()) continue;
                    if (contract.isRevoked()) {
                        contract.restoreAccess();
                        continue;
                    }
                    contract.approveAccess();
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ProvisioningException(e);
        }
    }

    private String applyVars(String str, APIProvisioningConfig config) {
        return StringUtils.substituteVariables((String)str, config.getVariables());
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Boolean getMule4() {
        return this.mule4;
    }

    public void setMule4(Boolean mule4) {
        this.mule4 = mule4;
    }

    @JsonProperty
    public synchronized List<APIAccessDescriptor> getAccess() {
        return this.access != null ? this.access : Collections.emptyList();
    }

    public synchronized void setAccess(List<APIAccessDescriptor> access) {
        this.access = access;
    }

    public synchronized APIProvisioningDescriptor addAccess(APIAccessDescriptor accessDescriptor) {
        if (this.access == null) {
            this.access = new ArrayList<APIAccessDescriptor>();
        }
        this.access.add(accessDescriptor);
        return this;
    }

    public synchronized APIProvisioningDescriptor addAccess(API api) {
        this.addAccess(new APIAccessDescriptor(api, null));
        return this;
    }

    public synchronized APIProvisioningDescriptor addAccess(API api, String slaTier) {
        this.addAccess(new APIAccessDescriptor(api, slaTier));
        return this;
    }

    @JsonProperty
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @JsonProperty
    public ClientApplicationDescriptor getClientApp() {
        return this.clientApp;
    }

    public void setClientApp(ClientApplicationDescriptor clientApp) {
        this.clientApp = clientApp;
    }

    public void addPolicy(PolicyDescriptor policy) {
        this.getPolicies().add(policy);
    }

    @JsonProperty
    public synchronized List<PolicyDescriptor> getPolicies() {
        if (this.policies == null) {
            this.policies = new ArrayList<PolicyDescriptor>();
        }
        return this.policies;
    }

    public void setPolicies(List<PolicyDescriptor> policies) {
        this.policies = policies;
    }

    @JsonProperty
    public List<String> getAccessedBy() {
        return this.accessedBy;
    }

    public void setAccessedBy(List<String> accessedBy) {
        this.accessedBy = accessedBy;
    }

    @JsonProperty(defaultValue="true")
    public boolean isCreateClientApplication() {
        return this.createClientApplication;
    }

    public void setCreateClientApplication(boolean createClientApplication) {
        this.createClientApplication = createClientApplication;
    }

    public synchronized List<SLATierDescriptor> getSlaTiers() {
        return this.slaTiers;
    }

    public synchronized void setSlaTiers(List<SLATierDescriptor> slaTiers) {
        this.slaTiers = slaTiers;
    }

    public synchronized APIProvisioningDescriptor addSlaTier(String name, String description, boolean autoApprove, SLATierLimits ... limits) {
        return this.addSlaTier(new SLATierDescriptor(name, description, autoApprove, limits));
    }

    public synchronized APIProvisioningDescriptor addSlaTier(String name, boolean autoApprove, SLATierLimits ... limits) {
        return this.addSlaTier(name, null, autoApprove, limits);
    }

    public synchronized APIProvisioningDescriptor addSlaTier(SLATierDescriptor slaTierDescriptor) {
        if (this.slaTiers == null) {
            this.slaTiers = new ArrayList<SLATierDescriptor>();
        }
        this.slaTiers.add(slaTierDescriptor);
        return this;
    }
}

