/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint.api.provision;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.kloudtek.anypoint.api.provision.APIAccessDescriptor;
import com.kloudtek.anypoint.api.provision.InvalidAnypointDescriptorException;
import com.kloudtek.anypoint.api.provision.PolicyDescriptor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class ProvisionedAPI
extends APIAccessDescriptor {
    public static final String DEF_CREDKEY_NAME = "mule.client.id";
    public static final String MULE_CREDVAL_NAME = "mule.client.secret";
    private List<APIAccessDescriptor> access;
    private String name;
    private String version;
    private String endpoint;
    private List<PolicyDescriptor> policies;
    private String clientAppUrl;
    private String clientAppDescription;
    private String clientAppName;
    private List<String> accessedBy;
    private Boolean mule4;

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonProperty
    public String getAssetVersion() {
        return this.version;
    }

    @Override
    public void setAssetVersion(String assetVersion) {
        this.version = assetVersion;
    }

    public Boolean getMule4() {
        return this.mule4;
    }

    public void setMule4(Boolean mule4) {
        this.mule4 = mule4;
    }

    @JsonProperty
    public List<APIAccessDescriptor> getAccess() {
        return this.access != null ? this.access : Collections.emptyList();
    }

    public void setAccess(List<APIAccessDescriptor> access) {
        this.access = access;
    }

    @JsonProperty
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @JsonProperty
    public String getClientAppName() {
        return this.clientAppName;
    }

    public void setClientAppName(String clientAppName) {
        this.clientAppName = clientAppName;
    }

    @JsonProperty
    public List<PolicyDescriptor> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<PolicyDescriptor> policies) {
        this.policies = policies;
    }

    @JsonProperty
    public String getClientAppUrl() {
        return this.clientAppUrl;
    }

    public void setClientAppUrl(String clientAppUrl) {
        this.clientAppUrl = clientAppUrl;
    }

    @JsonProperty
    public String getClientAppDescription() {
        return this.clientAppDescription;
    }

    public void setClientAppDescription(String clientAppDescription) {
        this.clientAppDescription = clientAppDescription;
    }

    @JsonProperty
    public List<String> getAccessedBy() {
        return this.accessedBy;
    }

    public void setAccessedBy(List<String> accessedBy) {
        this.accessedBy = accessedBy;
    }

    public void validate() throws InvalidAnypointDescriptorException {
        HashSet<String> types = new HashSet<String>();
        if (this.policies != null) {
            for (PolicyDescriptor policy : this.policies) {
                if (types.contains(policy.getType())) {
                    throw new InvalidAnypointDescriptorException("There is more than one policy of type " + policy.getType());
                }
                types.add(policy.getType());
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProvisionedAPI)) {
            return false;
        }
        ProvisionedAPI that = (ProvisionedAPI)o;
        return Objects.equals(this.access, that.access) && Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.policies, that.policies) && Objects.equals(this.clientAppUrl, that.clientAppUrl) && Objects.equals(this.clientAppDescription, that.clientAppDescription) && Objects.equals(this.clientAppName, that.clientAppName) && Objects.equals(this.accessedBy, that.accessedBy);
    }

    public int hashCode() {
        return Objects.hash(this.access, this.endpoint, this.policies, this.clientAppUrl, this.clientAppDescription, this.clientAppName, this.accessedBy);
    }

    public String toString() {
        return "ProvisionedAPI{access=" + this.access + ", endpoint='" + this.endpoint + '\'' + ", policies=" + this.policies + ", clientAppUrl='" + this.clientAppUrl + '\'' + ", clientAppDescription='" + this.clientAppDescription + '\'' + ", clientAppName='" + this.clientAppName + '\'' + ", accessedBy=" + this.accessedBy + "} " + super.toString();
    }
}

