/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint.deploy;

import com.kloudtek.anypoint.AnypointClient;
import com.kloudtek.anypoint.Environment;
import com.kloudtek.anypoint.HttpException;
import com.kloudtek.anypoint.NotFoundException;
import com.kloudtek.anypoint.api.provision.APIProvisioningConfig;
import com.kloudtek.anypoint.api.provision.APIProvisioningResult;
import com.kloudtek.anypoint.cloudhub.CHMuleVersion;
import com.kloudtek.anypoint.cloudhub.CHWorkerType;
import com.kloudtek.anypoint.deploy.ApplicationSource;
import com.kloudtek.anypoint.deploy.DeploymentRequest;
import com.kloudtek.anypoint.runtime.CHApplication;
import com.kloudtek.anypoint.runtime.CHDeploymentResult;
import com.kloudtek.anypoint.runtime.DeploymentResult;
import com.kloudtek.anypoint.util.HttpHelper;
import com.kloudtek.anypoint.util.JsonHelper;
import com.kloudtek.anypoint.util.StreamSource;
import com.kloudtek.unpack.transformer.Transformer;
import com.kloudtek.util.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHDeploymentRequest
extends DeploymentRequest {
    private static final Logger logger = LoggerFactory.getLogger(CHDeploymentRequest.class);
    private int workerCount;
    private CHMuleVersion muleVersion;
    private String region;
    private CHWorkerType workerType;

    public CHDeploymentRequest() {
    }

    @Override
    protected void preDeploy(APIProvisioningResult result, APIProvisioningConfig config, List<Transformer> transformers) {
    }

    public CHDeploymentRequest(String muleVersionName, String regionName, String workerTypeName, int workerCount, Environment environment, String appName, ApplicationSource file, String filename, Map<String, String> properties, APIProvisioningConfig apiProvisioningConfig) throws HttpException, NotFoundException {
        super(environment, appName, file, filename, properties, apiProvisioningConfig);
        this.workerCount = workerCount;
        this.muleVersion = StringUtils.isBlank((String)muleVersionName) ? environment.findDefaultCHMuleVersion() : environment.findCHMuleVersion(muleVersionName);
        this.region = StringUtils.isBlank((String)regionName) ? environment.findDefaultCHRegion().getId() : regionName;
        this.workerType = StringUtils.isBlank((String)workerTypeName) ? environment.findSmallestWorkerType() : environment.findWorkerTypeByName(workerTypeName);
    }

    @Override
    protected DeploymentResult doDeploy() throws IOException, HttpException {
        String deploymentJson;
        long start = System.currentTimeMillis();
        AnypointClient client = this.environment.getClient();
        HttpHelper httpHelper = client.getHttpHelper();
        JsonHelper.MapBuilder appInfoBuilder = client.getJsonHelper().buildJsonMap();
        CHApplication existingApp = this.getExistingApp(this.appName);
        appInfoBuilder.set("properties", this.properties).set("domain", this.appName).set("monitoringEnabled", true).set("monitoringAutoRestart", true).set("loggingNgEnabled", true).set("loggingCustomLog4JEnabled", this.apiProvisioningConfig.isCustomLog4j());
        appInfoBuilder.addMap("muleVersion").set("version", this.muleVersion.getVersion()).set("updateId", this.muleVersion.getLatestUpdate().getId());
        appInfoBuilder.addMap("workers").set("amount", this.workerCount).addMap("type").set("name", this.workerType.getName()).set("weight", this.workerType.getWeight()).set("cpu", this.workerType.getCpu()).set("memory", this.workerType.getMemory());
        appInfoBuilder.set("fileName", this.filename);
        Map<String, Object> appInfo = appInfoBuilder.toMap();
        if (this.source.getLocalFile() != null) {
            HttpHelper.MultiPartRequest req;
            if (existingApp != null) {
                req = httpHelper.createMultiPartPutRequest("/cloudhub/api/v2/applications/" + existingApp.getDomain(), this.environment);
            } else {
                req = httpHelper.createMultiPartPostRequest("/cloudhub/api/v2/applications", this.getEnvironment());
                req = req.addText("autoStart", "true");
            }
            String appInfoJson = new String(this.environment.getClient().getJsonHelper().toJson(appInfo));
            req = req.addText("appInfoJson", appInfoJson);
            req = req.addBinary("file", new StreamSource(){

                @Override
                public String getFileName() {
                    return CHDeploymentRequest.this.filename;
                }

                @Override
                public InputStream createInputStream() throws IOException {
                    return new FileInputStream(CHDeploymentRequest.this.source.getLocalFile());
                }
            });
            deploymentJson = req.execute();
        } else {
            HashMap<String, Object> deployJson = new HashMap<String, Object>();
            deployJson.put("applicationInfo", appInfo);
            deployJson.put("applicationSource", this.source.getSourceJson(client.getJsonHelper()));
            if (existingApp != null) {
                deploymentJson = httpHelper.httpPut("/cloudhub/api/v2/applications/" + existingApp.getDomain(), deployJson, this.environment);
            } else {
                deployJson.put("autoStart", true);
                deploymentJson = httpHelper.httpPost("/cloudhub/api/v2/applications/", deployJson, this.environment);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("File upload took " + TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start) + " seconds");
        }
        return new CHDeploymentResult(client.getJsonHelper().readJson(new CHApplication(), deploymentJson, this.environment));
    }

    private CHApplication getExistingApp(String appName) throws HttpException {
        try {
            logger.debug("Searching for pre-existing application named " + appName);
            CHApplication application = this.environment.findCHApplicationByDomain(appName);
            logger.debug("Found application named {}", (Object)appName);
            return application;
        }
        catch (NotFoundException e) {
            logger.debug("Couldn't find application named {}", (Object)appName);
            return null;
        }
    }
}

