/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint.deploy;

import com.kloudtek.anypoint.AnypointClient;
import com.kloudtek.anypoint.Environment;
import com.kloudtek.anypoint.HttpException;
import com.kloudtek.anypoint.NotFoundException;
import com.kloudtek.anypoint.api.ClientApplication;
import com.kloudtek.anypoint.api.provision.APIProvisioningConfig;
import com.kloudtek.anypoint.api.provision.APIProvisioningDescriptor;
import com.kloudtek.anypoint.api.provision.APIProvisioningResult;
import com.kloudtek.anypoint.api.provision.ProvisioningException;
import com.kloudtek.anypoint.deploy.ApplicationSource;
import com.kloudtek.anypoint.deploy.ExchangeApplicationSource;
import com.kloudtek.anypoint.deploy.FileApplicationSource;
import com.kloudtek.anypoint.runtime.DeploymentResult;
import com.kloudtek.anypoint.util.HttpHelper;
import com.kloudtek.unpack.FileType;
import com.kloudtek.unpack.Unpacker;
import com.kloudtek.unpack.transformer.Transformer;
import com.kloudtek.util.TempFile;
import com.kloudtek.util.UnexpectedException;
import com.kloudtek.util.io.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeploymentRequest {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentRequest.class);
    protected Environment environment;
    protected String appName;
    protected ApplicationSource source;
    protected String filename;
    protected APIProvisioningConfig apiProvisioningConfig;
    protected Map<String, String> properties;

    public DeploymentRequest() {
    }

    public DeploymentRequest(Environment environment, String appName, ApplicationSource source, String filename, Map<String, String> properties, APIProvisioningConfig apiProvisioningConfig) {
        this.environment = environment;
        this.appName = appName;
        this.source = source;
        this.filename = filename;
        this.properties = properties;
        this.apiProvisioningConfig = apiProvisioningConfig;
    }

    public DeploymentResult deploy() throws ProvisioningException, IOException, HttpException {
        DeploymentResult deploymentResult;
        block16: {
            AnypointClient client = this.environment.getClient();
            boolean tmpFile = false;
            try {
                this.environment = this.environment.refresh();
                APIProvisioningResult provisioningResult = null;
                ArrayList<Transformer> transformers = new ArrayList<Transformer>();
                if (this.apiProvisioningConfig != null) {
                    APIProvisioningDescriptor apiProvisioningDescriptor = this.source.getAPIProvisioningDescriptor();
                    if (apiProvisioningDescriptor != null) {
                        ClientApplication clientApp;
                        logger.debug("Found anypoint.json, provisioning");
                        provisioningResult = apiProvisioningDescriptor.provision(this.environment, this.apiProvisioningConfig);
                        if (this.apiProvisioningConfig.isInjectApiId()) {
                            this.initProperties();
                            this.properties.put(this.apiProvisioningConfig.getInjectApiIdKey(), Integer.toString(provisioningResult.getApi().getId()));
                            this.properties.put("anypoint.platform.client_id", this.environment.getClientId());
                            this.properties.put("anypoint.platform.client_secret", this.environment.getClientSecret());
                        }
                        if ((clientApp = provisioningResult.getClientApplication()) != null && this.apiProvisioningConfig.isInjectClientIdSecret()) {
                            this.initProperties();
                            this.properties.put(this.apiProvisioningConfig.getInjectClientIdSecretKey() + ".id", clientApp.getClientId());
                            this.properties.put(this.apiProvisioningConfig.getInjectClientIdSecretKey() + ".secret", clientApp.getClientSecret());
                        }
                    } else {
                        logger.debug("no anypoint.json found, skipping provisioning");
                    }
                }
                this.preDeploy(provisioningResult, this.apiProvisioningConfig, transformers);
                if (!transformers.isEmpty()) {
                    try {
                        if (this.source instanceof FileApplicationSource || this.source.getLocalFile() != null) {
                            File oldFile = this.source.getLocalFile();
                            TempFile newFile = new TempFile("tranformed", this.filename);
                            this.source = new FileApplicationSource(client, (File)newFile);
                            Unpacker unpacker = new Unpacker(oldFile, FileType.ZIP, (File)newFile, FileType.ZIP);
                            unpacker.addTransformers(transformers);
                            unpacker.unpack();
                        } else if (this.source instanceof ExchangeApplicationSource) {
                            throw new ProvisioningException("Transformations on exchange sources not supported at this (so OnPrem provisioned deployments won't work with exchange sources until this feature is added)");
                        }
                    }
                    catch (Exception e) {
                        throw new ProvisioningException("An error occurred while applying application " + this.appName + " transformations: " + e.getMessage(), e);
                    }
                    tmpFile = true;
                }
                deploymentResult = this.doDeploy();
                if (!tmpFile) break block16;
            }
            catch (NotFoundException e) {
                try {
                    throw new UnexpectedException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpFile) {
                        IOUtils.close((Closeable[])new Closeable[]{(TempFile)this.source.getLocalFile()});
                    }
                    throw throwable;
                }
            }
            IOUtils.close((Closeable[])new Closeable[]{(TempFile)this.source.getLocalFile()});
        }
        return deploymentResult;
    }

    private void initProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
    }

    protected abstract void preDeploy(APIProvisioningResult var1, APIProvisioningConfig var2, List<Transformer> var3);

    protected abstract DeploymentResult doDeploy() throws IOException, HttpException;

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public ApplicationSource getSource() {
        return this.source;
    }

    public void setSource(ApplicationSource source) {
        this.source = source;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public APIProvisioningConfig getApiProvisioningConfig() {
        return this.apiProvisioningConfig;
    }

    public void setApiProvisioningConfig(APIProvisioningConfig apiProvisioningConfig) {
        this.apiProvisioningConfig = apiProvisioningConfig;
    }

    protected String executeRequest(long start, HttpHelper.MultiPartRequest multiPartRequest) throws HttpException, IOException {
        String json = multiPartRequest.execute();
        if (logger.isDebugEnabled()) {
            logger.debug("File upload took " + TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start) + " seconds");
        }
        return json;
    }
}

