/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint.deploy;

import com.kloudtek.anypoint.AnypointClient;
import com.kloudtek.anypoint.Environment;
import com.kloudtek.anypoint.HttpException;
import com.kloudtek.anypoint.NotFoundException;
import com.kloudtek.anypoint.api.provision.APIProvisioningConfig;
import com.kloudtek.anypoint.api.provision.APIProvisioningResult;
import com.kloudtek.anypoint.deploy.ApplicationSource;
import com.kloudtek.anypoint.deploy.DeploymentRequest;
import com.kloudtek.anypoint.runtime.DeploymentResult;
import com.kloudtek.anypoint.runtime.HApplication;
import com.kloudtek.anypoint.runtime.HDeploymentResult;
import com.kloudtek.anypoint.runtime.Server;
import com.kloudtek.anypoint.util.HttpHelper;
import com.kloudtek.unpack.transformer.SetPropertyTransformer;
import com.kloudtek.unpack.transformer.Transformer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDeploymentRequest
extends DeploymentRequest {
    private static final Logger logger = LoggerFactory.getLogger(HDeploymentRequest.class);
    private Server target;

    public HDeploymentRequest(Server target, String appName, ApplicationSource file, String filename, Map<String, String> properties, APIProvisioningConfig apiProvisioningConfig) {
        super((Environment)target.getParent(), appName, file, filename, properties, apiProvisioningConfig);
        this.target = target;
    }

    @Override
    protected void preDeploy(APIProvisioningResult result, APIProvisioningConfig config, List<Transformer> transformers) {
        if (this.properties != null && !this.properties.isEmpty()) {
            transformers.add((Transformer)new SetPropertyTransformer(this.apiProvisioningConfig.getConfigFile(), new HashMap(this.properties)));
        }
    }

    @Override
    protected DeploymentResult doDeploy() throws IOException, HttpException {
        HttpHelper.MultiPartRequest request;
        long start = System.currentTimeMillis();
        AnypointClient client = this.environment.getClient();
        HttpHelper httpHelper = client.getHttpHelper();
        try {
            logger.debug("Searching for pre-existing application named " + this.appName);
            HApplication application = this.target.findApplication(this.appName);
            logger.debug("Found application named {} : {}", (Object)this.appName, (Object)application.getId());
            request = httpHelper.createMultiPartPatchRequest("/hybrid/api/v1/applications/" + application.getId(), (Environment)this.target.getParent());
        }
        catch (NotFoundException e) {
            logger.debug("Couldn't find application named {}", (Object)this.appName);
            request = httpHelper.createMultiPartPostRequest("/hybrid/api/v1/applications", this.environment);
        }
        HttpHelper.MultiPartRequest multiPartRequest = request.addText("artifactName", this.appName).addText("targetId", this.target.getId());
        String json = this.executeRequest(start, multiPartRequest);
        HApplication application = this.target.getClient().getJsonHelper().readJson(new HApplication(this.target), json, "/data");
        return new HDeploymentResult(application);
    }
}

