/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint.runtime;

import com.kloudtek.anypoint.HttpException;
import com.kloudtek.anypoint.NotFoundException;
import com.kloudtek.anypoint.runtime.ApplicationDeploymentFailedException;
import com.kloudtek.anypoint.runtime.CHApplication;
import com.kloudtek.anypoint.runtime.DeploymentResult;
import com.kloudtek.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHDeploymentResult
extends DeploymentResult {
    private static final Logger logger = LoggerFactory.getLogger(CHDeploymentResult.class);
    static final String DEPLOYMENT_FAILED = "DEPLOYMENT_FAILED";
    static final String DEPLOY_FAILED = "DEPLOY_FAILED";
    static final String STARTED = "STARTED";
    public static final String UNDEPLOYED = "UNDEPLOYED";
    private CHApplication application;

    public CHDeploymentResult(CHApplication application) {
        this.application = application;
    }

    @Override
    public void waitDeployed(long timeout, long retryDelay) throws HttpException, ApplicationDeploymentFailedException {
        ThreadUtils.sleep((long)2000L);
        long expires = System.currentTimeMillis() + timeout;
        long lastUpdt = this.application.getLastUpdateTime();
        while (true) {
            try {
                this.application = this.application.refresh();
                if (DEPLOYMENT_FAILED.equalsIgnoreCase(this.application.getStatus())) {
                    logger.debug("Deployment failed due to status: " + this.application.getStatus());
                    throw new ApplicationDeploymentFailedException();
                }
                if (DEPLOY_FAILED.equalsIgnoreCase(this.application.getDeploymentUpdateStatus())) {
                    logger.debug("Deployment failed due to deployment update status: " + this.application.getDeploymentUpdateStatus());
                    throw new ApplicationDeploymentFailedException();
                }
                if (this.application.getStatus().equalsIgnoreCase(STARTED) && this.application.getDeploymentUpdateStatus() == null && this.application.getLastUpdateTime() > lastUpdt) {
                    return;
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if (expires <= System.currentTimeMillis()) break;
            ThreadUtils.sleep((long)retryDelay);
        }
        logger.error("Deployment failed due to timeout");
        throw new ApplicationDeploymentFailedException();
    }
}

