/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint.runtime;

import com.kloudtek.anypoint.HttpException;
import com.kloudtek.anypoint.runtime.ApplicationDeploymentFailedException;
import com.kloudtek.anypoint.runtime.DeploymentResult;
import com.kloudtek.anypoint.runtime.HApplication;
import com.kloudtek.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDeploymentResult
extends DeploymentResult {
    private static final Logger logger = LoggerFactory.getLogger(HDeploymentResult.class);
    static final String DEPLOYMENT_FAILED = "DEPLOYMENT_FAILED";
    static final String STARTED = "STARTED";
    private HApplication application;

    public HDeploymentResult(HApplication application) {
        this.application = application;
    }

    @Override
    public void waitDeployed(long timeout, long retryDelay) throws HttpException, ApplicationDeploymentFailedException {
        ThreadUtils.sleep((long)2000L);
        long expires = System.currentTimeMillis() + timeout;
        while (true) {
            this.application = this.application.refresh();
            if (this.application.getDesiredStatus().equalsIgnoreCase("UPDATED")) continue;
            if (this.application.isStarted()) {
                return;
            }
            if (DEPLOYMENT_FAILED.equals(this.application.getLastReportedStatus())) {
                logger.debug("Deployment failed due to status: " + this.application.getLastReportedStatus());
                throw ApplicationDeploymentFailedException.create(this.application);
            }
            if (expires <= System.currentTimeMillis()) break;
            ThreadUtils.sleep((long)retryDelay);
        }
        logger.error("Deployment failed due to timeout");
        throw ApplicationDeploymentFailedException.create(this.application);
    }
}

