/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint.runtime;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.kloudtek.anypoint.AnypointObject;
import com.kloudtek.anypoint.Environment;
import com.kloudtek.anypoint.HttpException;
import com.kloudtek.anypoint.NotFoundException;
import com.kloudtek.anypoint.runtime.HApplication;
import com.kloudtek.kryptotek.DigestAlgorithm;
import com.kloudtek.kryptotek.DigestUtils;
import com.kloudtek.util.Hex;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
extends AnypointObject<Environment> {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    protected String id;
    protected String name;

    public Server() {
    }

    public Server(Environment environment) {
        super(environment);
    }

    public Server(Environment environment, String id) {
        super(environment);
        this.id = id;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void delete() throws HttpException {
        this.client.getHttpHelper().httpDelete("/hybrid/api/v1/servers/" + this.id, (Environment)this.parent);
    }

    public boolean checkApplicationExist(@NotNull String name, @NotNull File file, boolean matchDigest) throws HttpException, IOException {
        try {
            HApplication application = this.findApplication(name);
            if (application != null) {
                return !matchDigest || application.matchDigest(new String(Hex.encodeHex((byte[])DigestUtils.digest((File)file, (DigestAlgorithm)DigestAlgorithm.SHA1))));
            }
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public List<HApplication> listApplication() throws HttpException {
        String json = this.httpHelper.httpGet("/hybrid/api/v1/applications?targetId=" + this.id, (Environment)this.parent);
        return this.jsonHelper.readJsonList(HApplication.class, json, this, "/data");
    }

    public HApplication findApplication(String name) throws NotFoundException, HttpException {
        for (HApplication application : this.listApplication()) {
            if (!name.equals(application.getName())) continue;
            return application;
        }
        throw new NotFoundException("Unable to find application " + name + " in server " + ((Environment)this.parent).getId());
    }
}

