/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint.util;

import com.kloudtek.anypoint.AnypointClient;
import com.kloudtek.anypoint.Environment;
import com.kloudtek.anypoint.HttpException;
import com.kloudtek.anypoint.util.HttpDeleteWithBody;
import com.kloudtek.anypoint.util.StreamSource;
import com.kloudtek.util.Base64;
import com.kloudtek.util.ThreadUtils;
import com.kloudtek.util.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHelper
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(HttpHelper.class);
    private static final String HEADER_AUTH = "Authorization";
    private transient CloseableHttpClient httpClient;
    private String auth;
    private AnypointClient client;
    private String username;
    private String password;
    private int maxRetries = 4;
    private long retryDelay = 1000L;

    public HttpHelper() {
    }

    public HttpHelper(AnypointClient client, String username, String password) {
        this(HttpClients.createMinimal(), client, username, password);
    }

    public HttpHelper(CloseableHttpClient httpClient, AnypointClient client, String username, String password) {
        this.client = client;
        this.username = username;
        this.password = password;
        this.httpClient = httpClient;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.httpClient = HttpClients.createMinimal();
    }

    public void httpGetBasicAuth(String path, OutputStream outputStream) throws HttpException {
        logger.debug("HTTP GET W/ BASIC AUTH: " + path);
        HttpGet request = new HttpGet(HttpHelper.convertPath(path));
        this.setBasicAuthHeader((HttpRequestBase)request);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
            this.verifyStatusCode((HttpRequestBase)request, response);
            if (response.getEntity() == null) {
                throw new HttpException("Not body returned by url " + request.getURI());
            }
            IOUtils.copy((InputStream)response.getEntity().getContent(), (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new HttpException(e.getMessage(), e);
        }
    }

    public String httpGet(String path, Environment env) throws HttpException {
        logger.debug("HTTP GET " + path + " env=" + env);
        return this.executeWithEnv((HttpRequestBase)new HttpGet(HttpHelper.convertPath(path)), env);
    }

    public String httpGet(String path) throws HttpException {
        logger.debug("HTTP GET " + path);
        return this.executeWrapper((HttpRequestBase)new HttpGet(HttpHelper.convertPath(path)), null);
    }

    public String httpGet(String path, Map<String, String> headers) throws HttpException {
        logger.debug("HTTP GET " + path);
        HttpGet method = new HttpGet(HttpHelper.convertPath(path));
        HttpHelper.setHeader(headers, (HttpRequestBase)method);
        return this.executeWrapper((HttpRequestBase)method, null);
    }

    public String httpGetWithOrgAndOwner(String path, String orgId, String ownerId) throws HttpException {
        logger.debug("HTTP GET " + path);
        return this.httpGet(path, HttpHelper.createOrgAndOwnerHeaders(orgId, ownerId));
    }

    public String httpPost(String path, Object data, Environment env) throws HttpException {
        logger.debug("HTTP POST " + path + " env=" + env + " data=" + data);
        return this.executeWithDataAndEnv((HttpEntityEnclosingRequestBase)new HttpPost(HttpHelper.convertPath(path)), data, env);
    }

    public String httpPostWithOrgAndOwner(String path, Object data, String orgId, String ownerId) throws HttpException {
        return this.httpPost(path, data, HttpHelper.createOrgAndOwnerHeaders(orgId, ownerId));
    }

    public String httpPost(String path, Object data, Map<String, String> headers) throws HttpException {
        logger.debug("HTTP POST " + path + " headers=" + headers + " data=" + data);
        HttpPost method = new HttpPost(HttpHelper.convertPath(path));
        HttpHelper.setHeader(headers, (HttpRequestBase)method);
        return this.execute((HttpEntityEnclosingRequestBase)method, data);
    }

    public String httpPost(String path, Object data) throws HttpException {
        logger.debug("HTTP POST " + path + " data=" + data);
        return this.execute((HttpEntityEnclosingRequestBase)new HttpPost(HttpHelper.convertPath(path)), data);
    }

    public String httpPatch(String path, Object data) throws HttpException {
        logger.debug("HTTP PATCH " + path + " data=" + data);
        return this.execute((HttpEntityEnclosingRequestBase)new HttpPatch(HttpHelper.convertPath(path)), data);
    }

    public String httpPut(String path, Object data) throws HttpException {
        logger.debug("HTTP PUT " + path + " data=" + data);
        return this.execute((HttpEntityEnclosingRequestBase)new HttpPut(HttpHelper.convertPath(path)), data);
    }

    public String httpPut(String path, Object data, Environment environment) throws HttpException {
        logger.debug("HTTP PUT " + path);
        return this.executeWithDataAndEnv((HttpEntityEnclosingRequestBase)new HttpPut(HttpHelper.convertPath(path)), data, environment);
    }

    public String httpDelete(String path) throws HttpException {
        logger.debug("HTTP DELETE " + path);
        return this.executeWrapper((HttpRequestBase)new HttpDelete(HttpHelper.convertPath(path)), null);
    }

    public String httpDelete(String path, Object data) throws HttpException {
        logger.debug("HTTP DELETE " + path + " data=" + data);
        return this.execute(new HttpDeleteWithBody(HttpHelper.convertPath(path)), data);
    }

    public String httpDelete(@NotNull String path, @NotNull Environment env) throws HttpException {
        logger.debug("HTTP DELETE " + path + " env=" + env);
        return this.executeWithEnv((HttpRequestBase)new HttpDelete(HttpHelper.convertPath(path)), env);
    }

    public MultiPartRequest createMultiPartPostRequest(String url, Environment environment) {
        HttpPost request = new HttpPost(HttpHelper.convertPath(url));
        environment.addHeaders((HttpRequestBase)request);
        return new MultiPartRequest((HttpEntityEnclosingRequestBase)request);
    }

    public MultiPartRequest createMultiPartPatchRequest(String url, Environment environment) {
        HttpPatch request = new HttpPatch(HttpHelper.convertPath(url));
        environment.addHeaders((HttpRequestBase)request);
        return new MultiPartRequest((HttpEntityEnclosingRequestBase)request);
    }

    public MultiPartRequest createMultiPartPutRequest(String url, Environment environment) {
        HttpPut request = new HttpPut(HttpHelper.convertPath(url));
        environment.addHeaders((HttpRequestBase)request);
        return new MultiPartRequest((HttpEntityEnclosingRequestBase)request);
    }

    private String execute(@NotNull HttpEntityEnclosingRequestBase method, Object data) throws HttpException {
        if (data != null) {
            if (data instanceof HttpEntity) {
                method.setEntity((HttpEntity)data);
            } else {
                method.setHeader("Content-Type", "application/json");
                method.setEntity((HttpEntity)new ByteArrayEntity(this.client.getJsonHelper().toJson(data)));
            }
        }
        return this.executeWrapper((HttpRequestBase)method, null);
    }

    private String executeWithDataAndEnv(@NotNull HttpEntityEnclosingRequestBase method, @NotNull Object data, @NotNull Environment env) throws HttpException {
        env.addHeaders((HttpRequestBase)method);
        return this.execute(method, data);
    }

    private String executeWithEnv(@NotNull HttpRequestBase method, @NotNull Environment env) throws HttpException {
        env.addHeaders(method);
        return this.executeWrapper(method, null);
    }

    protected String executeWrapper(@NotNull HttpRequestBase method, MultiPartRequest multiPartRequest) throws HttpException {
        return this.executeWrapper(method, multiPartRequest, 0);
    }

    private String executeWrapper(@NotNull HttpRequestBase method, MultiPartRequest multiPartRequest, int attempt) throws HttpException {
        boolean authenticating = method.getURI().getPath().equals("/accounts/login");
        if (this.auth == null && !authenticating) {
            this.auth = this.client.authenticate(this.username, this.password);
        }
        try {
            if (multiPartRequest != null) {
                ((HttpEntityEnclosingRequestBase)method).setEntity(multiPartRequest.toEntity());
            }
            return this.doExecute(method);
        }
        catch (HttpException e) {
            if (e.getStatusCode() == 403 || e.getStatusCode() == 401 && !authenticating) {
                this.client.authenticate(this.username, this.password);
                return this.doExecute(method);
            }
            if (e.getStatusCode() >= 500) {
                if (++attempt > this.maxRetries) {
                    throw e;
                }
                ThreadUtils.sleep((long)this.retryDelay);
                return this.executeWrapper(method, multiPartRequest, attempt);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String doExecute(HttpRequestBase method) throws HttpException {
        if (this.auth != null && method.getFirstHeader(HEADER_AUTH) == null) {
            if (this.auth.startsWith("bearer ")) {
                this.auth = "Bearer " + this.auth.substring(7);
            }
            method.setHeader(HEADER_AUTH, this.auth);
        }
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)method);){
            this.verifyStatusCode(method, response);
            if (response.getEntity() != null && response.getEntity().getContent() != null) {
                String resStr = IOUtils.toString((InputStream)response.getEntity().getContent());
                logger.debug("RESULT CONTENT: " + resStr);
                String string = resStr;
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void verifyStatusCode(HttpRequestBase method, CloseableHttpResponse response) throws IOException, HttpException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode < 200 || statusCode > 299) {
            String errMsg = response.getEntity() != null && response.getEntity().getContent() != null ? " : " + IOUtils.toString((InputStream)response.getEntity().getContent()) : "";
            throw new HttpException("Anypoint returned status code " + statusCode + " - url: " + method.getURI() + " - err: " + errMsg, statusCode);
        }
    }

    public synchronized void setProxy(@NotNull String scheme, @NotNull String host, int port, @Nullable String username, @Nullable String password) {
        if (this.httpClient != null) {
            IOUtils.close((Closeable[])new Closeable[]{this.httpClient});
        }
        HttpClientBuilder builder = HttpClients.custom();
        HttpHost proxyHost = new HttpHost(host, port, scheme);
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHost);
        builder = builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        if (username != null && password != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(username, password));
            builder = builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        this.httpClient = builder.build();
    }

    public synchronized void unsetProxy() {
        if (this.httpClient != null) {
            IOUtils.close((Closeable[])new Closeable[]{this.httpClient});
        }
        this.httpClient = HttpClients.createMinimal();
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    private static void setHeader(Map<String, String> headers, HttpRequestBase method) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            method.setHeader(entry.getKey(), entry.getValue());
        }
    }

    public void setClient(AnypointClient client) {
        this.client = client;
    }

    protected static String convertPath(String path) {
        return path.startsWith("/") ? "https://anypoint.mulesoft.com" + path : path;
    }

    @NotNull
    private static HashMap<String, String> createOrgAndOwnerHeaders(String orgId, String ownerId) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-organization-id", orgId);
        headers.put("x-owner-id", ownerId);
        return headers;
    }

    private HttpRequestBase setBasicAuthHeader(HttpRequestBase request) {
        String authStr = this.username + ":" + this.password;
        byte[] encodedAuth = Base64.encodeBase64((byte[])authStr.getBytes(StandardCharsets.ISO_8859_1));
        String authHeader = "Basic " + new String(encodedAuth);
        request.setHeader(HEADER_AUTH, authHeader);
        return request;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public class RuntimeIOException
    extends RuntimeException {
        RuntimeIOException(IOException ioException) {
            super(ioException.getMessage(), ioException);
        }

        @NotNull
        IOException getIOException() {
            return (IOException)this.getCause();
        }
    }

    public class MultiPartRequest {
        private Map<String, Object> parts = new HashMap<String, Object>();
        private HttpEntityEnclosingRequestBase request;

        MultiPartRequest(HttpEntityEnclosingRequestBase request) {
            this.request = request;
        }

        public MultiPartRequest addText(@NotNull String name, @NotNull String value) {
            this.parts.put(name, value);
            return this;
        }

        public MultiPartRequest addBinary(@NotNull String name, @NotNull StreamSource streamSource) {
            this.parts.put(name, streamSource);
            return this;
        }

        HttpEntity toEntity() throws HttpException {
            try {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                for (Map.Entry<String, Object> e : this.parts.entrySet()) {
                    if (e.getValue() instanceof String) {
                        builder.addTextBody(e.getKey(), (String)e.getValue());
                        continue;
                    }
                    if (!(e.getValue() instanceof StreamSource)) continue;
                    builder.addBinaryBody(e.getKey(), ((StreamSource)e.getValue()).createInputStream(), ContentType.APPLICATION_OCTET_STREAM, ((StreamSource)e.getValue()).getFileName());
                }
                return builder.build();
            }
            catch (IOException e) {
                throw new HttpException("Failed to read data to send: " + e.getMessage(), e);
            }
        }

        public String execute() throws HttpException, IOException {
            try {
                logger.debug("HTTP {}", (Object)this.request);
                return HttpHelper.this.executeWrapper((HttpRequestBase)this.request, this);
            }
            catch (RuntimeIOException e) {
                throw e.getIOException();
            }
        }
    }
}

