/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.anypoint.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kloudtek.anypoint.AnypointClient;
import com.kloudtek.anypoint.AnypointObject;
import com.kloudtek.anypoint.InvalidJsonException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonHelper
implements Serializable {
    private ObjectMapper jsonMapper = new ObjectMapper();
    private AnypointClient client;

    public JsonHelper(AnypointClient client) {
        this.client = client;
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] toJson(Object obj) {
        try (ByteArrayOutputStream tmp = new ByteArrayOutputStream();){
            this.jsonMapper.writeValue((OutputStream)tmp, obj);
            byte[] byArray = tmp.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> toJsonMap(String json) {
        try {
            return (Map)this.jsonMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    public Map<String, Object> toJsonMap(JsonNode node) {
        try {
            return (Map)this.jsonMapper.treeToValue((TreeNode)node, Map.class);
        }
        catch (JsonProcessingException e) {
            throw new InvalidJsonException(e);
        }
    }

    public MapBuilder buildJsonMap() {
        return new MapBuilder();
    }

    public MapBuilder buildJsonMap(Map<String, Object> data) {
        return new MapBuilder(null, data);
    }

    public JsonNode readJsonTree(String json) {
        try {
            return this.jsonMapper.readTree(json);
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    public <X> X readJson(X obj, String json, String jsonPath) {
        try {
            return this.readJson(obj, this.jsonMapper.readerForUpdating(obj).readTree(json).at(jsonPath));
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    public <X> X readJson(X obj, String json) {
        return this.readJson(obj, json, (AnypointObject)null);
    }

    public <X> X readJson(X obj, String json, AnypointObject<?> parent) {
        try {
            this.jsonMapper.readerForUpdating(obj).readValue(json);
            if (obj instanceof AnypointObject) {
                ((AnypointObject)obj).setJson(json);
                if (parent != null) {
                    ((AnypointObject)obj).setParent(parent);
                }
            }
            return obj;
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    public <X> X readJson(Class<X> objClass, JsonNode node, AnypointObject<?> parent) {
        try {
            Object obj = this.jsonMapper.treeToValue((TreeNode)node, objClass);
            if (obj instanceof AnypointObject) {
                ((AnypointObject)obj).setJson(node.toString());
                ((AnypointObject)obj).setParent(parent);
            }
            return (X)obj;
        }
        catch (JsonProcessingException e) {
            throw new InvalidJsonException(e);
        }
    }

    public <X> X readJson(Class<X> objClass, JsonNode node, AnypointClient client) {
        try {
            Object obj = this.jsonMapper.treeToValue((TreeNode)node, objClass);
            if (obj instanceof AnypointObject) {
                ((AnypointObject)obj).setJson(node.toString());
                ((AnypointObject)obj).setClient(client);
            }
            return (X)obj;
        }
        catch (JsonProcessingException e) {
            throw new InvalidJsonException(e);
        }
    }

    public <X> List<X> readJsonList(Class<X> objClass, String json, AnypointObject<?> parent) {
        return this.readJsonList(objClass, json, parent, null);
    }

    public <X> List<X> readJsonList(Class<X> objClass, String json, AnypointObject<?> parent, String path) {
        try {
            ArrayList<X> list = new ArrayList<X>();
            JsonNode node = this.jsonMapper.readTree(json);
            if (path != null) {
                node = node.at(path);
            }
            for (JsonNode n : node) {
                list.add(this.readJson(objClass, n, parent));
            }
            return list;
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    public <X> X readJson(X obj, JsonNode node) {
        try {
            this.jsonMapper.readerForUpdating(obj).readValue(node);
            if (obj instanceof AnypointObject) {
                ((AnypointObject)obj).setJson(node.toString());
                ((AnypointObject)obj).setClient(this.client);
            }
            return obj;
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    public class MapBuilder {
        private MapBuilder parent;
        private Map<String, Object> request;

        public MapBuilder() {
            this.request = new HashMap<String, Object>();
        }

        public MapBuilder(MapBuilder parent, Map<String, Object> request) {
            this.parent = parent;
            this.request = request;
        }

        public MapBuilder set(String key, Object value) {
            this.request.put(key, value);
            return this;
        }

        public MapBuilder setNested(String nestKey, String key, Object value) {
            HashMap<String, Object> nestedMap = new HashMap<String, Object>();
            nestedMap.put(key, value);
            this.request.put(nestKey, nestedMap);
            return this;
        }

        public Map<String, Object> toMap() {
            if (this.parent != null) {
                return this.parent.toMap();
            }
            return this.request;
        }

        public MapBuilder addMap(String name) {
            HashMap<String, Object> subMap = new HashMap<String, Object>();
            this.request.put(name, subMap);
            return new MapBuilder(this, subMap);
        }
    }
}

