/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.ktserializer;

import com.kloudtek.ktserializer.ClassId;
import com.kloudtek.ktserializer.InvalidConfigException;
import com.kloudtek.ktserializer.LibraryId;
import com.kloudtek.ktserializer.SerializableList;
import com.kloudtek.ktserializer.ShortLibraryId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ClassMapper {
    static final Class<?>[] defaultClasses = new Class[]{SerializableList.class};
    private final ArrayList<ArrayList<String>> libraryClasses = new ArrayList();
    private final HashMap<ClassId, String> classIdToName = new HashMap();
    private final HashMap<String, ClassId> nameToClassId = new HashMap();
    private final HashSet<LibraryId> libraries = new HashSet();

    public ClassMapper() {
        this.registerLibraryInternal(new ShortLibraryId(0), this.toStrings(defaultClasses));
    }

    public ClassMapper(Class<?> ... classes) {
        this();
        this.registerLibrary((LibraryId)new ShortLibraryId(1), this.toStrings(classes));
    }

    public String get(LibraryId libraryId, int classId) {
        return this.classIdToName.get(new ClassId(libraryId, classId));
    }

    public ClassId get(String classType) {
        return this.nameToClassId.get(classType);
    }

    public boolean isLibraryRegistered(LibraryId libraryId) {
        return this.libraries.contains(libraryId);
    }

    public void registerLibrary(LibraryId libraryId, Class<?> ... classes) {
        this.registerLibraryInternal(libraryId, this.toStrings(Arrays.asList(classes)));
    }

    public void registerLibrary(LibraryId libraryId, String ... classes) {
        this.registerLibraryInternal(libraryId, Arrays.asList(classes));
    }

    public void registerLibrary(LibraryId libraryId, List<String> classes) {
        if (libraryId instanceof ShortLibraryId && ((ShortLibraryId)libraryId).getId() == 0) {
            throw new IllegalArgumentException("Short library id cannot be zero");
        }
        this.registerLibraryInternal(libraryId, classes);
    }

    private synchronized void registerLibraryInternal(LibraryId libraryId, List<String> classes) {
        if (this.libraries.contains(libraryId)) {
            throw new IllegalArgumentException("Library already registered: " + libraryId);
        }
        ArrayList<String> list = new ArrayList<String>(classes.size());
        for (int i = 0; i < classes.size(); ++i) {
            String className = classes.get(i);
            ClassId classId = new ClassId(libraryId, i);
            ClassId existing = this.nameToClassId.get(className);
            if (existing != null && !existing.equals(classId)) {
                throw new InvalidConfigException("Duplicate class registration: class name=" + className + " : new class id " + classId + " : existing class id " + existing);
            }
            list.add(className);
            this.classIdToName.put(classId, className);
            this.nameToClassId.put(className, classId);
        }
        this.libraryClasses.add(list);
        this.libraries.add(libraryId);
    }

    @NotNull
    private ArrayList<String> toStrings(@NotNull Class<?>[] classes) {
        return this.toStrings(Arrays.asList(classes));
    }

    @NotNull
    private ArrayList<String> toStrings(@NotNull List<Class<?>> classes) {
        ArrayList<String> list = new ArrayList<String>();
        for (Class<?> cl : classes) {
            list.add(cl.getName());
        }
        return list;
    }
}

