/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.ktserializer;

import com.kloudtek.ktserializer.CustomSerializable;
import com.kloudtek.ktserializer.InvalidSerializedDataException;
import com.kloudtek.ktserializer.Serializable;
import com.kloudtek.ktserializer.SerializableList;
import com.kloudtek.ktserializer.SerializationEngine;
import com.kloudtek.ktserializer.SerializedDataHeader;
import com.kloudtek.util.UnexpectedException;
import com.kloudtek.util.io.DataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeserializationStream
extends DataInputStream {
    @NotNull
    private SerializationEngine serializer;

    public DeserializationStream(@NotNull byte[] data, @NotNull SerializationEngine serializer) throws InvalidSerializedDataException {
        super((InputStream)new ByteArrayInputStream(data));
        this.serializer = serializer;
        try {
            long l = this.readUnsignedNumber();
        }
        catch (IOException e) {
            throw new InvalidSerializedDataException(e);
        }
    }

    @NotNull
    public <X extends Serializable> X readObject(X object, boolean specific) throws IOException, InvalidSerializedDataException {
        Class<?> expectedClass = object.getClass();
        SerializedDataHeader serializationMetadata = new SerializedDataHeader(this, this.serializer.getClassMapper(), specific ? object.getClass() : null);
        if (!serializationMetadata.getClassType().equals(expectedClass)) {
            throw new InvalidSerializedDataException("Object data of class " + serializationMetadata.getClassType().getName() + " does not match expected " + expectedClass.getName());
        }
        this.deserialize(object, serializationMetadata, this);
        return object;
    }

    @NotNull
    public Serializable readObject() throws IOException, InvalidSerializedDataException {
        SerializedDataHeader serializationMetadata = new SerializedDataHeader(this, this.serializer.getClassMapper(), null);
        try {
            Serializable object = serializationMetadata.getClassType().newInstance();
            this.deserialize(object, serializationMetadata, this);
            return object;
        }
        catch (InstantiationException e) {
            throw new InvalidSerializedDataException("Unable to create serialized class " + serializationMetadata.getClassType().getName() + ": " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidSerializedDataException("Unable to create serialized class " + serializationMetadata.getClassType().getName() + ": " + e.getMessage(), e);
        }
    }

    @NotNull
    public SerializationEngine getSerializer() {
        return this.serializer;
    }

    public <X extends Serializable> X readObject(X object) throws IOException, InvalidSerializedDataException {
        return this.readObject(object, false);
    }

    public <X extends Serializable> X readSpecificObject(X object) throws IOException, InvalidSerializedDataException {
        return this.readObject(object, true);
    }

    public <X extends Serializable> X readObject(Class<X> expectedClass) throws IOException, InvalidSerializedDataException {
        Serializable obj = this.readObject();
        if (!expectedClass.isInstance(obj)) {
            throw new IllegalArgumentException("Invalid class deserialized " + obj.getClass().getName() + " is not " + expectedClass.getName());
        }
        return (X)((Serializable)expectedClass.cast(obj));
    }

    public <X extends Serializable> List<X> readObjectList(Class<X> expectedClass) throws IOException, InvalidSerializedDataException {
        ArrayList<X> list = new ArrayList<X>();
        for (Serializable obj : this.readSpecificObject(SerializableList.class)) {
            try {
                list.add(expectedClass.cast(obj));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid class deserialized " + obj.getClass().getName() + " is not " + expectedClass.getName());
            }
        }
        return list;
    }

    public List<Serializable> readObjectList() throws IOException, InvalidSerializedDataException {
        return this.readObjectList(Serializable.class);
    }

    public <X extends Serializable> X readSpecificObject(Class<X> specificClass) throws IOException, InvalidSerializedDataException {
        SerializedDataHeader serializationMetadata = new SerializedDataHeader(this, this.serializer.getClassMapper(), specificClass);
        try {
            Serializable serializable = serializationMetadata.getClassType().newInstance();
            try {
                Serializable object = (Serializable)specificClass.cast(serializable);
                this.deserialize(object, serializationMetadata, this);
                return (X)object;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid class deserialized " + this.readObject().getClass().getName() + " is not " + specificClass.getName());
            }
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate class type " + serializationMetadata.getClassType().getName());
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    private <X extends Serializable> void deserialize(X object, SerializedDataHeader serializationMetadata, DeserializationStream ds) throws IOException, InvalidSerializedDataException {
        if (!(object instanceof CustomSerializable)) {
            throw new IllegalArgumentException("Only CustomSerializable supported at this time");
        }
        ((CustomSerializable)object).deserialize(ds, serializationMetadata.getVersion());
    }
}

