/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.ktserializer;

import com.kloudtek.ktserializer.CustomSerializable;
import com.kloudtek.ktserializer.DeserializationStream;
import com.kloudtek.ktserializer.InvalidSerializedDataException;
import com.kloudtek.ktserializer.Serializable;
import com.kloudtek.ktserializer.SerializationStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SerializableList
extends ArrayList<Serializable>
implements CustomSerializable {
    public SerializableList(int capacity) {
        super(capacity);
    }

    public SerializableList() {
    }

    public SerializableList(Collection<? extends Serializable> collection) {
        super(collection);
    }

    @Override
    public int getSerializationVersion() {
        return 0;
    }

    @Override
    public void serialize(@NotNull SerializationStream os) throws IOException {
        os.writeUnsignedNumber(this.size());
        for (Serializable x : this) {
            os.writeObject(x);
        }
    }

    @Override
    public void deserialize(@NotNull DeserializationStream is, int version) throws IOException, InvalidSerializedDataException {
        long total = is.readUnsignedNumber();
        int i = 0;
        while ((long)i < total) {
            this.add(is.readObject());
            ++i;
        }
    }
}

