/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.ktserializer;

import com.kloudtek.ktserializer.ClassMapper;
import com.kloudtek.ktserializer.DeserializationStream;
import com.kloudtek.ktserializer.ISerializerConfig;
import com.kloudtek.ktserializer.InvalidConfigException;
import com.kloudtek.ktserializer.InvalidSerializedDataException;
import com.kloudtek.ktserializer.Library;
import com.kloudtek.ktserializer.LibraryId;
import com.kloudtek.ktserializer.LongLibraryId;
import com.kloudtek.ktserializer.Serializable;
import com.kloudtek.ktserializer.SerializationStream;
import com.kloudtek.ktserializer.Serializer;
import com.kloudtek.ktserializer.ShortLibraryId;
import com.kloudtek.util.UnexpectedException;
import com.kloudtek.util.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializationEngine {
    protected final HashMap<String, Object> map = new HashMap();
    protected ClassMapper classMapper;
    protected boolean unmappedClassesAllowed = true;
    protected int maxReadSize;
    private final HashSet<String> loadedCfgs = new HashSet();
    private final HashMap<String, String> cfgLocations = new HashMap();

    public SerializationEngine() {
        this(Serializer.systemClassMapper());
    }

    public SerializationEngine(ClassMapper classMapper) {
        this.classMapper = classMapper;
    }

    public <S extends Serializable> S deserialize(@NotNull S serializableObj, @NotNull byte[] serializedData) throws InvalidSerializedDataException {
        try {
            DeserializationStream ds = new DeserializationStream(serializedData, this);
            return ds.readObject(serializableObj);
        }
        catch (IOException e) {
            throw new InvalidSerializedDataException(e);
        }
    }

    public <S extends Serializable> S deserializeSpecific(@NotNull S serializableObj, @NotNull byte[] serializedData) throws InvalidSerializedDataException {
        try {
            DeserializationStream ds = new DeserializationStream(serializedData, this);
            return ds.readSpecificObject(serializableObj);
        }
        catch (IOException e) {
            throw new InvalidSerializedDataException(e);
        }
    }

    public <X extends Serializable> X deserialize(@NotNull Class<X> classType, @NotNull byte[] serializedData) throws InvalidSerializedDataException {
        try {
            DeserializationStream ds = new DeserializationStream(serializedData, this);
            return ds.readObject(classType);
        }
        catch (IOException e) {
            throw new InvalidSerializedDataException(e);
        }
    }

    public <X extends Serializable> X deserializeSpecific(@NotNull Class<X> classType, @NotNull byte[] serializedData) throws InvalidSerializedDataException {
        try {
            DeserializationStream ds = new DeserializationStream(serializedData, this);
            return ds.readSpecificObject(classType);
        }
        catch (IOException e) {
            throw new InvalidSerializedDataException(e);
        }
    }

    public Serializable deserialize(@NotNull byte[] serializedData) throws InvalidSerializedDataException {
        try {
            DeserializationStream ds = new DeserializationStream(serializedData, this);
            return ds.readObject();
        }
        catch (IOException e) {
            throw new InvalidSerializedDataException(e);
        }
    }

    public List<Serializable> deserializeList(@NotNull byte[] serializedData) throws InvalidSerializedDataException {
        try {
            DeserializationStream ds = new DeserializationStream(serializedData, this);
            return ds.readObjectList();
        }
        catch (IOException e) {
            throw new InvalidSerializedDataException(e);
        }
    }

    public <S extends Serializable> List<S> deserializeList(@NotNull Class<S> classType, @NotNull byte[] serializedData) throws InvalidSerializedDataException {
        try {
            DeserializationStream ds = new DeserializationStream(serializedData, this);
            return ds.readObjectList(classType);
        }
        catch (IOException e) {
            throw new InvalidSerializedDataException(e);
        }
    }

    public byte[] serialize(@NotNull Serializable object) {
        return this.serialize(object, false);
    }

    public byte[] serializeSpecific(@NotNull Serializable object) {
        return this.serialize(object, true);
    }

    private byte[] serialize(@NotNull Serializable object, boolean specific) {
        try {
            SerializationStream os = new SerializationStream(this);
            os.writeObject(object, this.classMapper, specific);
            return os.closeAndReturnData();
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public byte[] serializeList(@NotNull Collection<? extends Serializable> collection) {
        try {
            SerializationStream os = new SerializationStream(this);
            os.writeObjectList(collection, this.classMapper);
            return os.closeAndReturnData();
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public SerializationEngine setInject(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    public Object getInject(String key) {
        return this.getImpl(key);
    }

    public SerializationEngine setInject(Object value) {
        return this.setInject(value.getClass().getName(), value);
    }

    public SerializationEngine setInject(Class<?> classType, Object value) {
        this.map.put(classType.getName(), value);
        return this;
    }

    public <X> X getInject(Class<X> classType) {
        return classType.cast(this.getImpl(classType.getName()));
    }

    private Object getImpl(String key) {
        return this.map.get(key);
    }

    public ClassMapper getClassMapper() {
        return this.classMapper;
    }

    public boolean isUnmappedClassesAllowed() {
        return this.unmappedClassesAllowed;
    }

    public void setUnmappedClassesAllowed(boolean unmappedClassesAllowed) {
        this.unmappedClassesAllowed = unmappedClassesAllowed;
    }

    public int getMaxReadSize() {
        return this.maxReadSize;
    }

    public void setMaxReadSize(int maxReadSize) {
        this.maxReadSize = maxReadSize;
    }

    public synchronized void loadDefaultConfig() {
        try {
            String configClassName = System.getProperty("com.kloudtek.ktserializer.ISerializerConfig", "com.kloudtek.ktserializer.KTSerializerConfig");
            Class<?> configClass = Class.forName(configClassName);
            ISerializerConfig config = (ISerializerConfig)ISerializerConfig.class.cast(configClass.newInstance());
            this.load(config);
        }
        catch (InstantiationException e) {
            throw new UnexpectedException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedException((Throwable)e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void load(ISerializerConfig config) {
        this.setUnmappedClassesAllowed(config.isDynaClassesAllowed());
        for (Map.Entry<LibraryId, Library> entry : config.getLibraries().entrySet()) {
            this.classMapper.registerLibrary(entry.getKey(), entry.getValue().getClasses());
        }
        this.loadedCfgs.add(config.getId());
        this.cfgLocations.put(config.getId(), config.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void loadConfig(String classpathLocation) {
        try {
            Enumeration<URL> resources = ClassMapper.class.getClassLoader().getResources(classpathLocation);
            if (!resources.hasMoreElements()) {
                throw new InvalidConfigException("Cannot find config file " + classpathLocation);
            }
            while (resources.hasMoreElements()) {
                InputStream is = resources.nextElement().openStream();
                try {
                    Properties p = new Properties();
                    p.load(is);
                    for (Map.Entry<Object, Object> entry : p.entrySet()) {
                        String key = entry.getKey().toString().toLowerCase();
                        String value = entry.getValue().toString();
                        if (key.startsWith("lib.")) {
                            LibraryId libraryId;
                            key = key.substring(4);
                            try {
                                libraryId = new ShortLibraryId(Short.parseShort(key));
                            }
                            catch (NumberFormatException e) {
                                libraryId = new LongLibraryId(key);
                            }
                            if (!this.classMapper.isLibraryRegistered(libraryId)) {
                                try {
                                    Class<?> clazz = Class.forName(value);
                                    if (!Library.class.isAssignableFrom(clazz)) {
                                        throw new InvalidConfigException("Invalid ktserializer class isn't a library: " + clazz.getName());
                                    }
                                    Library library = clazz.asSubclass(Library.class).newInstance();
                                    this.classMapper.registerLibrary(libraryId, library.getClasses());
                                }
                                catch (ClassNotFoundException e) {
                                    throw new InvalidConfigException("Unable to find class: " + value + ": " + e.getMessage(), e);
                                }
                                catch (InstantiationException e) {
                                    throw new InvalidConfigException("Unable to instantiate class: " + value + ": " + e.getMessage(), e);
                                }
                                catch (IllegalAccessException e) {
                                    throw new InvalidConfigException("Unable to instantiate class: " + value + ": " + e.getMessage(), e);
                                }
                            }
                        } else if (key.equals("allowdynaclasses") && this.unmappedClassesAllowed && !Boolean.parseBoolean(value)) {
                            this.setUnmappedClassesAllowed(false);
                        }
                        String id = p.getProperty("id");
                        this.loadedCfgs.add(id);
                        this.cfgLocations.put(id, classpathLocation);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close((Closeable[])new Closeable[]{is});
                    throw throwable;
                    return;
                }
                IOUtils.close((Closeable[])new Closeable[]{is});
            }
        }
        catch (IOException e) {
            throw new InvalidConfigException(e);
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigException(e);
        }
        catch (ClassCastException e) {
            throw new InvalidConfigException(e);
        }
    }

    public void checkConfigLoaded(@Nullable Boolean dynaClassesAllowed, String ... cfgIds) {
        if (cfgIds != null) {
            for (String id : cfgIds) {
                if (this.loadedCfgs.contains(id)) continue;
                throw new RuntimeException("KTSerialiser configuration file id " + id + " hasn't been loaded");
            }
        }
        if (dynaClassesAllowed != null && !dynaClassesAllowed.equals(this.unmappedClassesAllowed)) {
            throw new RuntimeException("DynaClassesAllowed config mismatch (was expecting " + dynaClassesAllowed + ")");
        }
    }
}

