/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.ktserializer;

import com.kloudtek.ktserializer.ClassMapper;
import com.kloudtek.ktserializer.CustomSerializable;
import com.kloudtek.ktserializer.Serializable;
import com.kloudtek.ktserializer.SerializableList;
import com.kloudtek.ktserializer.SerializationEngine;
import com.kloudtek.ktserializer.SerializedDataHeader;
import com.kloudtek.util.io.ByteArrayDataOutputStream;
import com.kloudtek.util.io.DataOutputStream;
import com.kloudtek.util.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SerializationStream
extends DataOutputStream {
    @NotNull
    private SerializationEngine serializer;

    public SerializationStream(@NotNull SerializationEngine serializer) throws IOException {
        super((OutputStream)new ByteArrayDataOutputStream());
        this.serializer = serializer;
        this.writeUnsignedNumber(0L);
    }

    @NotNull
    public SerializationEngine getSerializer() {
        return this.serializer;
    }

    public void writeObject(Serializable serializable) throws IOException {
        this.writeObject(serializable, null);
    }

    public void writeObject(Serializable serializable, ClassMapper classMapper) throws IOException {
        if (!(serializable instanceof CustomSerializable)) {
            throw new IllegalArgumentException("Only CustomSerializable supported at this time");
        }
        this.writeObject(serializable, classMapper, false);
    }

    public void writeObjectList(Collection<? extends Serializable> collection) throws IOException {
        this.writeObjectList(collection, this.serializer.getClassMapper());
    }

    public void writeObjectList(Collection<? extends Serializable> collection, ClassMapper classMapper) throws IOException {
        this.writeObject(new SerializableList(collection), classMapper, true);
    }

    public void writeObject(Serializable serializable, ClassMapper classMapper, boolean specificClass) throws IOException {
        SerializedDataHeader metadata = new SerializedDataHeader(this, ((CustomSerializable)serializable).getSerializationVersion(), serializable.getClass(), classMapper, specificClass);
        metadata.write(this);
        ((CustomSerializable)serializable).serialize(this);
    }

    public byte[] closeAndReturnData() {
        ByteArrayDataOutputStream buffer = (ByteArrayDataOutputStream)this.out;
        IOUtils.close((Closeable[])new Closeable[]{buffer});
        return buffer.toByteArray();
    }
}

