/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.ktserializer;

import com.kloudtek.ktserializer.ClassId;
import com.kloudtek.ktserializer.ClassMapper;
import com.kloudtek.ktserializer.DeserializationStream;
import com.kloudtek.ktserializer.InvalidSerializedDataException;
import com.kloudtek.ktserializer.LibraryId;
import com.kloudtek.ktserializer.LongLibraryId;
import com.kloudtek.ktserializer.Serializable;
import com.kloudtek.ktserializer.SerializationStream;
import com.kloudtek.ktserializer.ShortLibraryId;
import com.kloudtek.util.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;

public class SerializedDataHeader {
    public static final long[] EMPTYFLAGS = new long[]{0L};
    private int version;
    private ClassId classId;
    private Class<? extends Serializable> classType;
    private boolean specificClass;

    public SerializedDataHeader(DeserializationStream ds, ClassMapper classMapper) throws IOException, InvalidSerializedDataException {
        this(ds, classMapper, null);
    }

    public SerializedDataHeader(DeserializationStream ds, ClassMapper classMapper, Class<? extends Serializable> specificClass) throws IOException, InvalidSerializedDataException {
        if (classMapper == null) {
            classMapper = ds.getSerializer().getClassMapper();
        }
        int flagsBytes = ds.readUnsignedByte();
        BitSet flags = BitSet.valueOf(new long[]{flagsBytes});
        boolean specific = this.checkFlag(flags, Flags.SPECIFIC);
        boolean longLibId = this.checkFlag(flags, Flags.LONGLIBID);
        this.version = (int)ds.readUnsignedNumber();
        if (specific && specificClass == null) {
            throw new InvalidSerializedDataException("Class was serialized as specific but no specific class was provided: " + specificClass);
        }
        if (!specific && specificClass != null) {
            throw new InvalidSerializedDataException("Class was not serialized as specific but a specific class was provided: " + specificClass);
        }
        if (!specific) {
            String className;
            int classId = (int)ds.readUnsignedNumber();
            if (classId == 0) {
                className = ds.readUTF();
                if (!ds.getSerializer().isUnmappedClassesAllowed()) {
                    throw new InvalidSerializedDataException("Dynamic classes are not allowed: " + className);
                }
            } else {
                LibraryId libraryId = longLibId ? new LongLibraryId(ds.readUTF()) : new ShortLibraryId((short)ds.readUnsignedByte());
                className = classMapper.get(libraryId, classId - 1);
                if (className == null) {
                    throw new InvalidSerializedDataException("Invalid class id: " + new ClassId(libraryId, classId));
                }
            }
            try {
                this.classType = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidSerializedDataException(e);
            }
            catch (ClassCastException e) {
                throw new InvalidSerializedDataException(e);
            }
        } else {
            this.classType = specificClass;
        }
    }

    public SerializedDataHeader(SerializationStream serializationStream, Integer version, Class<? extends Serializable> classType, ClassMapper classMapper, boolean specificClass) {
        this.specificClass = specificClass;
        if (version != null) {
            long v = version.intValue();
            if (v < 0L) {
                throw new IllegalArgumentException("version cannot be a negative number: " + version);
            }
            if (v > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("version cannot be higher than 2147483647");
            }
            this.version = version;
        }
        this.classType = classType;
        if (classMapper == null) {
            classMapper = serializationStream.getSerializer().getClassMapper();
        }
        if (classMapper != null) {
            this.classId = classMapper.get(classType.getName());
        }
        if (!specificClass && !serializationStream.getSerializer().isUnmappedClassesAllowed() && this.classId == null) {
            throw new IllegalArgumentException("Serialization of un-mapped classes is disallowed: " + classType.getName());
        }
    }

    public void write(DataOutputStream ss) throws IOException {
        long[] flagsBytes;
        boolean longId;
        BitSet flags = new BitSet();
        if (this.specificClass) {
            this.setFlag(flags, Flags.SPECIFIC);
        }
        boolean bl = longId = this.classId != null && this.classId.getLibraryId() instanceof LongLibraryId;
        if (longId) {
            this.setFlag(flags, Flags.LONGLIBID);
        }
        if ((flagsBytes = flags.toLongArray()).length == 0) {
            flagsBytes = EMPTYFLAGS;
        }
        ss.writeUnsignedNumber(flagsBytes[0]);
        ss.writeUnsignedNumber((long)this.version);
        if (!this.specificClass) {
            if (this.classId != null) {
                ss.writeUnsignedNumber((long)(this.classId.getClassId() + 1));
                if (longId) {
                    ss.writeUTF(this.classId.getLibraryId().toString());
                } else {
                    ss.writeByte(((ShortLibraryId)this.classId.getLibraryId()).getId());
                }
            } else {
                ss.writeUnsignedNumber(0L);
                ss.writeUTF(this.classType.getName());
            }
        }
    }

    private void setFlag(BitSet flags, Flags flag) {
        flags.set(flag.ordinal());
    }

    private boolean checkFlag(BitSet flags, Flags flag) {
        return flags.get(flag.ordinal());
    }

    public Integer getVersion() {
        return this.version;
    }

    public Class<? extends Serializable> getClassType() {
        return this.classType;
    }

    public static enum Flags {
        SPECIFIC,
        LONGLIBID;

    }
}

