/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.ktserializer;

import com.kloudtek.ktserializer.InvalidSerializedDataException;
import com.kloudtek.util.StringUtils;
import com.kloudtek.util.UnexpectedException;
import com.kloudtek.util.io.ByteArrayDataOutputStream;
import com.kloudtek.util.io.DataInputStream;
import com.kloudtek.util.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class StreamDictionary {
    private final ArrayList<byte[]> dataList = new ArrayList();
    private final HashMap<byte[], Long> index = new HashMap();

    public byte[] serialize() {
        try {
            ByteArrayDataOutputStream buf = new ByteArrayDataOutputStream();
            this.serialize((DataOutputStream)buf);
            buf.close();
            return buf.toByteArray();
        }
        catch (IOException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public void serialize(DataOutputStream os) throws IOException {
        os.writeUnsignedNumber((long)this.dataList.size());
        for (byte[] data : this.dataList) {
            os.writeData(data);
        }
    }

    public void deserialize(DataInputStream is) throws IOException {
        long len = is.readUnsignedNumber();
        new ArrayList((int)len);
        int i = 0;
        while ((long)i < len) {
            this.dataList.add(is.readData());
            ++i;
        }
    }

    public synchronized byte[] getData(long id) throws InvalidSerializedDataException {
        try {
            return this.dataList.get((int)id);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidSerializedDataException("Invalid dictionary id " + id);
        }
    }

    public synchronized long setData(byte[] data) {
        Long id = this.index.get(data);
        if (id == null) {
            this.dataList.add(data);
            id = this.dataList.size() - 1;
            this.index.put(data, id);
        }
        return id;
    }

    public String getString(long id) throws InvalidSerializedDataException {
        return StringUtils.utf8((byte[])this.getData(id));
    }

    public long setString(String data) {
        return this.setData(StringUtils.utf8((String)data));
    }
}

