/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.mule.elogging.jackson.jr.ob.impl;

import com.kloudtek.mule.elogging.jackson.core.JsonParser;
import com.kloudtek.mule.elogging.jackson.core.JsonToken;
import com.kloudtek.mule.elogging.jackson.jr.ob.JSONObjectException;
import com.kloudtek.mule.elogging.jackson.jr.ob.impl.CollectionBuilder;
import com.kloudtek.mule.elogging.jackson.jr.ob.impl.JSONReader;
import com.kloudtek.mule.elogging.jackson.jr.ob.impl.ValueReader;
import java.io.IOException;

public class ArrayReader
extends ValueReader {
    protected final Class<?> _elementType;
    protected final ValueReader _valueReader;

    public ArrayReader(Class<?> clazz, ValueReader valueReader) {
        this._elementType = clazz;
        this._valueReader = valueReader;
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        if (jsonParser.nextToken() != JsonToken.START_ARRAY) {
            if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                return null;
            }
            return JSONObjectException.from(jsonParser, "Unexpected token " + (Object)((Object)jsonParser.getCurrentToken()) + "; should get START_ARRAY");
        }
        CollectionBuilder collectionBuilder = jSONReader._collectionBuilder(null);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.emptyArray(this._elementType);
        }
        Object object = this._valueReader.read(jSONReader, jsonParser);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.singletonArray(this._elementType, object);
        }
        collectionBuilder = collectionBuilder.start().add(object);
        do {
            collectionBuilder = collectionBuilder.add(this._valueReader.read(jSONReader, jsonParser));
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return collectionBuilder.buildArray(this._elementType);
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        CollectionBuilder collectionBuilder = jSONReader._collectionBuilder(null);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.emptyArray(this._elementType);
        }
        Object object = this._valueReader.read(jSONReader, jsonParser);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.singletonArray(this._elementType, object);
        }
        collectionBuilder = collectionBuilder.start().add(object);
        do {
            collectionBuilder = collectionBuilder.add(this._valueReader.read(jSONReader, jsonParser));
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return collectionBuilder.buildArray(this._elementType);
    }
}

