/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.mule.elogging.jackson.jr.ob.impl;

import com.kloudtek.mule.elogging.jackson.jr.ob.JSONObjectException;
import com.kloudtek.mule.elogging.jackson.jr.ob.impl.ValueReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public final class BeanPropertyReader {
    private final String _name;
    private final ValueReader _valueReader;
    private final Method _setter;
    private final Field _field;

    public BeanPropertyReader(String string, Field field, Method method) {
        if (field == null && method == null) {
            throw new IllegalArgumentException("Both `field` and `setter` can not be null");
        }
        this._name = string;
        this._field = field;
        this._setter = method;
        this._valueReader = null;
    }

    protected BeanPropertyReader(BeanPropertyReader beanPropertyReader, ValueReader valueReader) {
        this._name = beanPropertyReader._name;
        this._field = beanPropertyReader._field;
        this._setter = beanPropertyReader._setter;
        this._valueReader = valueReader;
    }

    public BeanPropertyReader withReader(ValueReader valueReader) {
        return new BeanPropertyReader(this, valueReader);
    }

    public Type genericSetterType() {
        if (this._setter != null) {
            return this._setter.getGenericParameterTypes()[0];
        }
        return this._field.getGenericType();
    }

    public Class<?> rawSetterType() {
        if (this._setter != null) {
            return this._setter.getParameterTypes()[0];
        }
        return this._field.getType();
    }

    public ValueReader getReader() {
        return this._valueReader;
    }

    public String getName() {
        return this._name;
    }

    public void setValueFor(Object object, Object object2) throws IOException {
        try {
            if (this._setter == null) {
                this._field.set(object, object2);
            } else {
                this._setter.invoke(object, object2);
            }
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            if (throwable instanceof InvocationTargetException) {
                throwable = throwable.getCause();
            }
            throw new JSONObjectException("Failed to set property '" + this._name + "'; exception " + exception.getClass().getName() + "): " + throwable.getMessage(), throwable);
        }
    }

    protected String _bean() {
        if (this._setter != null) {
            return this._setter.getDeclaringClass().getName();
        }
        return this._field.getDeclaringClass().getName();
    }

    public String toString() {
        return this._name;
    }
}

