/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.mule.elogging.jackson.jr.ob.impl;

import com.kloudtek.mule.elogging.jackson.core.JsonParser;
import com.kloudtek.mule.elogging.jackson.core.JsonToken;
import com.kloudtek.mule.elogging.jackson.jr.ob.JSON;
import com.kloudtek.mule.elogging.jackson.jr.ob.JSONObjectException;
import com.kloudtek.mule.elogging.jackson.jr.ob.impl.BeanPropertyReader;
import com.kloudtek.mule.elogging.jackson.jr.ob.impl.JSONReader;
import com.kloudtek.mule.elogging.jackson.jr.ob.impl.ValueReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;

public class BeanReader
extends ValueReader {
    protected final Class<?> _type;
    protected final Map<String, BeanPropertyReader> _propsByName;
    protected final Constructor<?> _defaultCtor;
    protected final Constructor<?> _stringCtor;
    protected final Constructor<?> _longCtor;

    public BeanReader(Class<?> clazz, Map<String, BeanPropertyReader> map, Constructor<?> constructor, Constructor<?> constructor2, Constructor<?> constructor3) {
        this._type = clazz;
        this._propsByName = map;
        this._defaultCtor = constructor;
        this._stringCtor = constructor2;
        this._longCtor = constructor3;
    }

    public Map<String, BeanPropertyReader> propertiesByName() {
        return this._propsByName;
    }

    public BeanPropertyReader findProperty(String string) {
        return this._propsByName.get(string);
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.nextToken();
        try {
            switch (jsonToken) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_STRING: {
                    return this.create(jsonParser.getText());
                }
                case VALUE_NUMBER_INT: {
                    return this.create(jsonParser.getLongValue());
                }
                case START_OBJECT: {
                    String string;
                    Object object = this.create();
                    while ((string = jsonParser.nextFieldName()) != null) {
                        BeanPropertyReader beanPropertyReader = this.findProperty(string);
                        if (beanPropertyReader == null) {
                            this.handleUnknown(jSONReader, jsonParser, string);
                            continue;
                        }
                        ValueReader valueReader = beanPropertyReader.getReader();
                        beanPropertyReader.setValueFor(object, valueReader.readNext(jSONReader, jsonParser));
                    }
                    if (!jsonParser.hasToken(JsonToken.END_OBJECT)) {
                        throw this._reportProblem(jsonParser);
                    }
                    return object;
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw JSONObjectException.from(jsonParser, "Failed to create an instance of " + this._type.getName() + " due to (" + exception.getClass().getName() + "): " + exception.getMessage(), exception);
        }
        throw JSONObjectException.from(jsonParser, "Can not create a " + this._type.getName() + " instance out of " + this._tokenDesc(jsonParser));
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        try {
            switch (jsonToken) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_STRING: {
                    return this.create(jsonParser.getText());
                }
                case VALUE_NUMBER_INT: {
                    return this.create(jsonParser.getLongValue());
                }
                case START_OBJECT: {
                    String string;
                    Object object = this.create();
                    while ((string = jsonParser.nextFieldName()) != null) {
                        BeanPropertyReader beanPropertyReader = this.findProperty(string);
                        if (beanPropertyReader == null) {
                            this.handleUnknown(jSONReader, jsonParser, string);
                            continue;
                        }
                        ValueReader valueReader = beanPropertyReader.getReader();
                        beanPropertyReader.setValueFor(object, valueReader.readNext(jSONReader, jsonParser));
                    }
                    if (!jsonParser.hasToken(JsonToken.END_OBJECT)) {
                        throw this._reportProblem(jsonParser);
                    }
                    return object;
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw JSONObjectException.from(jsonParser, exception, "Failed to create an instance of %s due to (%s): %s", this._type.getName(), exception.getClass().getName(), exception.getMessage());
        }
        throw JSONObjectException.from(jsonParser, "Can not create a %s instance out of %s", this._type.getName(), this._tokenDesc(jsonParser));
    }

    protected Object create() throws Exception {
        if (this._defaultCtor == null) {
            throw new IllegalStateException("Class " + this._type.getName() + " does not have default constructor to use");
        }
        return this._defaultCtor.newInstance(new Object[0]);
    }

    protected Object create(String string) throws Exception {
        if (this._stringCtor == null) {
            throw new IllegalStateException("Class " + this._type.getName() + " does not have single-String constructor to use");
        }
        return this._stringCtor.newInstance(string);
    }

    protected Object create(long l) throws Exception {
        if (this._longCtor == null) {
            throw new IllegalStateException("Class " + this._type.getName() + " does not have single-long constructor to use");
        }
        return this._longCtor.newInstance(l);
    }

    protected void handleUnknown(JSONReader jSONReader, JsonParser jsonParser, String string) throws IOException {
        if (JSON.Feature.FAIL_ON_UNKNOWN_BEAN_PROPERTY.isEnabled(jSONReader._features)) {
            throw JSONObjectException.from(jsonParser, "Unrecognized JSON property '" + string + "' for Bean type " + this._type.getName());
        }
        jsonParser.nextToken();
        jsonParser.skipChildren();
    }

    protected IOException _reportProblem(JsonParser jsonParser) {
        return JSONObjectException.from(jsonParser, "Unexpected token " + (Object)((Object)jsonParser.getCurrentToken()) + "; should get FIELD_NAME or END_OBJECT");
    }
}

