/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.mule.elogging.jackson.jr.type;

import com.kloudtek.mule.elogging.jackson.jr.type.TypeBindings;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ResolvedType
implements Type,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ResolvedType[] NO_TYPES = new ResolvedType[0];
    protected static final int T_ARRAY = 1;
    protected static final int T_INTERFACE = 2;
    protected static final int T_PRIMITIVE = 3;
    protected static final int T_RECURSIVE = 4;
    protected static final int T_REGULAR = 5;
    protected final int _kind;
    protected final Class<?> _erasedType;
    protected final TypeBindings _bindings;
    protected final ResolvedType[] _interfaces;
    protected final ResolvedType _elemType;
    protected final ResolvedType _super;

    protected ResolvedType(Class<?> clazz) {
        this(3, clazz, null, null, null, null);
    }

    protected ResolvedType(Class<?> clazz, TypeBindings typeBindings) {
        this(3, clazz, null, null, null, null);
    }

    protected ResolvedType(Class<?> clazz, TypeBindings typeBindings, ResolvedType resolvedType) {
        this(1, clazz, null, typeBindings, null, resolvedType);
    }

    protected ResolvedType(Class<?> clazz, TypeBindings typeBindings, ResolvedType[] resolvedTypeArray) {
        this(2, clazz, null, typeBindings, resolvedTypeArray, null);
    }

    protected ResolvedType(Class<?> clazz, ResolvedType resolvedType, TypeBindings typeBindings, ResolvedType[] resolvedTypeArray) {
        this(5, clazz, resolvedType, typeBindings, resolvedTypeArray, null);
    }

    private ResolvedType(int n, Class<?> clazz, ResolvedType resolvedType, TypeBindings typeBindings, ResolvedType[] resolvedTypeArray, ResolvedType resolvedType2) {
        this._kind = n;
        this._erasedType = clazz;
        this._super = resolvedType;
        this._bindings = typeBindings == null ? TypeBindings.emptyBindings() : typeBindings;
        this._interfaces = resolvedTypeArray;
        this._elemType = resolvedType2;
    }

    public Class<?> erasedType() {
        return this._erasedType;
    }

    public ResolvedType elementType() {
        return this._elemType;
    }

    public ResolvedType parentType() {
        return this._super;
    }

    public boolean isArray() {
        return this._kind == 1;
    }

    public final List<ResolvedType> implInterfaces() {
        if (this._interfaces == null || this._interfaces.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(this._interfaces);
    }

    public List<ResolvedType> typeParams() {
        return this._bindings.getTypeParameters();
    }

    public TypeBindings typeBindings() {
        return this._bindings;
    }

    public List<ResolvedType> typeParametersFor(Class<?> clazz) {
        ResolvedType resolvedType = this.findSupertype(clazz);
        if (resolvedType != null) {
            return resolvedType.typeParams();
        }
        return null;
    }

    public ResolvedType findSupertype(Class<?> clazz) {
        ResolvedType resolvedType;
        Object object;
        if (clazz == this._erasedType) {
            return this;
        }
        if (clazz.isInterface()) {
            object = this.implInterfaces().iterator();
            while (object.hasNext()) {
                resolvedType = (ResolvedType)object.next();
                ResolvedType resolvedType2 = resolvedType.findSupertype(clazz);
                if (resolvedType2 == null) continue;
                return resolvedType2;
            }
        }
        if ((object = this.parentType()) != null && (resolvedType = ((ResolvedType)object).findSupertype(clazz)) != null) {
            return resolvedType;
        }
        return null;
    }

    public String getDesc() {
        StringBuilder stringBuilder = new StringBuilder();
        return this.appendDesc(stringBuilder).toString();
    }

    public StringBuilder appendDesc(StringBuilder stringBuilder) {
        switch (this._kind) {
            case 3: {
                return stringBuilder.append(this._erasedType.getName());
            }
            case 1: {
                return this._elemType.appendDesc(stringBuilder).append("[]");
            }
        }
        return this._appendClassDesc(stringBuilder);
    }

    public String toString() {
        return this.getDesc();
    }

    public int hashCode() {
        return this._erasedType.getName().hashCode() + this._bindings.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        ResolvedType resolvedType = (ResolvedType)object;
        if (resolvedType._erasedType != this._erasedType) {
            return false;
        }
        return this._bindings.equals(resolvedType._bindings);
    }

    protected StringBuilder _appendClassDesc(StringBuilder stringBuilder) {
        stringBuilder.append(this._erasedType.getName());
        int n = this._bindings.size();
        if (n > 0) {
            stringBuilder.append('<');
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder = this._bindings.getBoundType(i).appendDesc(stringBuilder);
            }
            stringBuilder.append('>');
        }
        return stringBuilder;
    }
}

