/*
 * Decompiled with CFR 0.152.
 */
package com.kloudtek.mule.elogging.log4j2;

import com.kloudtek.mule.elogging.jackson.jr.ob.JSONComposer;
import com.kloudtek.mule.elogging.jackson.jr.ob.comp.ObjectComposer;
import com.kloudtek.mule.elogging.log4j2.MuleLogMessage;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.message.Message;

public class RequestResponseLogMessage
implements Message {
    private Type type;
    private MuleLogMessage request;
    private MuleLogMessage response;
    private String sourceElementLocation;
    private String sourceElementXml;
    private String messageSourceUri;
    private String messageSourceName;
    private String flowName;
    private String flowFileName;
    private String flowFileLine;
    private String connectorClass;
    private Map<String, String> connectorInfo;
    private long duration;

    public RequestResponseLogMessage(Type type, MuleLogMessage request, MuleLogMessage outboundMessage, long duration, String messageSourceUri, String messageSourceName, String flowName, String flowFileName, String flowFileLine, String connectorClass, Map<String, String> connectorInfo) {
        this.type = type;
        this.request = request;
        this.response = outboundMessage;
        this.duration = duration;
        this.messageSourceUri = messageSourceUri;
        this.messageSourceName = messageSourceName;
        this.flowName = flowName;
        this.flowFileName = flowFileName;
        this.flowFileLine = flowFileLine;
        this.connectorClass = connectorClass;
        this.connectorInfo = connectorInfo;
    }

    public void toJson(ObjectComposer<JSONComposer<String>> json) throws IOException {
        json.put("type", this.type.name().toLowerCase());
        json.put("message", this.type.name().toLowerCase() + " mule message");
        if (this.request != null) {
            this.request.toJson(json, "mule.request");
        }
        if (this.response != null) {
            this.response.toJson(json, "mule.response");
        }
        if (this.sourceElementLocation != null) {
            json.put("sourceElementLocation", this.sourceElementLocation);
        }
        if (this.sourceElementXml != null) {
            json.put("sourceElementXml", this.sourceElementXml);
        }
        json.put("messageSourceUri", this.messageSourceUri);
        json.put("messageSourceName", this.messageSourceUri);
        json.put("duration", this.duration);
        json.put("flowName", this.flowName);
        json.put("flowFileName", this.flowFileName);
        json.put("flowFileLine", this.flowFileLine);
        if (this.connectorClass != null) {
            json.put("connector.class", this.connectorClass);
            if (this.connectorInfo != null) {
                for (Map.Entry<String, String> entry : this.connectorInfo.entrySet()) {
                    json.put("connector." + entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public String getFormattedMessage() {
        return null;
    }

    public String getFormat() {
        return null;
    }

    public Object[] getParameters() {
        return new Object[0];
    }

    public Throwable getThrowable() {
        return null;
    }

    public String getSourceElementLocation() {
        return this.sourceElementLocation;
    }

    public void setSourceElementLocation(String sourceElementLocation) {
        this.sourceElementLocation = sourceElementLocation;
    }

    public String getSourceElementXml() {
        return this.sourceElementXml;
    }

    public void setSourceElementXml(String sourceElementXml) {
        this.sourceElementXml = sourceElementXml;
    }

    public String getMessageSourceUri() {
        return this.messageSourceUri;
    }

    public void setMessageSourceUri(String messageSourceUri) {
        this.messageSourceUri = messageSourceUri;
    }

    public String getMessageSourceName() {
        return this.messageSourceName;
    }

    public void setMessageSourceName(String messageSourceName) {
        this.messageSourceName = messageSourceName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public String getFlowFileName() {
        return this.flowFileName;
    }

    public void setFlowFileName(String flowFileName) {
        this.flowFileName = flowFileName;
    }

    public String getFlowFileLine() {
        return this.flowFileLine;
    }

    public void setFlowFileLine(String flowFileLine) {
        this.flowFileLine = flowFileLine;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "RequestResponseLogMessage{type=" + (Object)((Object)this.type) + ", request=" + this.request + ", response=" + this.response + ", sourceElementLocation='" + this.sourceElementLocation + '\'' + ", sourceElementXml='" + this.sourceElementXml + '\'' + ", messageSourceUri='" + this.messageSourceUri + '\'' + ", messageSourceName='" + this.messageSourceName + '\'' + ", flowName='" + this.flowName + '\'' + ", flowFileName='" + this.flowFileName + '\'' + ", flowFileLine='" + this.flowFileLine + '\'' + ", connectorClass='" + this.connectorClass + '\'' + ", connectorInfo=" + this.connectorInfo + ", duration=" + this.duration + '}';
    }

    public static enum Type {
        INBOUND,
        OUTBOUND;

    }
}

