package brickhouse.hbase;

/**
 * Copyright 2012 Klout, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **/

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

public class HbaseScanUDTF extends GenericUDTF {
	private Map<String,String> config;
	private String[] columns;

	@Override
	public void close() throws HiveException {
		try {
			getTable().close();
		} catch (IOException e) {
			throw new HiveException(e);
		}
	}

	@Override
	public StructObjectInspector initialize(ObjectInspector[] arg0)
			throws UDFArgumentException {
		
	    ObjectInspector configInspector = arg0[0];
		config = HTableFactory.getConfigFromConstMapInspector(configInspector);
		
		String[] columns = config.get( HTableFactory.FAMILY_TAG).split(",");
		List columnList = new ArrayList();
		columnList.add("key");
		columnList.addAll(Arrays.asList(columns));
		
		List colInspectors = new ArrayList();
		for(int i=0;i< columnList.size(); ++i) {
			colInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
		}
		
		StructObjectInspector sInspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnList, colInspectors);
		
		return sInspector;
	}

	@Override
	public void process(Object[] arg0) throws HiveException {
		try {
			Scan sc = new Scan();

			//// 
			for(String col:getColumns() ) {
				sc.addColumn( col.getBytes(), getQualifier().getBytes());
			}


			ResultScanner rs = getTable().getScanner(sc);
			Iterator<Result> rsIter = rs.iterator();
			while( rsIter.hasNext() ) {
				Result result = rsIter.next();
				List columns = getColumns(result);
				this.forward(columns);
			}
		} catch (IOException e) {
			throw new HiveException(e);

		}
	}

	public String[] getColumns() {
		String[] columns = config.get( HTableFactory.FAMILY_TAG).split(",");
		return columns;
		
	}
	public String getQualifier() {
		String qualifier = config.get( HTableFactory.QUALIFIER_TAG );
		return qualifier;
	}
	
	public List getColumns(Result res) {
		ArrayList colList = new ArrayList();
		
		String[] columns = config.get( HTableFactory.FAMILY_TAG).split(",");
		String qualifier = config.get( HTableFactory.QUALIFIER_TAG );
		for(int i=0;i<columns.length; ++i) {
			String col=columns[i];
			KeyValue cl =  res.getColumnLatest(col.getBytes(), qualifier.getBytes());
			if(i==0)
			  colList.add( new String(cl.getKey()));
			colList.add( new String(cl.getFamily()));
		}
		
		return colList;
	}
	
	public HTable getTable() throws IOException {
		return HTableFactory.getHTable(config);
	}

}
