package brickhouse.hive.serde;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
///import org.json.simple.JSONObject;
///import org.json.simple.parser.JSONParser;
///import org.json.simple.parser.ParseException;

public class FlumeJsonSerDe implements SerDe {
    /**
     * A SerDe for flume jog files.  Example usage in hql:
     * <p/>
     * DROP TABLE IF EXISTS flume_logs_test;
     * CREATE EXTERNAL TABLE IF NOT EXISTS flume_logs_test(
     * tstamp STRING,
     * ip STRING,
     * session_id BIGINT,
     * project STRING,
     * event STRING,
     * username STRING,
     * ref STRING
     * )
     * PARTITIONED BY (dt STRING)
     * ROW FORMAT SERDE 'com.klout.internal_store.hive.SerDe.flume.FlumeJsonSerDe'
     * STORED AS TEXTFILE
     * LOCATION '/logs/events'
     * TBLPROPERTIES ("mappings"="tstamp:timestamp");
     * <p/>
     * "mappings" is a comma separated list of colon separated pairs consisting of
     * the name of the column in the table followed by the corresponding key in the
     * JSON object. If no mapping is found it will attempt to find all the column names
     * in the JSON.
     */

    private static class ValueMapper {
        private static Map<Object, Object> ValueMap = new HashMap<Object, Object>();

        static {
            ValueMap.put("impression", "impressions");
        }

        /**
        public void map(JSONObject json, Object key) {
            Object value = json.get(key);
            if (value != null) {
                Object mappedValue = ValueMap.get(value);
                if (mappedValue != null) {
                    json.remove(key);
                    json.put(key, mappedValue);
                }
            }
        }
        **/
    }

    private static ValueMapper valueMapper = new ValueMapper();
    private static final Logger LOG = Logger.getLogger(FlumeJsonSerDe.class);
    private int numColumns;
    private StructObjectInspector rowOI;
    private List<String> columnNames;
    private Map<String, String> tableToJson;
    private Map<String, String> jsonToTable;
    private List<TypeInfo> columnTypes;

    @Override
    public Object deserialize(Writable writable) throws SerDeException {
        // LOG.error("start deserialization");
        ///try {
            String text = ((Text) writable).toString();
            String splits[] = text.split("\\t", 2);
            String timestamp = splits[0];
            String jsonText = splits[1];
            ///JSONObject json = null;
            try {

    		    ObjectMapper jacksonParser = new ObjectMapper();
    			JsonNode json = jacksonParser.readTree( jsonText);
                ///json = (JSONObject) new JSONParser().parse(jsonText);
                ///json.put("timestamp", timestamp);
                ///valueMapper.map(json, "project");

    			/**
                if (columnNames.contains("json_keys")) {
                    List<Object> jsonKeys = new ArrayList<Object>();
                    for (Object keyObj : json.keySet()) {
                        jsonKeys.add(keyObj.toString());
                    }
                    json.put("json_keys", jsonKeys);
                }

                if (columnNames.contains("json_values")) {
                    List<Object> jsonVals = new ArrayList<Object>();
                    for (Object keyObj : json.keySet()) {
                        if (!keyObj.toString().equals("json_keys")) {
                            Object value = json.get(keyObj);
                            Object finalValue = null;
                            if (value != null) {
                                finalValue = value.toString();
                            }

                            jsonVals.add(finalValue);
                        }
                    }
                    // LOG.error(jsonVals);
                    json.put("json_values", jsonVals);

                }

                if (columnNames.contains("json_text")) {
                    //json.put("json_text",jsonText);

                }
                **/
            } catch (Throwable e) {
                // LOG.error(" Unable to parse JSON text  " + writable, e);
                e.printStackTrace();
                //// For now, drop the record and move on ...
                //// If we had access to a Reporter, we could increment a Counter
                List<Object> result = new ArrayList<Object>();
                for (int i = 0; i < columnNames.size(); ++i) {
                    result.add(null);
                }
                return result;
            }
            List<Object> result = new ArrayList<Object>();
            /**
            for (int i = 0; i < numColumns; i++) {
                // LOG.error("Processing column: " + i + " name: " + columnNames.get(i));
                String columnName = columnNames.get(i);
                Object value = json.get(tableToJson.containsKey(columnName) ? tableToJson.get(columnName) : columnName);
                if (value != null) {
                    TypeInfo type = columnTypes.get(i);
                    if (type.getTypeName().equals(Constants.BIGINT_TYPE_NAME) && !(value instanceof Long)) {
                        try {
                            // LOG.error("ParseLong" + value + " type: " + value.getClass().getSimpleName());
                            value = Long.parseLong(value.toString());
                        } catch (Throwable t) {
                            // LOG.error("ParseLong failed" + value + " type: " + value.getClass().getSimpleName());
                            value = null;
                        }
                    } else if (type.getTypeName().equals(Constants.STRING_TYPE_NAME) && !(value instanceof String)) {
                        // LOG.error("ToString" + value + " type: " + value.getClass().getSimpleName());
                        value = value.toString();
                    }
                }
                **/

                //result.add(value);
            //}

            // LOG.error("done deserialization" + result);

            //return result;
        ///} catch (Throwable t) {
            // LOG.error(t);
            /**
            List<Object> result = new ArrayList<Object>();
            for (int i = 0; i < columnNames.size(); ++i) {
                result.add(null);
            }
            return result;
        }
        **/
            return null;
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return rowOI;
    }

    @Override
    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        try {
            // LOG.error("initialize");

            // We can get the table definition from tbl.
            ///String columnNameProperty = tbl.getProperty(Constants.LIST_COLUMNS);
            //String columnTypeProperty = tbl.getProperty(Constants.LIST_COLUMN_TYPES);

            // Parse the configuration parameters
            ///columnNames = Arrays.asList(columnNameProperty.split(","));
            ///columnTypes = TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
            assert columnNames.size() == columnTypes.size();
            numColumns = columnNames.size();

            // LOG.error("setup json table mappings");
            // Construct the mappings for column names that differ from the json keys
            tableToJson = new HashMap<String, String>();
            jsonToTable = new HashMap<String, String>();
            String mappings = (String) tbl.get("mappings");
            // LOG.info("Override mappings: " + mappings);
            if (mappings != null && !"".equals(mappings)) {
                for (String pair : mappings.split(",")) {
                    String[] split = pair.split(":");
                    tableToJson.put(split[0], split[1]);
                    jsonToTable.put(split[1], split[0]);
                }
            }
            // LOG.error("done setup json table mappings");

            // Constructing the row ObjectInspector:
            // The row will contain java primitives corresponding to Json value types
            List<ObjectInspector> columnOIs = new ArrayList<ObjectInspector>(columnNames.size());
            for (int c = 0; c < numColumns; c++) {
                try {
                    columnOIs.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(((PrimitiveTypeInfo) columnTypes.get(c)).getPrimitiveCategory()));
                } catch (ClassCastException classCast) {
                    /// TODO: better handling of json keys field
                    // LOG.error(" Ignoring class cast exception for column " + columnNames.get(c));
                    columnOIs.add(ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.javaStringObjectInspector));
                }
            }

            // LOG.error("setting up rowOI");
            // StandardStruct uses ArrayList to store the row.
            rowOI = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, columnOIs);

            // LOG.error("done setting up rowOI");

            outputRowText = new Text();
        } catch (Throwable t) {
            t.printStackTrace();
            // LOG.error(t);
            throw new SerDeException(t);
        }

        // LOG.error("done init");

    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    Text outputRowText;

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector)
            throws SerDeException {
        throw new SerDeException("serialization into a protobuf object not yet supported");


        // Get all the fields out.
        // NOTE: The correct way to get fields out of the row is to use
        // objInspector.
        // The obj can be a Java ArrayList, or a Java class, or a byte[] or
        // whatever.
        // The only way to access the data inside the obj is through
        // ObjectInspector.
/*
        StructObjectInspector outputRowOI = (StructObjectInspector) objInspector;
        List<? extends StructField> outputFieldRefs = outputRowOI
                .getAllStructFieldRefs();
        JSONObject json = new JSONObject();
        // Get all data out.
        for (int c = 0; c < numColumns; c++) {
            Object field = outputRowOI.getStructFieldData(obj,
                    outputFieldRefs.get(c));
            ObjectInspector fieldOI = outputFieldRefs.get(c)
                    .getFieldObjectInspector();
            // The data must be of type String
            StringObjectInspector fieldStringOI = (StringObjectInspector) fieldOI;
            // Convert the field to Java class String, because objects of String
            // type
            // can be
            // stored in String, Text, or some other classes.
            String columnName = columnNames.get(c);
            json.put(jsonToTable.containsKey(columnName) ? jsonToTable.get(columnName) : columnName, fieldStringOI.getPrimitiveJavaObject(field));
        }

        // Format the String
        outputRowText.set(json.get("timestamp") + "\t" + json.toJSONString());
        return outputRowText;*/
    }

	@Override
	public SerDeStats getSerDeStats() {
		// TODO Auto-generated method stub
		return null;
	}
}
