package brickhouse.udf.sanity;
/**
 * Copyright 2012 Klout, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **/


import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.log4j.Logger;

/**
 *  UDF to throw an error if some assertion is not met.
 *  
 *
 */
public class ThrowErrorUDF extends UDF {
	private static final Logger LOG = Logger.getLogger(ThrowErrorUDF.class);
	
	
	public String evaluate(String errorMessage) {
		LOG.error("Assertion not met :: " + errorMessage);
		System.err.println("Assertion not met :: " + errorMessage);
		
		throw new RuntimeException( errorMessage);
	}

}
