/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.analytics.uniques;

import brickhouse.analytics.uniques.ICountDistinct;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SketchSet
implements ICountDistinct {
    static final int SIZEOF_LONG = 64;
    public static int DEFAULT_MAX_ITEMS = 5000;
    private int maxItems = DEFAULT_MAX_ITEMS;
    private TreeMap<Long, String> sortedMap;
    private static HashFunction HASH = Hashing.md5();

    public SketchSet() {
        this.sortedMap = new TreeMap();
    }

    public SketchSet(int max) {
        this.maxItems = max;
        this.sortedMap = new TreeMap();
    }

    public void addHashItem(long hash, String str) {
        if (this.sortedMap.size() < this.maxItems) {
            this.sortedMap.put(hash, str);
        } else {
            long maxHash;
            Long hashLong = hash;
            if (!this.sortedMap.containsKey(hashLong) && hash < (maxHash = this.sortedMap.lastKey().longValue())) {
                this.sortedMap.remove(maxHash);
                this.sortedMap.put(hashLong, str);
            }
        }
    }

    public void addHash(long hash) {
        this.addHashItem(hash, Long.toString(hash));
    }

    @Override
    public void addItem(String str) {
        HashCode hc = HASH.hashString((CharSequence)str);
        this.addHashItem(hc.asLong(), str);
    }

    public List<String> getMinHashItems() {
        return new ArrayList<String>(this.sortedMap.values());
    }

    public SortedMap<Long, String> getHashItemMap() {
        return this.sortedMap;
    }

    public List<Long> getMinHashes() {
        return new ArrayList<Long>(this.sortedMap.keySet());
    }

    public void clear() {
        this.sortedMap.clear();
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public long lastHash() {
        return this.sortedMap.lastKey();
    }

    public String lastItem() {
        return this.sortedMap.lastEntry().getValue();
    }

    @Override
    public double estimateReach() {
        if (this.sortedMap.size() < this.maxItems) {
            return this.sortedMap.size();
        }
        long maxHash = this.sortedMap.lastKey();
        return SketchSet.EstimatedReach(maxHash, this.maxItems);
    }

    public static double EstimatedReach(String lastItem, int maxItems) {
        long maxHash = HASH.hashString((CharSequence)lastItem).asLong();
        return SketchSet.EstimatedReach(maxHash, maxItems);
    }

    public static double EstimatedReach(long maxHash, int maxItems) {
        BigDecimal maxHashShifted = new BigDecimal(BigInteger.valueOf(maxHash).add(BigInteger.valueOf(Long.MAX_VALUE)));
        BigDecimal bigMaxItems = new BigDecimal(maxItems * 2).multiply(BigDecimal.valueOf(Long.MAX_VALUE));
        BigDecimal ratio = bigMaxItems.divide(maxHashShifted, RoundingMode.HALF_EVEN);
        return ratio.doubleValue();
    }

    public long calculateSimHash() {
        int pos;
        long mask;
        int[] sumTable = new int[64];
        for (long hash : this.getHashItemMap().keySet()) {
            mask = 1L;
            for (pos = 0; pos < 64; ++pos) {
                if ((hash & mask) != 0L) {
                    int n = pos;
                    sumTable[n] = sumTable[n] + 1;
                } else {
                    int n = pos;
                    sumTable[n] = sumTable[n] - 1;
                }
                mask <<= 1;
            }
        }
        long simHash = 0L;
        mask = 1L;
        for (pos = 0; pos < 64; ++pos) {
            if (sumTable[pos] > 0) {
                simHash |= mask;
            }
            mask <<= 1;
        }
        return simHash;
    }

    public void combine(SketchSet other) {
        for (Map.Entry<Long, String> entry : other.sortedMap.entrySet()) {
            this.addHashItem(entry.getKey(), entry.getValue());
        }
    }
}

