/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.hbase;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;

@Description(name="hbase_balanced_key", value="_FUNC_(keyStr,numRegions) - Returns an HBase key balanced evenly across regions")
public class BalancedKeySaltUDF
extends UDF {
    public String evaluate(String keyStr, int numRegions) {
        int sumChars = 0;
        for (int i = 0; i < keyStr.length(); ++i) {
            sumChars += keyStr.charAt(i);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(sumChars % numRegions).toUpperCase());
        sb.append(':');
        sb.append(keyStr);
        return sb.toString();
    }
}

