/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.hbase;

import brickhouse.hbase.HTableFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;

@Description(name="hbase_batch_get", value="_FUNC_(table,key,family) - Do a single HBase Get on a table ")
public class BatchGetUDF
extends UDF {
    public List<String> evaluate(Map<String, String> config, List<String> keys) {
        try {
            HTableFactory.checkConfig(config);
            HTable table = HTableFactory.getHTable(config);
            ArrayList<Get> getArr = new ArrayList<Get>();
            for (int i = 0; i < keys.size(); ++i) {
                String key = keys.get(i);
                Get theGet = new Get(key.getBytes());
                getArr.add(theGet);
            }
            Result[] results = table.get(getArr);
            ArrayList<String> resultList = new ArrayList<String>();
            for (int i = 0; i < results.length; ++i) {
                Result res = results[i];
                byte[] valBytes = res.getValue(config.get(HTableFactory.FAMILY_TAG).getBytes(), config.get(HTableFactory.QUALIFIER_TAG).getBytes());
                if (valBytes != null) {
                    resultList.add(new String(valBytes));
                    continue;
                }
                resultList.add(null);
            }
            return resultList;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }
}

