/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.hbase;

import brickhouse.hbase.HTableFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.log4j.Logger;

@Description(name="hbase_batch_put", value="_FUNC_(config_map, key, value) - Perform batch HBase updates of a table ")
public class BatchPutUDAF
extends AbstractGenericUDAFResolver {
    private static final Logger LOG = Logger.getLogger(BatchPutUDAF.class);

    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        for (int i = 0; i < parameters.length; ++i) {
            LOG.info((Object)(" BATCH PUT PARAMETERS : " + i + " -- " + parameters[i].getTypeName() + " cat = " + parameters[i].getCategory()));
            System.out.println(" BATCH PUT PARAMETERS : " + i + " -- " + parameters[i].getTypeName() + " cat = " + parameters[i].getCategory());
        }
        return new BatchPutUDAFEvaluator();
    }

    public static class BatchPutUDAFEvaluator
    extends GenericUDAFEvaluator {
        private int batchSize = 10000;
        private int numPutRecords = 0;
        public static final String BATCH_SIZE_TAG = "batch_size";
        private PrimitiveObjectInspector inputKeyOI;
        private PrimitiveObjectInspector inputValOI;
        private StandardListObjectInspector listKVOI;
        private Map<String, String> configMap;
        private HTable table;

        private byte[] getFamily() {
            String famStr = this.configMap.get(HTableFactory.FAMILY_TAG);
            return famStr.getBytes();
        }

        private byte[] getQualifier() {
            String famStr = this.configMap.get(HTableFactory.QUALIFIER_TAG);
            return famStr.getBytes();
        }

        /*
         * Unable to fully structure code
         */
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            BatchPutUDAF.access$200().info((Object)(" Init mode = " + m));
            System.out.println(" Init mode = " + m);
            System.out.println(" parameters =  = " + parameters + " Length = " + parameters.length);
            this.configMap = new HashMap<String, String>();
            for (k = 0; k < parameters.length; ++k) {
                BatchPutUDAF.access$200().info((Object)("Param " + k + " is " + parameters[k]));
                System.out.println("Param " + k + " is " + parameters[k]);
            }
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.configMap = HTableFactory.getConfigFromConstMapInspector(parameters[0]);
                HTableFactory.checkConfig(this.configMap);
                this.inputKeyOI = (PrimitiveObjectInspector)parameters[1];
                this.inputValOI = (PrimitiveObjectInspector)parameters[2];
                try {
                    BatchPutUDAF.access$200().info((Object)" Initializing HTable ");
                    this.table = HTableFactory.getHTable(this.configMap);
                    if (!this.configMap.containsKey("batch_size")) ** GOTO lbl25
                    this.batchSize = Integer.parseInt(this.configMap.get("batch_size"));
                }
                catch (IOException e) {
                    throw new HiveException((Throwable)e);
                }
            } else {
                this.listKVOI = (StandardListObjectInspector)parameters[0];
            }
lbl25:
            // 3 sources

            if (m == GenericUDAFEvaluator.Mode.PARTIAL1 || m == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector));
            }
            return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            PutBuffer buff = new PutBuffer();
            this.reset(buff);
            return buff;
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            String key = this.getByteString(parameters[1], this.inputKeyOI);
            String val = this.getByteString(parameters[2], this.inputValOI);
            PutBuffer kvBuff = (PutBuffer)agg;
            kvBuff.addKeyValue(key, val);
            if (kvBuff.putList.size() >= this.batchSize) {
                this.batchUpdate(kvBuff, false);
            }
        }

        private String getByteString(Object obj, PrimitiveObjectInspector objInsp) {
            switch (objInsp.getPrimitiveCategory()) {
                case STRING: {
                    StringObjectInspector strInspector = (StringObjectInspector)objInsp;
                    return strInspector.getPrimitiveJavaObject(obj);
                }
                case BINARY: {
                    BinaryObjectInspector binInspector = (BinaryObjectInspector)objInsp;
                    return new String(binInspector.getPrimitiveJavaObject(obj));
                }
            }
            return null;
        }

        protected void batchUpdate(PutBuffer kvBuff, boolean flushCommits) throws HiveException {
            try {
                HTable htable = HTableFactory.getHTable(this.configMap);
                htable.put(kvBuff.putList);
                if (flushCommits) {
                    htable.flushCommits();
                }
                this.numPutRecords += kvBuff.putList.size();
                if (kvBuff.putList.size() > 0) {
                    LOG.info((Object)(" Doing Batch Put " + kvBuff.putList.size() + " records; Total put records = " + this.numPutRecords + " ; Start = " + new String(kvBuff.putList.get(0).getRow()) + " ; End = " + new String(kvBuff.putList.get(kvBuff.putList.size() - 1).getRow())));
                } else {
                    LOG.info((Object)" Doing Batch Put with ZERO 0 records");
                }
                kvBuff.putList.clear();
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            PutBuffer myagg = (PutBuffer)agg;
            List partialResult = this.listKVOI.getList(partial);
            ListObjectInspector subListOI = (ListObjectInspector)this.listKVOI.getListElementObjectInspector();
            List first = subListOI.getList(partialResult.get(0));
            String tableName = ((StringObjectInspector)subListOI.getListElementObjectInspector()).getPrimitiveJavaObject(first.get(0));
            this.configMap.put(HTableFactory.TABLE_NAME_TAG, tableName);
            String zookeeper = ((StringObjectInspector)subListOI.getListElementObjectInspector()).getPrimitiveJavaObject(first.get(1));
            this.configMap.put(HTableFactory.ZOOKEEPER_QUORUM_TAG, zookeeper);
            String family = ((StringObjectInspector)subListOI.getListElementObjectInspector()).getPrimitiveJavaObject(first.get(2));
            this.configMap.put(HTableFactory.FAMILY_TAG, family);
            String qualifier = ((StringObjectInspector)subListOI.getListElementObjectInspector()).getPrimitiveJavaObject(first.get(3));
            this.configMap.put(HTableFactory.QUALIFIER_TAG, qualifier);
            for (int j = 4; j < first.size(); ++j) {
                String kvStr = ((StringObjectInspector)subListOI.getListElementObjectInspector()).getPrimitiveJavaObject(first.get(j));
                String[] kvArr = kvStr.split("=");
                if (kvArr.length != 2) continue;
                this.configMap.put(kvArr[0], kvArr[1]);
            }
            for (int i = 2; i < partialResult.size(); ++i) {
                List kvList = subListOI.getList(partialResult.get(i));
                String key = ((StringObjectInspector)subListOI.getListElementObjectInspector()).getPrimitiveJavaObject(kvList.get(0));
                String val = ((StringObjectInspector)subListOI.getListElementObjectInspector()).getPrimitiveJavaObject(kvList.get(1));
                myagg.addKeyValue(key, val);
            }
            if (myagg.putList.size() >= this.batchSize) {
                this.batchUpdate(myagg, false);
            }
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer buff) throws HiveException {
            PutBuffer putBuffer = (PutBuffer)buff;
            putBuffer.reset();
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            PutBuffer myagg = (PutBuffer)agg;
            this.batchUpdate(myagg, true);
            return "Finished Batch updates ; Num Puts = " + this.numPutRecords;
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            PutBuffer myagg = (PutBuffer)agg;
            ArrayList ret = new ArrayList();
            ArrayList<String> tname = new ArrayList<String>();
            tname.add(this.configMap.get(HTableFactory.TABLE_NAME_TAG));
            tname.add(this.configMap.get(HTableFactory.ZOOKEEPER_QUORUM_TAG));
            tname.add(this.configMap.get(HTableFactory.FAMILY_TAG));
            tname.add(this.configMap.get(HTableFactory.QUALIFIER_TAG));
            for (Map.Entry<String, String> entry : this.configMap.entrySet()) {
                if (entry.getKey().equals(HTableFactory.TABLE_NAME_TAG) || entry.getKey().equals(HTableFactory.ZOOKEEPER_QUORUM_TAG) || entry.getKey().equals(HTableFactory.FAMILY_TAG) || entry.getKey().equals(HTableFactory.QUALIFIER_TAG)) continue;
                tname.add(entry.getKey() + "=" + entry.getValue());
            }
            ret.add(tname);
            for (Put thePut : myagg.putList) {
                ArrayList<String> kvList = new ArrayList<String>();
                kvList.add(new String(thePut.getRow()));
                Map familyMap = thePut.getFamilyMap();
                for (List innerList : familyMap.values()) {
                    for (KeyValue kv : innerList) {
                        kvList.add(new String(kv.getValue()));
                    }
                }
                ret.add(kvList);
            }
            return ret;
        }

        public class PutBuffer
        implements GenericUDAFEvaluator.AggregationBuffer {
            public List<Put> putList;

            public void reset() {
                this.putList = new ArrayList<Put>();
            }

            public void addKeyValue(String key, String val) throws HiveException {
                Put thePut = new Put(key.getBytes());
                thePut.add(BatchPutUDAFEvaluator.this.getFamily(), BatchPutUDAFEvaluator.this.getQualifier(), val.getBytes());
                thePut.setWriteToWAL(false);
                this.putList.add(thePut);
            }
        }
    }
}

