/*
 * Decompiled with CFR 0.152.
 */
package brickhouse.hbase;

import brickhouse.hbase.HTableFactory;
import brickhouse.udf.json.InspectorHandle;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

@Description(name="hbase_cached_get", value="_FUNC_(configMap,key,template) - Returns a cached object, given an HBase config, a key, and a template object used to interpret JSON")
public class CachedGetUDF
extends GenericUDF {
    private static final Logger LOG = Logger.getLogger(CachedGetUDF.class);
    private Cache<String, Object> cache;
    private Map<String, String> configMap;
    private StringObjectInspector strInspector;
    private InspectorHandle jsonInspectorHandle;
    private CacheLoader valueLoader = new CacheLoader<String, Object>(){

        public Object load(String key) throws Exception {
            String jsonString = this.loadString(key);
            if (++CachedGetUDF.this.numLoaded % 1000 == 0) {
                LOG.info((Object)(" loaded " + CachedGetUDF.this.numLoaded + " records; Key = " + key + " json =" + jsonString));
            }
            if (CachedGetUDF.this.jsonInspectorHandle != null) {
                ObjectMapper jacksonParser = new ObjectMapper();
                JsonNode jsonNode = jacksonParser.readTree(jsonString);
                return CachedGetUDF.this.jsonInspectorHandle.parseJson(jsonNode);
            }
            return jsonString;
        }

        public String loadString(String key) throws Exception {
            Get keyGet = new Get(key.getBytes());
            HTable htable = HTableFactory.getHTable(CachedGetUDF.this.configMap);
            Result res = htable.get(keyGet);
            KeyValue kv = res.getColumnLatest(((String)CachedGetUDF.this.configMap.get(HTableFactory.FAMILY_TAG)).getBytes(), ((String)CachedGetUDF.this.configMap.get(HTableFactory.QUALIFIER_TAG)).getBytes());
            if (kv == null) {
                throw new NoSuchElementException("No value found for " + key);
            }
            byte[] bytes = kv.getValue();
            String jsonStr = new String(bytes);
            return jsonStr;
        }
    };
    private int numLoaded = 0;
    private int numMisses = 0;
    private int numHits = 0;
    private int numErrors = 0;

    public Object evaluate(GenericUDF.DeferredObject[] arg0) throws HiveException {
        return this.getValue(this.strInspector.getPrimitiveJavaObject(arg0[1].get()));
    }

    public Object getValue(String key) {
        try {
            Object l = this.cache.get((Object)key);
            if (++this.numHits % 1000 == 0) {
                LOG.info((Object)("Retrieved " + this.numHits + " features  key = " + key + " Num misses =" + this.numMisses));
            }
            return l;
        }
        catch (UncheckedExecutionException e) {
            LOG.error((Object)"Error while parsing string ", (Throwable)e);
            if (++this.numErrors % 1000 == 0) {
                LOG.info((Object)("Num Errors = " + this.numErrors + ";  Missed " + this.numMisses + " features key = " + key + " Num hits = " + this.numHits));
            }
            return null;
        }
        catch (NoSuchElementException notThere) {
            if (++this.numMisses % 1000 == 0) {
                LOG.info((Object)("Missed " + this.numMisses + " features key = " + key + " Num hits = " + this.numHits));
            }
            return null;
        }
        catch (Exception unexpected) {
            LOG.error((Object)"Error while parsing string ", (Throwable)unexpected);
            if (++this.numErrors % 1000 == 0) {
                LOG.info((Object)("Num Errors = " + this.numErrors + "; Missed " + this.numMisses + " features key = " + key + " Num hits = " + this.numHits));
            }
            return null;
        }
    }

    public String getDisplayString(String[] arg0) {
        return "hbase_cache_array(" + arg0[0] + " , " + arg0[1] + ")";
    }

    public ObjectInspector initialize(ObjectInspector[] parameters) throws UDFArgumentException {
        this.configMap = HTableFactory.getConfigFromConstMapInspector(parameters[0]);
        this.strInspector = (StringObjectInspector)parameters[1];
        this.cache = CacheBuilder.newBuilder().build(this.valueLoader);
        if (parameters.length > 2) {
            this.jsonInspectorHandle = InspectorHandle.InspectorHandleFactory.GenerateInspectorHandle(parameters[2]);
            return this.jsonInspectorHandle.getReturnType();
        }
        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    }
}

